<?php
$subject = "Instant Logo Makers UK LOGO LP";

// Sanitize inputs
$name = htmlspecialchars($_POST['name']);
$phone = htmlspecialchars($_POST['phone']);
$email = filter_var($_POST['email'], FILTER_SANITIZE_EMAIL);
$message = htmlspecialchars($_POST['message']);

// Validate email
if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    die('Invalid email format');
}

$data = '<table style="width:100%; border: 1px solid black; border-collapse: collapse;">';
foreach ($_POST as $key => $value) {
    $_key = ucwords(str_replace('_', ' ', $key));
    $data .= '<tr><td style="border: 1px solid black; border-collapse: collapse; padding: 15px; text-align: left; font-size:15px; font-weight: 500;">' . $_key . '</td><td style="border: 1px solid black; border-collapse: collapse; padding: 15px; text-align: left; font-size:15px">' . htmlspecialchars($value) . '</td></tr>';
}
$data .= '</table>';

// Email headers
$headers = "MIME-Version: 1.0" . "\r\n";
$headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";

// Send mail
$mailSent = mail("info@instantlogomakers.co.uk", $subject, $data, $headers);

if ($mailSent) {
    header('Location: thank-you.php');
    exit();
} else {
    header('Location: error.php');
    exit();
}
?>
