// $(document).ready(function() {
//   const calendarTitle = $(".calendar .title");
//   const calendarDays = $(".calendar .days");
//   const selectedDates = new Set();

//   let currentDate = new Date();

//   function createCalendar(year, month) {
//     const firstDay = new Date(year, month, 1);
//     const lastDay = new Date(year, month + 1, 0);

//     calendarTitle.text(`${getMonthName(month)} ${year}`);
//     calendarDays.empty();

//     for (let i = 0; i < firstDay.getDay(); i++) {
//       const emptyDay = $("<div>").addClass("day");
//       calendarDays.append(emptyDay);
//     }

//     for (let i = 1; i <= lastDay.getDate(); i++) {
//       const day = $("<div>").text(i).addClass("day");

//       if (selectedDates.has(getDateString(year, month, i))) {
//         day.addClass("selected");
//       }

//       day.on("click", () => toggleDateSelection(year, month, i));

//       calendarDays.append(day);
//     }
//   }

//   function previousMonth() {
//     currentDate.setMonth(currentDate.getMonth() - 1);
//     createCalendar(currentDate.getFullYear(), currentDate.getMonth());
//   }

//   function nextMonth() {
//     currentDate.setMonth(currentDate.getMonth() + 1);
//     createCalendar(currentDate.getFullYear(), currentDate.getMonth());
//   }

//   function toggleDateSelection(year, month, day) {
//     const dateString = getDateString(year, month, day);

//     if (selectedDates.has(dateString)) {
//       selectedDates.delete(dateString);
//     } else {
//       selectedDates.add(dateString);
//     }

//     createCalendar(year, month);
//   }

//   function getDateString(year, month, day) {
//     return `${year}-${padZero(month + 1)}-${padZero(day)}`;
//   }

//   function getMonthName(month) {
//     const months = [
//       "January", "February", "March", "April", "May", "June",
//       "July", "August", "September", "October", "November", "December"
//     ];

//     return months[month];
//   }

//   function padZero(number) {
//     return number.toString().padStart(2, "0");
//   }

//   createCalendar(currentDate.getFullYear(), currentDate.getMonth());

//   $(".prev").on("click", previousMonth);
//   $(".next").on("click", nextMonth);
// });

$(document).ready(function() {
  const calendarTitle = $(".calendar .title");
  const calendarDays = $(".calendar .days");
  const selectedDates = new Set();

  let currentDate = new Date();

  function createCalendar(year, month) {
    const firstDay = new Date(year, month, 1);
    const lastDay = new Date(year, month + 1, 0);
    const weekdays = ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'];
    const startingDayIndex = firstDay.getDay();

    calendarTitle.text(`${getMonthName(month)} ${year}`);
    calendarDays.empty();

    for (let i = 0; i < startingDayIndex; i++) {
      const emptyDay = $("<div>").addClass("day");
      calendarDays.append(emptyDay);
    }

    for (let i = 1; i <= lastDay.getDate(); i++) {
      const day = $("<div>").text(i).addClass("day");

      if (selectedDates.has(getDateString(year, month, i))) {
        day.addClass("selected");
      }

      day.on("click", () => toggleDateSelection(year, month, i));

      calendarDays.append(day);
    }
  }

  function previousMonth() {
    currentDate.setMonth(currentDate.getMonth() - 1);
    createCalendar(currentDate.getFullYear(), currentDate.getMonth());
  }

  function nextMonth() {
    currentDate.setMonth(currentDate.getMonth() + 1);
    createCalendar(currentDate.getFullYear(), currentDate.getMonth());
  }

  function toggleDateSelection(year, month, day) {
    const dateString = getDateString(year, month, day);

    if (selectedDates.has(dateString)) {
      selectedDates.delete(dateString);
    } else {
      selectedDates.add(dateString);
    }

    createCalendar(year, month);
  }

  function getDateString(year, month, day) {
    return `${year}-${padZero(month + 1)}-${padZero(day)}`;
  }

  function getMonthName(month) {
    const months = [
      "January", "February", "March", "April", "May", "June",
      "July", "August", "September", "October", "November", "December"
    ];

    return months[month];
  }

  function padZero(number) {
    return number.toString().padStart(2, "0");
  }

  createCalendar(currentDate.getFullYear(), currentDate.getMonth());

  $(".prev").on("click", previousMonth);
  $(".next").on("click", nextMonth);
});

// $(document).ready(function() {
//   $('.rd-btn').on('click', function() {
//     const forId = $(this).attr('id');
//     const associatedLabel = $('label[for="' + forId + '"]');

//     if ($(this).prop('checked')) {
//       associatedLabel.addClass('selected');
//     } else {
//       associatedLabel.removeClass('selected');
//     }
//   });
// });

$(document).ready(function() {
  let previousRadio = null;
  let previousLabel = null;

  $('.rd-btn').on('click', function() {
    const forId = $(this).attr('id');
    const associatedLabel = $('label[for="' + forId + '"]');

    if (previousRadio !== null && previousLabel !== null) {
      previousLabel.removeClass('selected');
    }

    if ($(this).prop('checked')) {
      associatedLabel.addClass('selected');
    } else {
      associatedLabel.removeClass('selected');
    }

    // Update the previous radio and label to the current ones
    previousRadio = $(this);
    previousLabel = associatedLabel;
  });

  $('.toggle-button').on('click', function() {
    const $targetContent = $(this).next('.hide-form');

    if ($targetContent.is(':visible')) {
      $targetContent.hide();
      $(this).show();
    } else {
      $targetContent.show();
      $(this).hide();
    }
  });
});


// $(document).ready(function() {
//   var currentStep = 0;
//   var form = $('#myForm');
//   var steps = $('.progress-indicator > .step');
//   var prevBtn = form.find('.prev-btn');
//   var nextBtn = form.find('.next-btn');
//   var progressIndicator = $('.progress-indicator');

//   showStep(currentStep);

//   function showStep(stepIndex) {
//       $('.step-form').hide();
//       $('.step-form').eq(stepIndex).show();

//       if (stepIndex === 0) {
//           prevBtn.hide();
//       } else {
//           prevBtn.show();
//       }

//       if (stepIndex === steps.length - 1) {
//           nextBtn.hide();
//       } else {
//           nextBtn.show();
//       }

//       updateProgress(stepIndex);
//   }

//   function updateProgress(stepIndex) {
//     for (var i = 0; i < steps.length; i++) {
//       var step = $(steps[i]);
//       var stepNumber = step.find('.step-number');

//       if (i < stepIndex) {
//         step.addClass('completed');
//         stepNumber.html('<i class="fas fa-check"></i>');
//       } else if (i === stepIndex) {
//         step.removeClass('completed');
//         stepNumber.text(i + 1);
//       } else {
//         step.removeClass('completed');
//         stepNumber.text(i + 1);
//       }
//     }
//   }

//   prevBtn.on('click', function(e) {
//       e.preventDefault();
//       currentStep--;
//       showStep(currentStep);
//   });

//   nextBtn.on('click', function(e) {
//       e.preventDefault();
//       if (validateForm()) {
//           currentStep++;
//         showStep(currentStep);
//         // Show thank you page when the form is submitted successfully
//         if (currentStep === steps.length) {
//           form.hide();
//           $('.thank-you-page').show();
//           updateProgress(currentStep); // Add completed class to the last step number
//         }
//       }
//   });

//   function validateForm() {
//       var currentForm = $('.step-form').eq(currentStep);
//       var input = currentForm.find('input[type="text"], input[type="email"], input[type="password"]');
//       var isValid = true;

//       input.each(function() {
//           var inputField = $(this);
//           if (inputField.val() === '') {
//               inputField.addClass('invalid');
//               isValid = false;
//           } else {
//               inputField.removeClass('invalid');
//           }
//       });

//       return isValid;
//   }

//   form.on('submit', function(e) {
//     e.preventDefault();
//     if (validateForm()) {
//       // Perform final form submission here (you can use AJAX here to submit the form to the server)

//       // Show thank you page when the form is submitted successfully
//       form.hide();
//       $('.thank-you-page').show();
//       updateProgress(currentStep); // Add completed class to the last step number
//     }
//       // if (validateForm()) {
//       //     // Perform final form submission here
//       //     alert('Form submitted successfully!');
//       //     form[0].reset(); // Reset the form after successful submission
//       //     showStep(0); // Reset to the first step
//       // }
//   });
// });


$(document).ready(function() {
  var currentStep = 0;
  var form = $('#myForm');
  var steps = $('.progress-indicator > .step');
  var prevBtn = form.find('.prev-btn');
  var nextBtn = form.find('.next-btn');
  var progressIndicator = $('.progress-indicator');

  showStep(currentStep);

  function showStep(stepIndex) {
    $('.step-form').hide();
    $('.step-form').eq(stepIndex).show();

    if (stepIndex === 0) {
      prevBtn.hide();
    } else {
      prevBtn.show();
    }

    if (stepIndex === steps.length - 1) {
      nextBtn.hide();
    } else {
      nextBtn.show();
    }

    updateProgress(stepIndex);
  }

  function updateProgress(stepIndex) {
    for (var i = 0; i < steps.length; i++) {
      var step = $(steps[i]);
      var stepNumber = step.find('.step-number');

      if (i < stepIndex) {
        step.addClass('completed');
        stepNumber.html('<i class="fas fa-check"></i>');
      } else if (i === stepIndex) {
        step.removeClass('completed');
        stepNumber.text(i + 1);
      } else {
        step.removeClass('completed');
        stepNumber.text(i + 1);
      }
    }
  }

  prevBtn.on('click', function(e) {
    e.preventDefault();
    currentStep--;
    showStep(currentStep);
  });

  nextBtn.on('click', function(e) {
    e.preventDefault();
    if (validateForm()) {
      currentStep++;
      showStep(currentStep);

      // Show thank you page when the form is submitted successfully
      if (currentStep === steps.length) {
        form.hide();
        $('.thank-you-page').show();
      }
    }
  });

  function validateForm() {
    var currentForm = $('.step-form').eq(currentStep);
    var input = currentForm.find('input[type="text"], input[type="email"], input[type="password"]');
    var isValid = true;

    input.each(function() {
      var inputField = $(this);
      if (inputField.val() === '') {
        inputField.addClass('invalid');
        isValid = false;
      } else {
        inputField.removeClass('invalid');
      }
    });

    return isValid;
  }

  form.on('submit', function(e) {
    e.preventDefault();
    if (validateForm()) {
      // Perform final form submission here (you can use AJAX here to submit the form to the server)

      // Show thank you page when the form is submitted successfully
      form.hide();
      $('.thank-you-page').show();
    }
  });
});