<?php $logo_dark = DB::table('logo')->where('slug', 'logo_dark')->where('tag', 'logo_fav')->first(); ?>
<html lang="en">

<head>
    <!--  HEAD    -->
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Appointment Inquiry</title>
    <style>
        body {
            font-family: Poppins, sans-serif;
            padding: 20px;
            background: #f1f1f1;
        }

        .container {
            background-color: #000000;
            width: 80%;
            max-width: 600px;
            margin-left: auto;
            margin-right: auto;
        }

        .inner_container {
            background-color: #ffffff;
            padding: 50px;
        }

        header,
        footer {
            text-align: center;
        }

        .email_inner_section {
            padding: 20px 0 50px 0;
        }

        hr {
            height: 5px;
            background-color: brown;
            border-color: brown;
        }

        h1 {
            color: brown;
        }

        .enquiry_submission table {
            text-align: left;
            margin-top: 50px;
        }

        .enquiry_submission table tbody tr th {
            width: 30%;
            vertical-align: top;
        }

        .enquiry_submission th,
        .enquiry_submission td {
            padding: 10px;
            margin: 0;
        }

        .enquiry_submission th {
            color: brown;
            font-weight: 900;
        }

        .enquiry_submission td {
            font-weight: 100;
        }

        .email_footer {
            font-size: 10px;
            color: #ffffff;
            padding: 20px 0;
        }

        .email_footer a {
            color: #ffffff;
            text-decoration: none;
        }

        @media  only screen and (max-width:500px) {

            .enquiry_submission th,
            .enquiry_submission td {
                display: block;
                width: 100% !important;
            }
        }
    </style>
</head>
<!-- BODY   -->

<body>
    <div class="container">
        <div class="inner_container">
            <header>
                <img src="<?php echo e(asset($logo_dark->value ?? '')); ?>" width="100px" />
                <h1>Appointment</h1>
            </header>
            <hr>
            <div class="email_content">
                <div class="email_inner_section">
                    <section>
                        <?php if($roletype == 4): ?>
                            <h3>Hi Holistic provider <strong><?php echo e($provider); ?></strong>, you have a new appointment
                                from <strong><?php echo e($name); ?></strong>.</h3>
                        <?php else: ?>
                            <h3>Hi Holistic patient <strong><?php echo e($name); ?></strong>, your appointment has been
                                scheduled with <strong><?php echo e($provider); ?></strong>.</h3>
                        <?php endif; ?>
                    </section>
                    <section class="enquiry_submission">
                        <h3>Apppointment Detail</h3>
                        <table>
                            <tbody>
                                <tr>
                                    <th>Name</th>
                                    <td><?php echo e($name ?? ''); ?></td>
                                </tr>
                                <tr>
                                    <th>Email</th>
                                    <td><?php echo e($email ?? ''); ?></td>
                                </tr>
                                <tr>
                                    <th>Phone Number</th>
                                    <td><?php echo e($number ?? ''); ?></td>
                                </tr>
                                <tr>
                                    <th>Date</th>
                                    <td><?php echo e($appointmentdate ? \Carbon\Carbon::parse($appointmentdate)->format('M d, Y') : ''); ?>

                                    </td>
                                </tr>
                                <tr>
                                    <th>Time</th>
                                    <td><?php echo e($appointmenttime ? \Carbon\Carbon::parse($appointmenttime)->format('h:i A') : ''); ?>

                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </section>
                </div>
            </div>
        </div>
        <!--   Footer     -->
        <footer>
            <section class="email_footer">
                <img src="<?php echo e(asset($logo_dark->value ?? '')); ?>" width="100px" />
                <p>
                    <a href="#">companylorem.com</a>
                </p>
                <!--<p>Address 1, 123 Road, MY</p>-->
                <p>Copyright &copy;
                    <script>
                        document.write(new Date().getFullYear())
                    </script> Holistic All Rights Reserved
                </p>
            </section>
        </footer>
        <!--   footer ends     -->
    </div>
</body>

</html>
<?php /**PATH D:\xampp\htdocs\Ahmed-Shoaib\laravel-projects\holistic-Laravel\resources\views/web/pages/mailing/memberAppointmentMail.blade.php ENDPATH**/ ?>