<?php $logo_dark = DB::table('logo')->where('slug', 'logo_dark')->where('tag', 'logo_fav')->first(); ?>
<?php $service = DB::table('services')->where('is_active', 1)->where('is_deleted', 0)->get(); ?>

<header class="main-header">
    <div class="h-one">
        <div class="container d-flex justify-content-between">
            <div class="header-top">
                <div class="header-text">
                    <p> <span>🏠</span> Call us today, to receive FREE Immunity boosting teabag</p>
                </div>
                <div class="header-icon">
                    <i class="fa-brands fa-facebook-f icons"></i>
                    <i class="fa-brands fa-twitter icons"></i>
                    <i class="fa-brands fa-pinterest icons"></i>
                    <i class="fa-brands fa-linkedin-in icons"></i>
                    <i class="fa-brands fa-telegram icons"></i>
                </div>
            </div>
        </div>
        <div class="h-two">
            <div class="container">
                <nav class="navbar navbar-expand-lg">
                    <a class="navbar-brand" href="<?php echo e(route('web.home')); ?>">
                        <img src="<?php echo e(asset($logo_dark->value ?? '')); ?>" alt="logo" class="img-fluid logo">
                    </a>
                    <button class="navbar-toggler" type="button" data-bs-toggle="collapse"
                        data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent"
                        aria-expanded="false" aria-label="Toggle navigation">
                        <span class="navbar-toggler-icon"></span>
                    </button>
                    <div class="collapse navbar-collapse" id="navbarSupportedContent">
                        <ul class="navbar-nav">
                            <li class="nav-item">
                                <a class="nav-link active" aria-current="page" href="<?php echo e(route('web.home')); ?>">HOME</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="<?php echo e(route('web.Aboutus')); ?>">ABOUT US</a>
                            </li>

                            <li class="nav-item">
                                <a class="nav-link" href="<?php echo e(route('web.Providers')); ?>">Providers</a>
                            </li>

                            <li class="nav-item">
                                <a class="nav-link" href="<?php echo e(route('web.Pricing')); ?>">Pricing</a>
                            </li>

                            <li class="nav-item dropdown">
                                <a class="nav-link dropdown-toggle" href="<?php echo e(route('web.Services')); ?>"
                                    id="navbarDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                                    SERVICES
                                </a>
                                <ul class="dropdown-menu" aria-labelledby="navbarDropdown">
                                    <li><a class="dropdown-item" href="<?php echo e(route('web.Services')); ?>">Our Service</a></li>
                                    <?php $__currentLoopData = $service; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li>
                                            <a class="dropdown-item" href="<?php echo e(route('web.ServicesDetail', $item->slug)); ?>"><?php echo e($item->title); ?></a>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="<?php echo e(route('web.Contact')); ?>">CONTACT US</a>
                            </li>
                        </ul>
                        <div class="navbar-buttons">
                            <?php if(Auth::user()): ?>
                                <a class="popup-btn" href="<?php echo e(route('admin.home')); ?>" target="_blank">Dashboard</a>
                                <a href="<?php echo e(route('logout')); ?>" class="popup-btn">Logout</a>
                            <?php else: ?>
                                <a href="<?php echo e(route('web.Login')); ?>" class="popup-btn">Sign up/log in</a>
                                <a href="<?php echo e(route('web.Consulting')); ?>" class="popup-btn">Make appointment</a>
                            <?php endif; ?>
                        </div>
                    </div>
                </nav>
            </div>
        </div>
    </div>
</header>
<?php /**PATH /home/demowebsitedesig/holistic.demo-websitedesigns.com/resources/views/web/layouts/header.blade.php ENDPATH**/ ?>