<?php $__env->startSection('content'); ?>
    <div class="ms-content-wrapper">
        <div class="row">
            <div class="col-md-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb pl-0">
                        <li class="breadcrumb-item"><a href="javascript:;"><i class="material-icons">home</i> Home</a></li>
                        <li class="breadcrumb-item"><a href="javascript:;"><?php echo e($title); ?></a></li>
                    </ol>
                </nav>
                <div class="ms-panel">
                    <div class="ms-panel-header ms-panel-custome">
                        <h6><?php echo e($title); ?></h6>
                    </div>
                    <div class="ms-panel-body">
                        <div class="medication-pofile">
                            <h3>Problems & Conditions</h3>
                            <p><?php echo e($medication->problem_condition ?? 'No data available'); ?></p>

                            <h3>Current Medications</h3>
                            <p><?php echo e($medication->current_medication ?? 'No data available'); ?></p>

                            <h3>Current Supplements</h3>
                            <p><?php echo e($medication->current_supplement ?? 'No data available'); ?></p>

                            <h3>Notes & Charts</h3>
                            <p><?php echo e($medication->notes ?? 'No data available'); ?></p>

                            <h3>Allergies & Red flags</h3>
                            <p><?php echo e($medication->allergies_redflag ?? 'No data available'); ?></p>
                        </div>
                        <div class="medication-pofile">
                            <h3>Future Appointments</h3>

                            <div class="table-responsive">
                                <table class="table table-striped thead-primary w-100 dataTable-main appointmentData">
                                    <thead>
                                        <tr>
                                            <th scope="col">#</th>
                                            <th scope="col">Name</th>
                                            <th scope="col">Phone Number</th>
                                            <th scope="col">SSN</th>
                                            <th scope="col">Appointment Date & Time</th>
                                            <th scope="col">Appointment Problem</th>
                                            <th scope="col">Status</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $futureAppointments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <th scope="row"><?php echo e($key + 1); ?></th>
                                                <td><?php echo e($item->name ?? ''); ?></td>
                                                <td>
                                                    <?php if(empty($item->phone_number)): ?>
                                                        <?php echo e($item->user->phone ?? '-'); ?>

                                                    <?php else: ?>
                                                        <?php echo e($item->phone_number ?? '-'); ?>

                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <?php if(empty($item->social_security_number)): ?>
                                                        <?php echo e($item->user->social_security_number ?? '-'); ?>

                                                    <?php else: ?>
                                                        <?php echo e($item->social_security_number ?? '-'); ?>

                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <ul class="formatTime">
                                                        <li>
                                                            <h4>Date</h4>
                                                            <p><?php echo e($item->appointment_date ? \Carbon\Carbon::parse($item->appointment_date)->format('M d, Y') : ''); ?>

                                                            </p>
                                                        </li>
                                                        <li>
                                                            <h4>Time</h4>
                                                            <p><?php echo e($item->appointment_time ? \Carbon\Carbon::parse($item->appointment_time)->format('h:i A') : ''); ?>

                                                            </p>
                                                        </li>
                                                    </ul>
                                                </td>
                                                <td><?php echo e($item->problem ?? ''); ?></td>
                                                <td>
                                                    <?php if($item->status == 'pending'): ?>
                                                        <h2 class="main-status pending">Pending</h2>
                                                    <?php elseif($item->status == 'cancel'): ?>
                                                        <h2 class="main-status cancel">Cancel</h2>
                                                    <?php elseif($item->status == 'completed'): ?>
                                                        <h2 class="main-status completed">Completed</h2>
                                                    <?php else: ?>
                                                        <h2 class="main-status approve">Approve</h2>
                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <div class="medication-pofile">
                            <h3>Orders</h3>

                            <div class="table-responsive">
                                <table class="table table-striped thead-primary w-100 dataTable-main">
                                    <thead>
                                        <tr>
                                            <th scope="col">#</th>
                                            <th scope="col">Price</th>
                                            <th scope="col">Description</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $order; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <th scope="row"><?php echo e($key + 1); ?></th>
                                                <td>$<?php echo e(number_format($item->amount, 2) ?? ''); ?></td>
                                                <td><?php echo $item->description ?? ''; ?></td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\Ahmed-Shoaib\laravel-projects\holistic-Laravel\resources\views/admin/pages/patient/medicationProfile.blade.php ENDPATH**/ ?>