@extends('web.layouts.master')
@section('content')
    <!-- Banner Section Start -->
    <div class="banner-sec">
        <div class="" data-aos="fade-right" data-aos-duration="1000">
            <h1 class="sec-heading fw-bold">Purchase Package</h1>
        </div>
    </div>
    <!-- Banner Section Ends -->
    <section class="main-banner">
        <div class="container">
            <div class="row justify-content-center">
                <div class="right-col col-xxl-6 col-xl-6 col-lg-6 col-md-12 col-sm-12 col-12 my-4">
                    <div class="form form-sec">
                        <div class="form-top">
                            <h2>Purchase Package</h2>
                            <h5>{{ $package->title }}</h5>
                        </div>

                        <form role="form" action="{{ route('cloverApi') }}" method="post" id="payment-form">
                            @csrf

                            <input type="hidden" name="package_id" value="{{ $package->id ?? ''}}">
                            <input type="hidden" name="amount" value="{{ $package->price ?? ''}}">
                            {{-- <div class="form-row row">
                                <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                                    <div class="form-group">
                                        <label class='control-label'>Name on Card</label>
                                        <input class='form-control' name="name" size='4' type='text' required>
                                    </div>
                                </div>
                            </div> --}}

                            <div class="form-row row mt-4">
                                <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                                    <div class="form-group required">
                                        <label class='control-label'>Card Number</label>
                                        <input autocomplete='off' name="number" class='form-control card-number' size='20'
                                            type='text'>
                                    </div>
                                </div>
                            </div>

                            <div class="form-row row mt-4">
                                <div class="col-12 col-sm-12 col-md-4 col-lg-4 col-xl-4 col-xxl-4">
                                    <div class="form-group cvc required">
                                        <label class='control-label'>CVV</label>
                                        <input autocomplete='off' name="cvv" class='form-control card-cvc' placeholder='ex. 311'
                                            size='4' type='text'>
                                    </div>
                                </div>
                                <div class="col-12 col-sm-12 col-md-4 col-lg-4 col-xl-4 col-xxl-4">
                                    <div class="form-group expiration required">
                                        <label class='control-label'>Expiration Month</label>
                                        <input class='form-control card-expiry-month' name="expmonth" placeholder='MM' size='2'
                                            type='text' required>
                                    </div>
                                </div>
                                <div class="col-12 col-sm-12 col-md-4 col-lg-4 col-xl-4 col-xxl-4">
                                    <div class="form-group expiration required">
                                        <label class='control-label'>Expiration Year</label>
                                        <input class='form-control card-expiry-year' name="expyear" placeholder='YYYY' size='4'
                                            type='text' required>
                                    </div>
                                </div>
                            </div>

                            {{-- <div class="form-row row">
                                <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                                    <div class="error form-group hide">
                                        <div class='alert-danger alert'>Please correct the errors and try
                                            again.</div>
                                    </div>
                                </div>
                            </div> --}}

                            <div class="row mt-4">
                                <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                                    <button class="btn form-btn btn-lg btn-block" type="submit">Pay Now (${{ $package->price }})</button>
                                </div>
                            </div>

                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
