<?php $logo_dark = DB::table('logo')->where('slug', 'logo_dark')->where('tag', 'logo_fav')->first(); ?>
<html lang="en">

<head>
    <!--  HEAD    -->
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Appointment Inquiry</title>
    <style>
        body {
            font-family: Poppins, sans-serif;
            padding: 20px;
            background: #f1f1f1;
        }

        .container {
            background-color: #000000;
            width: 80%;
            max-width: 600px;
            margin-left: auto;
            margin-right: auto;
        }

        .inner_container {
            background-color: #ffffff;
            padding: 50px;
        }

        header,
        footer {
            text-align: center;
        }

        .email_inner_section {
            padding: 20px 0 50px 0;
        }

        hr {
            height: 5px;
            background-color: brown;
            border-color: brown;
        }

        h1 {
            color: brown;
        }

        .enquiry_submission table {
            text-align: left;
            margin-top: 50px;
        }

        .enquiry_submission table tbody tr th {
            width: 30%;
            vertical-align: top;
        }

        .enquiry_submission th,
        .enquiry_submission td {
            padding: 10px;
            margin: 0;
        }

        .enquiry_submission th {
            color: brown;
            font-weight: 900;
        }

        .enquiry_submission td {
            font-weight: 100;
        }

        .email_footer {
            font-size: 10px;
            color: #ffffff;
            padding: 20px 0;
        }

        .email_footer a {
            color: #ffffff;
            text-decoration: none;
        }

        @media only screen and (max-width:500px) {

            .enquiry_submission th,
            .enquiry_submission td {
                display: block;
                width: 100% !important;
            }
        }
    </style>
</head>
{{-- BODY --}}

<body>
    <div class="container">
        <div class="inner_container">
            <header>
                <img src="{{ asset($logo_dark->value ?? '') }}" width="100px" />
                <h1 style="text-align: center; font-size: 35px; line-height: 40px; font-weight: 700; margin: 0 0 20px 0; color: #74cee9;">Holistic Announcement</h1>
            </header>
            <hr>
            <div class="email_content">
                <div class="email_inner_section">
                    <section>
                        <h3>{{ $subject }}</h3>
                        <p>{{ $announcement }}</p>
                    </section>
                </div>
            </div>
        </div>
        {{-- footer --}}
        <footer>
            <section class="email_footer">
                <img src="{{ asset($logo_dark->value ?? '') }}" width="100px" />
                <p>
                    <a href="#">companylorem.com</a>
                </p>
                <!--<p>Address 1, 123 Road, MY</p>-->
                <p>Copyright &copy;
                    <script>
                        document.write(new Date().getFullYear())
                    </script> Holistic All Rights Reserved
                </p>
            </section>
        </footer>
        {{-- footer --}}
    </div>
</body>

</html>
