@extends('web.layouts.master')
@section('content')
    <!-- section 1 starts here -->
    <section class="section-1">
        <div class="container">
            <div class="row justify-content-center align-items-center">
                <div class="col-sm-12 col-md-12 col-lg-6 col-xl-6 col-xxl-6 sec1index-col1 ">
                    <div class="main-sec1 mt-5" data-aos="fade-right" data-aos-duration="1000">
                        <h1 class="display-1  color-text-white sec1-heading sec-heading Holistic">Welcome to <br>
                            Holistic Integrated Medicine</h1>
                        <p class="color-text-white parah1-size1">"At Holistic Integrated Medicine,
                            we offer healthcare solutions designed to empower you on your journey to wellness.
                            Say goodbye to insurance hassles and surprise bills - discover a better way to care for your
                            health naturally."</p>
                        <div class="btn-div my-4">
                            <a href="{{ route('web.Aboutus') }}" class="btn btn-2 inline me-1">About Us</a>
                        </div>
                    </div>
                </div>
                <div class="col-sm-12 col-md-12 col-lg-6 col-xl-6 col-xxl-6  ">
                    <div class="form-div" data-aos="fade-left" data-aos-duration="1000">
                        @if (Auth::user())
                            <form action="javascript:;" method="POST">
                                <div class="row">
                                    <div class="col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                        <div class="mb-3">
                                            <label for="exampleInputEmail1" class="form-label">Full Name</label>
                                            <input type="email" class="form-control form-control1" id="exampleInputEmail1"
                                                aria-describedby="emailHelp" placeholder="Enter Your Full Name" required>
                                        </div>
                                    </div>
                                    <div class="col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                        <div class="mb-3">
                                            <label class="form-label">Enter your (SSNs)</label>
                                            <input type="email" class="form-control form-control1"
                                                name="social_security_number"
                                                placeholder="enter your social security numbers (SSNs)" required>
                                        </div>
                                    </div>
                                    <div class="col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                        <div class="mb-3">
                                            <label for="exampleInputEmail1" class="form-label">Email address</label>
                                            <input type="email" class="form-control form-control1" id="exampleInputEmail1"
                                                aria-describedby="emailHelp" placeholder="Email" required>
                                        </div>
                                    </div>
                                    <div class="col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                        <div class="mb-3">
                                            <label for="exampleInputEmail1" class="form-label">Phone Number</label>
                                            <input type="email" class="form-control form-control1" id="exampleInputEmail1"
                                                aria-describedby="emailHelp" placeholder="Enter Your Phone Number" required>
                                        </div>
                                    </div>
                                    <div class="col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                                        <div class="mb-3">
                                            <label for="exampleInputEmail1" class="form-label">Select Services</label>
                                            <select class="form-select form-control1" aria-label="Default select example"
                                                placeholder="Select Services">
                                                <option selected>Select Services</option>
                                                <option value="1">Acupuncture</option>
                                                <option value="2">Cupping</option>
                                                <option value="3">Hub Prescription</option>
                                                <option value="3">Gua Sha</option>
                                                <option value="3">Mo x</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                                        <div class="mb-3">
                                            <label for="exampleInputEmail1" class="form-label">Message</label>
                                            <textarea class="form-control form-control1" placeholder="Message" id="floatingTextarea" rows="4"></textarea>
                                        </div>
                                    </div>
                                </div>
                                <button class="btn btn-sec1" type="submit">BOOK AN APPOINTMENT</button>
                            </form>
                        @else
                            <form class="appointment-form" action="{{ route('web.Appointment') }}" method="POST">
                                @csrf
                                @if ($errors->any())
                                    <div class="alert alert-danger">
                                        <ul>
                                            @foreach ($errors->all() as $error)
                                                <li>{{ $error }}</li>
                                            @endforeach
                                        </ul>
                                    </div>
                                @endif
                                <div class="row">
                                    <div class="col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                        <div class="mb-3">
                                            <label class="form-label">Full Name</label>
                                            <input type="name" class="form-control form-control1" name="name"
                                                placeholder="enter Your Full Name" required>
                                            <span class="invalid-feedback" role="alert">
                                                <strong>
                                                    @error('name')
                                                        {{ $message }}
                                                    @enderror
                                                </strong>
                                            </span>
                                        </div>
                                    </div>
                                    <div class="col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                        <div class="mb-3">
                                            <label class="form-label">Enter your (SSNs)</label>
                                            <input type="email" class="form-control form-control1"
                                                name="social_security_number"
                                                placeholder="enter your social security numbers (SSNs)" required>
                                            <span class="invalid-feedback" role="alert">
                                                <strong>
                                                    @error('social_security_number')
                                                        {{ $message }}
                                                    @enderror
                                                </strong>
                                            </span>
                                        </div>
                                    </div>
                                    <div class="col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                        <div class="mb-3">
                                            <label for="exampleInputEmail1" class="form-label">Email address</label>
                                            <input type="email" class="form-control form-control1"
                                                id="exampleInputEmail1" aria-describedby="emailHelp" placeholder="Email">
                                        </div>
                                    </div>
                                    <div class="col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                        <div class="mb-3">
                                            <label class="form-label">Phone Number</label>
                                            <input type="email" class="form-control form-control1" name="phone_number"
                                                placeholder="Enter Your Phone Number" required>
                                            <span class="invalid-feedback" role="alert">
                                                <strong>
                                                    @error('phone_number')
                                                        {{ $message }}
                                                    @enderror
                                                </strong>
                                            </span>
                                        </div>
                                    </div>
                                    <div class="col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                                        <div class="mb-3">
                                            <label for="exampleInputEmail1" class="form-label">Select Services</label>
                                            <select class="form-select form-control1" aria-label="Default select example"
                                                placeholder="Select Services">
                                                <option selected>Select Services</option>
                                                <option value="1">Acupuncture</option>
                                                <option value="2">Cupping</option>
                                                <option value="3">Hub Prescription</option>
                                                <option value="3">Gua Sha</option>
                                                <option value="3">Mo x</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                                        <div class="mb-3">
                                            <label for="exampleInputEmail1" class="form-label">Message</label>
                                            <textarea class="form-control form-control1" placeholder="Message" id="floatingTextarea" rows="4"></textarea>
                                        </div>
                                    </div>
                                </div>
                                <button class="btn btn-sec1 appointment-submit" type="submit">BOOK AN
                                    APPOINTMENT</button>
                            </form>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- section 1 ends here -->
    <!-- section 2 starts here -->
    <section class="section2">
        <div class="container">
            <div class="row">
                <div class="col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 sec2-colz1">
                    <div class="sec2-main" data-aos="fade-right" data-aos-duration="1000">
                        <h4 style="color:#74cee9";>ABOUT US</h4>
                        <h1 class="my-2 display-5  sec2-heading sec-heading">Experience Personalized Healthcare at Holistic
                            Integrated Medicine</h1>
                        <p class="my-2 parah-size" style="color: #777777" ;>At Holistic Integrated Medicine, we prioritize
                            your well-being by offering unhurried appointments and a holistic approach to healing. Unlike
                            traditional healthcare, we treat you as a whole person, not just a list of symptoms. With our
                            membership-based medicine program, enjoy unlimited access to primary care services without the
                            hassle of insurance. Contact us today for a free consultation and discover a better way to care
                            for your health.</p>
                        <div>
                            <a href="{{ route('web.Contact') }}" class="btn btn-sec my-4 appoint">Make An Appointment</a>

                        </div>
                    </div>
                </div>
                <div class="col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 sec2-colz2" data-aos="fade-up"
                    data-aos-duration="1000">
                    <img src="{{ asset('assets/web/images/Group-163.png') }}" alt="" class="img-fluid sec2-img">
                </div>
            </div>

            <div class="row end-row mt-5">
                <div class="col-sm-12 col-md-6 col-lg-3 col-xl-3 col-xxl-3 my-4">
                    <div class="d-flex align-items-center justify-content-center">
                        <span class=" span1"><i class="fa-solid fa-star"></i></span>
                        <span class="span2 call-span">
                            <P class="parah-size head-1-span ms-2">CALL US</P>
                            <p class="parah-size-end-row2 ms-2">For Free Consultation</p>
                        </span>
                    </div>
                </div>
                <div class="col-sm-12 col-md-6 col-lg-3 col-xl-3 col-xxl-3 my-4">
                    <div class="d-flex justify-content-center">
                        <h4 class="number-col">425-818-0505</h4>
                    </div>
                </div>
                <div class="col-sm-12 col-md-6 col-lg-3 col-xl-3 col-xxl-3 my-4">
                    <div class="d-flex align-items-center justify-content-center">
                        <span class=" span1"><i class="fa-solid fa-star icon-star-email"></i></span>
                        <span class="span2 email-span">
                            <P class=" parah-size head-1-span span-email-margin ms-2">EMAIL US</P>
                            <p class="parah-size-end-row2 span-email-margin ms-2">info@holisticim.com</p>
                        </span>
                    </div>
                </div>
                {{-- <div class="col-sm-12 col-md-6 col-lg-3 col-xl-3 col-xxl-3 my-4">
                    <div class="d-flex align-items-center justify-content-center">
                        <span class="span2">
                            <P class="parah-size head-1-span ">Mon. Wed. Fri</P>
                            <p class="parah-size-end-row2 ">10:30 - 6:30</p>
                        </span>
                    </div>
                </div> --}}
                <div class="col-sm-12 col-md-6 col-lg-3 col-xl-3 col-xxl-3 my-4">
                    <div class="d-flex justify-content-center align-items-center">
                       <i class="fa-solid fa-clock"></i>
                        <span class="span2 email-span">
                            <p class=" parah-size head-1-span span-email-margin ms-2">Timing</p>
                            <ul class="icons_area">
                                <li>Monday: 10:00 - 1:00</li>
                                <li>Tuesday: 10:00 - 6:30</li>
                                <li>Wednesday: 10:00 - 1:00</li>
                                <li>Thursday: 10:00 - 6:30</li>
                                <li>Friday: 10:00 - 6:30</li>
                            </ul>
                        </span>
                    </div>
                </div>
            </div>

        </div>
    </section>
    <!-- section 2 ends here -->
    <!-- section 3 starts here -->
    <section class="section3">
        <div class="container">
            <div class="row">
                <div class="col-sm-12 col-md-12 col-lg-6 col-xl-6 col-xxl-6 colz1-sec3">
                    <div class="patients" data-aos="fade-right" data-aos-duration="1000">
                        <i class="fa-solid fa-building"></i>
                        <img src="{{ asset('assets/web/images/male-patient.jpg') }}" alt=""
                            class="img-fluid sec3-img">
                    </div>
                </div>
                <div class="col-sm-12 col-md-12 col-lg-6 col-xl-6 col-xxl-6 mt-5">
                    <div class="sec3-main" data-aos="fade-left" data-aos-duration="1000">
                        <h4 style="color:#74cee9";>Focus just on the content</h4>
                        <h1 class="display-5 sec-heading ">Elevate Your Health with <br> Integrative Treatments</1>
                            <p class="parah-size my-3 A-client-that">Discover a unique approach to healthcare at Holistic
                                Integrated Medicine, where Eastern and Western medical philosophies converge. Our
                                practitioner, with expertise in both traditional Chinese medicine and conventional
                                allopathic medicine, offers comprehensive treatment plans. Experience shorter recovery times
                                and improved well-being with our holistic approach to healing.</p>
                            <div class="progress my-3" id="progress1" class="progress-bar-container"
                                style="height:30px">
                                <div class="progress-bar text-start" style="width:70%;">&nbsp &nbsp Integrative Approach
                                </div>
                            </div>
                            <div class="progress  my-3" id="progress2" class="progress-bar-container"
                                style="height:30px">
                                <div class="progress-bar  text-start" style="width:90%;">&nbsp &nbsp Expert Practitioner
                                </div>
                            </div>
                            <div class="progress  my-3" id="progress3" class="progress-bar-container "
                                style="height:30px">
                                <div class="progress-bar  text-start" style="width:80%;">&nbsp &nbsp Holistic Healing
                                </div>
                            </div>
                            <div>
                                <a href="{{ route('web.Aboutus') }}" class="btn btn-sec my-4 view">View More</a>
                            </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="sec-home-client">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-12 col-sm-12 col-md-12 col-lg-8 col-xl-8 col-xxl-8">
                    <div class="slider-title" data-aos="fade-up" data-aos-duration="1000">
                        <img src="https://designproboard.com/directory/v2/wp-content/uploads/2024/01/icon-quote.png"
                            alt="" class="img-fluid ">
                        <h3>Testimonials</h3>
                        <h4>Your Wellness Is Our <br> Greatest Achievement</h4>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="owl-carousel owl-theme meetnow-slider" id="meetnow-slider">
                    @foreach($getTestimonials as $getTestimonial)
                    <div class="item">
                        <div class="card slider-card">
                            <div class="desc">
                                <img src="{{ asset('assets/web/images/quotes.png') }}" alt="img" class="img-fluid">
                                <p>"{{$getTestimonial->testimonial ?? ''}}"</p>
                                <h6>~~~{{$getTestimonial->user_name ?? ''}}</h6>
                            </div>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
    </section>
    <!--sec-client end   here  -->
    <!-- section 6 starts here -->
    <section class="section6">
        <div class="container">
            <div class="row">
                <div class="col-sm-12 col-md-12 col-lg-6 col-xl-6 col-xxl-6  my-4">
                    <div class="sec6-main" data-aos="fade-right" data-aos-duration="1000">
                        <h4 style="color:#74cee9";>AWARDS</h4>
                        <h1 class="display-5  sec-heading">Schedule Your Wellness Journey Today</h1>
                        <p class="parah-size my-3">Ready to take the first step towards a healthier you? Contact us now to
                            schedule your appointment or inquire about our services. We're here to support you on your path
                            to wellness.</p>
                        <div>
                            <a href="{{ route('web.Aboutus') }}" class="btn btn-sec my-4 view">View More</a>
                        </div>
                    </div>
                </div>
                <div class="col-sm-12 col-md-12 col-lg-6 col-xl-6 col-xxl-6 sec6-colz2 my-4" data-aos="fade-left"
                    data-aos-duration="1000">
                    <img src="https://designproboard.com/directory/v2/wp-content/uploads/2024/01/awards.png"
                        alt="" class="img-fluid">
                </div>

            </div>
        </div>
    </section>
    <!-- section 6 ends here -->
    <!-- section 7 starts here -->
    <section class="section7">
        <div class="container">
            <div class="row">
                <div class="col-sm-12 col-md-12 col-lg-6 col-xl-6 col-xxl-6 colz1-sec7" data-aos="fade-right"
                    data-aos-duration="1000">
                    <img src="https://designproboard.com/directory/v2/wp-content/uploads/2024/01/Group-160.png"
                        alt="" class="img-fluid">
                </div>
                <div class="col-sm-12 col-md-12 col-lg-6 col-xl-6 col-xxl-6">
                    <div class="sec7-main" data-aos="fade-up" data-aos-duration="1000">
                        <h4 style="color:#74cee9";>Products with unrealistic</h4>
                        <h1 class="display-5  sec-heading">Empowering Your Well-being Through Holistic Services</h1>
                        <p class="parah-size my-3" ;>Unlock the transformative benefits of our holistic healthcare services
                            at Holistic Integrated Medicine. From acupuncture to mo xi, each treatment is meticulously
                            designed to restore balance and vitality to your body, mind, and spirit. Experience personalized
                            care, shorter recovery times, and enhanced well-being with our comprehensive approach to
                            healing.</p>
                    </div>
                    <div class="row">
                        <div class="col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 my-3 mx-auto">
                            <div class="card cards-sec7 d-block mx-auto" data-aos="fade-right" data-aos-duration="1000">
                                <div class="sec7-span"> <img
                                        src="https://designproboard.com/directory/v2/wp-content/uploads/2024/01/output-onlinepngtools-8-35x35.png"
                                        class="img-fluid card-sec7-img " alt="..."></div>
                                <div class="card-body">
                                    <div class="card-7-main">
                                        <h5 class="card-title card-title7  my-2"
                                            style="font-weight: 600!important;font-family: Cinzel;" ;>Personalized <br>
                                            Care</h5>
                                        <p class="card-text parah-text parah-7">Tailored treatments designed to address
                                            your unique health needs.</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 my-3 mx-auto">
                            <div class="card cards-sec7" data-aos="fade-right" data-aos-duration="1000">
                                <div class="sec7-span"> <img
                                        src="https://designproboard.com/directory/v2/wp-content/uploads/2024/01/output-onlinepngtools-9-35x35.png"
                                        class="img-fluid card-sec7-img " alt="..."></div>
                                <div class="card-body">
                                    <div class="card-7-main">
                                        <h5 class="card-title card-title7  my-2"
                                            style="font-weight: 600!important;font-family: Cinzel;" ;>Shorter Recovery
                                            Times</h5>
                                        <p class="card-text parah-text parah-7">Benefit from quicker recovery and improved
                                            overall well-being.</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 my-3 mx-auto">
                            <div class="card cards-sec7" data-aos="fade-right" data-aos-duration="1000">
                                <div class="sec7-span"> <img
                                        src="https://designproboard.com/directory/v2/wp-content/uploads/2024/01/output-onlinepngtools-6-35x35.png"
                                        class="img-fluid card-sec7-img " alt="..."></div>
                                <div class="card-body">
                                    <div class="card-7-main">
                                        <h5 class="card-title card-title7  my-2"
                                            style="font-weight: 600!important;font-family: Cinzel;" ;>Enhanced Vitality
                                        </h5>
                                        <p class="card-text parah-text parah-7">Restore balance and vitality to your body,
                                            mind, and spirit.</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 my-3 mx-auto">
                            <div class="card cards-sec7" data-aos="fade-right" data-aos-duration="1000">
                                <div class="sec7-span"> <img
                                        src="https://designproboard.com/directory/v2/wp-content/uploads/2024/01/output-onlinepngtools-7-35x35.png"
                                        class="img-fluid card-sec7-img " alt="..."></div>
                                <div class="card-body">
                                    <div class="card-7-main">
                                        <h5 class="card-title card-title7 my-2"
                                            style="font-weight: 600!important;font-family: Cinzel;" ;>Comprehensive
                                            Approach</h5>
                                        <p class="card-text parah-text parah-7">Receive holistic care that integrates
                                            traditional wisdom with modern.</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- section 7 ends here -->
    <!-- section 8 starts here -->
    <section class="section8">
        <div class="container">
            <div class="row">
                <div class="col-sm-12 col-md-12 col-lg-8 col-xxl-8 col-xl-8 mx-auto">
                    <div class="card card-8 ">
                        <div class="card-body">
                            <h2 class="card-title  display-6 text-center sec-heading"><span class="span1-sec-8">Subscribe
                                    Our </span> <span class="span2-sec-8">Newsletter
                                </span></h2>
                            <div class="input-group mb-3 w-75 mx-auto my-4">
                                <input type="text" class="form-control input-post-fc" placeholder="Enter Your Email"
                                    aria-label="Recipient's username" aria-describedby="basic-addon2">
                                <span class="input-group-text input-post" id="basic-addon2">SUBSCRIBE</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- section 8 ends here -->
@endsection
@section('scripts')
    <script>
        $(document).on('click', '.appointment-submit', function(event) {
            event.preventDefault();

            var has_error = false;
            var form = $(this).closest('.appointment-form');

            form.find(".is-invalid").removeClass('is-invalid');

            form.find("select, textarea, input").each(function() {
                if ($(this).prop("required")) {
                    if ($(this).val() == "") {
                        has_error = true;
                        $(this).addClass('is-invalid');

                        var fieldName = $(this).attr('placeholder') || $(this).attr('name');
                        fieldName = fieldName.replace('*', '');
                        form.find('input[name="' + $(this).attr('name') + '"]').siblings(
                            '.invalid-feedback').find('strong').text("Please " + fieldName);
                    }
                }
            });

            if (!has_error) {
                form.submit();
            } else {
                toastr.options = {
                    "closeButton": true,
                    "progressBar": true,
                    "debug": false,
                    "positionClass": "toast-bottom-right",
                };
                toastr.error("Fill All Required Fields");
            }
        });
    </script>
@endsection
