@extends('admin.layouts.master')
@section('content')
    <div class="ms-content-wrapper">
        <div class="row">
            <div class="col-md-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb pl-0">
                        <li class="breadcrumb-item"><a href="javascript:;"><i class="material-icons">home</i> Home</a></li>
                        <li class="breadcrumb-item"><a href="javascript:;">Profile</a></li>
                    </ol>
                </nav>
            </div>
            <div class="col-xl-12 col-md-12">
                <div class="ms-panel">
                    <div class="ms-panel-header ms-panel-custome">
                        <h6>Profile</h6>
                    </div>
                    <div class="ms-panel-body">
                        <form class="needs-validation" action="{{ route('patient.profileUpdate') }}" method="POST"
                            enctype="multipart/form-data" novalidate>
                            @csrf
                            <input type="hidden" name="user_id" value="{{ $profile->id }}">
                            <div class="form-row">
                                <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                                    <div class="avatar-upload">
                                        <div class="avatar-edit">
                                            <input type='file' type="file" name="image" id="imageUpload1"
                                                class="change-img" accept=".png, .jpg, .jpeg" />
                                            <label for="imageUpload1"></label>
                                        </div>
                                        <div class="avatar-preview">
                                            <div class="imagePreview">
                                                <img src="{{ asset($profile->image) }}" alt="img" class="img-fluid">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="col-md-6 mb-3">
                                    <label for="validationCustom001">First Name</label>
                                    <div class="input-group">
                                        <input type="text" class="form-control" placeholder="Name" name="name"
                                            id="validationCustom001" value="{{ $profile->name ?? '' }}" required>
                                    </div>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="validationCustom002">Last name</label>
                                    <div class="input-group">
                                        <input type="email" class="form-control" placeholder="Email" name="email "
                                            id="validationCustom002" value="{{ $profile->email ?? '' }}" disabled>

                                    </div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="col-md-6 mb-3">
                                    <label for="validationCustom003">Social Security Number</label>
                                    <div class="input-group">
                                        <input type="text" class="form-control" placeholder="Social Security Number" name="ssn"
                                            id="validationCustom003" value="{{ $profile->ssn ?? '' }}" required>
                                    </div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="col-md-6 mb-3">
                                    <label for="validationCustom003">Age</label>
                                    <div class="input-group">
                                        <input type="text" class="form-control" placeholder="Age" name="age"
                                            id="validationCustom003" value="{{ $profile->age ?? '' }}" required>
                                    </div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="col-md-6 mb-3">
                                    <label for="validationCustom003">Date of Birth</label>
                                    <div class="input-group">
                                        <input type="text" class="form-control" placeholder="Date of Birth" name="dob"
                                            id="validationCustom003" value="{{ $profile->dob ?? '' }}" required>
                                    </div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="col-md-6 mb-3">
                                    <label for="validationCustom003">Phone</label>
                                    <div class="input-group">
                                        <input type="text" class="form-control" placeholder="Phone" name="phone"
                                            id="validationCustom003" value="{{ $profile->phone ?? '' }}" required>
                                    </div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="col-md-6 mb-2">
                                    <label>Address</label>
                                    <div class="input-group">
                                        <textarea class="form-control" id="exampleTextarea1" rows="3" name="address" placeholder="Address">{{ $profile->address }}</textarea>
                                    </div>
                                </div>
                            </div>
                            <button class="btn btn-primary mt-4 d-inline w-20" type="submit">Create Profile</button>
                        </form>

                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
