@extends('admin.layouts.master')
@section('content')
    <div class="ms-content-wrapper">
        <div class="row">
            <div class="col-md-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb pl-0">
                        <li class="breadcrumb-item"><a href="javascript:;"><i class="material-icons">home</i> Home</a></li>
                        <li class="breadcrumb-item"><a href="javascript:;">Payment History</a></li>
                    </ol>
                </nav>
                <div class="ms-panel">
                    <div class="ms-panel-header ms-panel-custome">
                        <h6>Payment History</h6>
                    </div>
                    <div class="ms-panel-body">
                        <div class="table-responsive">
                            <table class="table table-striped thead-primary w-100 dataTable-main">
                                <thead>
                                    <tr>
                                        <th scope="col">#</th>
                                        <th scope="col">Reason</th>
                                        <th scope="col">Amount</th>
                                        <th scope="col">Date</th>
                                        {{-- <th scope="col">Action</th> --}}
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($payment as $key => $item)
                                        <tr>
                                            <th scope="row">{{ $key + 1 }}</th>
                                            <td>{{ $item->reason ?? '-' }}</td>
                                            <td>${{ number_format($item->amount, 2) ?? '-' }}</td>
                                            <td>{{ $item->date ? \Carbon\Carbon::parse($item->date)->format('F j, Y') : '-' }}</td>
                                            {{-- <td>
                                                <div class="btn-box">
                                                    <a href="{{ route('admin.profileEdit', $item->id) }}" class="icon-bt"><i class="fas fa-pencil-alt ms-text-primary"></i></a>
                                                    <a data-id="{{ $item->id }}" class="remove-item icon-bt">
                                                        <i class="far fa-trash-alt ms-text-danger"></i>
                                                    </a>
                                                </div>
                                            </td> --}}
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
