@extends('admin.layouts.master')
@section('content')
    <div class="ms-content-wrapper">
        <div class="row">
            <div class="col-md-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb pl-0">
                        <li class="breadcrumb-item"><a href="javascript:;"><i class="material-icons">home</i> Home</a></li>
                        <li class="breadcrumb-item"><a href="javascript:;">{{ $title }}</a></li>
                    </ol>
                </nav>
            </div>
            <div class="col-xl-12 col-md-12">
                <div class="ms-panel">
                    <div class="ms-panel-header ms-panel-custome">
                        <h6>Save & update charge history</h6>
                    </div>
                    <div class="ms-panel-body">
                        <form class="needs-validation" action="{{ route('admin.patientOrderSave') }}" method="POST" novalidate>
                            @csrf
                            <input type="hidden" name="order_id" value="{{ $order->id ?? '' }}">
                            <input type="hidden" name="patient_id" value="{{ $patient->id ?? '' }}">
                            <div class="form-row">
                                <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12 mb-3">
                                    <label for="validationCustom002">Amount</label>
                                    <div class="input-group">
                                        <input type="number" class="form-control" name="amount"
                                            value="{{ $order->amount ?? '' }}" min="1" id="validationCustom002" placeholder="Amount"
                                            required>
                                    </div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12 mb-2">
                                    <label>Description</label>
                                    <div class="form-group">
                                        <textarea class="form-control" id="exampleTextarea1" name="description" rows="3">{{ $order->description ?? '' }}</textarea>
                                    </div>
                                </div>
                            </div>
                            <button class="btn btn-primary mt-4 d-inline w-20" type="submit">save/update</button>
                        </form>

                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
