@extends('admin.layouts.master')
@section('content')
    <div class="ms-content-wrapper">
        <div class="row">
            <div class="col-md-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb pl-0">
                        <li class="breadcrumb-item"><a href="javascript:;"><i class="material-icons">home</i> Home</a></li>
                        <li class="breadcrumb-item"><a href="javascript:;">{{ $title }}</a></li>
                    </ol>
                </nav>
                <div class="ms-panel">
                    <div class="ms-panel-header ms-panel-custome">
                        <h6>{{ $title }}</h6>
                    </div>
                    <div class="ms-panel-body">
                        <div class="table-responsive">
                            <table class="table table-striped thead-primary w-100 dataTable-main">
                                <thead>
                                    <tr>
                                        <th scope="col">#</th>
                                        <th scope="col">Name</th>
                                        <th scope="col">Phone Number</th>
                                        <th scope="col">Social Security Number</th>
                                        <th scope="col">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($appointment as $key => $item)
                                        <tr>
                                            <th scope="row">{{ $key + 1 }}</th>
                                            <td>{{ $item->name ?? '' }}</td>
                                            <td><a href="tel:{{ $item->phone_number ?? '' }}">{{ $item->phone_number ?? '' }}</a></td>
                                            <td>{{ $item->social_security_number ?? '' }}</td>
                                            <td><a href="{{route('admin.appointmentDelete',[$item->id ?? 0 ])}}"><i class="far fa-trash-alt ms-text-danger"></i></td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
