<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>{{ isset($title) ? $title : 'Dashboard' }}</title>
    @include('admin.layouts.links')
    @yield('css')
</head>

<body class="ms-body ms-aside-left-open ms-primary-theme ms-has-quickbar">
    <!-- Setting Panel -->
    <div class="ms-toggler ms-settings-toggle ms-d-block-lg">
        <i class="flaticon-gear"></i>
    </div>
    <div class="ms-settings-panel ms-d-block-lg">
        <div class="row">
            <div class="col-xl-4 col-md-4">
                <h4 class="section-title">Customize</h4>
                <div>
                    <label class="ms-switch">
                        <input type="checkbox" id="dark-mode">
                        <span class="ms-switch-slider round"></span>
                    </label>
                    <span> Dark Mode </span>
                </div>

            </div>
        </div>
    </div>
    <!-- Preloader -->
    <div id="preloader-wrap">
        <div class="spinner spinner-8">
            <div class="ms-circle1 ms-child"></div>
            <div class="ms-circle2 ms-child"></div>
            <div class="ms-circle3 ms-child"></div>
            <div class="ms-circle4 ms-child"></div>
            <div class="ms-circle5 ms-child"></div>
            <div class="ms-circle6 ms-child"></div>
            <div class="ms-circle7 ms-child"></div>
            <div class="ms-circle8 ms-child"></div>
            <div class="ms-circle9 ms-child"></div>
            <div class="ms-circle10 ms-child"></div>
            <div class="ms-circle11 ms-child"></div>
            <div class="ms-circle12 ms-child"></div>
        </div>
    </div>
    <!-- Overlays -->
    <div class="ms-aside-overlay ms-overlay-left ms-toggler" data-target="#ms-side-nav" data-toggle="slideLeft"></div>
    <div class="ms-aside-overlay ms-overlay-right ms-toggler" data-target="#ms-recent-activity"
        data-toggle="slideRight">
    </div>
    @include('admin.layouts.sidebar')
    <main class="body-content">
        @include('admin.layouts.header')
        @yield('content')
        @include('admin.layouts.footer')
        @if (Auth::user()->access_medical_profile == 0)
            <div class="modal fade" id="accessprofileModal" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog ms-modal-dialog-width">
                    <div class="modal-content ms-modal-content-width">
                        {{-- <div class="modal-header  ms-modal-header-radius-0">
                            <h4 class="modal-title text-white">Access Medical Profile</h4>
                            <button type="button" class="close  text-white" data-dismiss="modal"
                                aria-hidden="true">x</button>
                        </div> --}}
                        <div class="modal-body p-0 text-left">
                            <div class="col-xl-12 col-md-12">
                                <div class="ms-panel ms-panel-bshadow-none">
                                    <div class="ms-panel-header">
                                        <h6>Access Medical Profile</h6>
                                    </div>
                                    <div class="ms-panel-body">
                                        <div class="row justify-content-center">
                                            <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                                                <div class="medical-profile">
                                                    <h4>A risk if you agree, that your medical profile will be exposed if you access from here.</h4>
                                                    <div class="btn-container">
                                                        <div class="btn-box">
                                                            <a href="{{ route('admin.home') }}" class="btn btn-danger">Cancel</a>
                                                        </div>
                                                        <form action="{{ route('admin.profileAccessSubmit') }}" method="POST">
                                                            @csrf
                                                            <div class="btn-box">
                                                                <button type="submit" class="btn btn-primary">Ok</button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endif
    </main>
    @include('admin.layouts.scripts')
    @yield('scripts')

</body>

</html>
