<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Blade;
class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        Blade::if('admin', function () {
            return Auth::check() && Auth::user()->role_id == 1;
        });
        Blade::if('patient', function () {
            return Auth::check() && Auth::user()->role_id == 2;
        });
        Blade::if('staff', function () {
            return Auth::check() && Auth::user()->role_id == 3;
        });
        Blade::if('providers', function () {
            return Auth::check() && Auth::user()->role_id == 4;
        });
    }
}
