<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;

class Conversation extends Model
{
    use HasFactory;
    protected $table = 'conversation';
    protected $appends = ['user_detail','user_msgs'];

    public function msg()
    {
        return $this->hasMany(Messages::class, 'conversation_id', 'id');
    }

    public function getUserDetailAttribute()
    {
        if(Auth::user()->id == $this->sender_id){
            $reciver = User::find($this->reciver_id);
            return $reciver;
        }else{
            $sender = User::find($this->sender_id);
            return $sender;
        }
    }

    public function getUserMsgsAttribute()
    {
        // $conversations = Conversation::where(function($q) {
        //     $q->where('sender_id', $this->sender_id)
        //     ->orWhere('reciver_id', $this->reciver_id);
        // })->where(function($q){
        //     $q->where('sender_id', Auth::user()->id)
        //     ->orWhere('reciver_id', Auth::user()->id);
        // })->first();

        $lastMsg = Messages::where('conversation_id', $this->id)->orderby('id','desc')->first();
        return $lastMsg;
    }

}
