<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Services;
use App\Models\Testimonials;
use App\Models\Inquiries;
use App\Models\Appointment;
use App\Models\customeCare;
use App\Models\aboutCms;
use App\Models\Logo;
use App\Models\Packages;
use App\Models\PurchasePackages;
use App\Models\User;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
class WebController extends Controller
{
    public function webHome()
    {
        $getTestimonials = Testimonials::where('is_active', 1)->where('is_deleted', 0)->get();
        return view('web.index', compact('getTestimonials'));
    }

    public function webAboutus()
    {
        $_getaboutCms = aboutCms::where('id',1)->first();
        $getTestimonials = Testimonials::where('is_active', 1)->where('is_deleted', 0)->get();
        return view('web.pages.about-us',compact('_getaboutCms','getTestimonials'))->with('title','About Us');
    }
    public function customerCare()
    {
        $_getcustomeCare = customeCare::where('id',1)->first();
        //dd($_getcustomeCare->title);
        return view('web.pages.customer-care',compact('_getcustomeCare'))->with('title','Customer Care');
    }
    public function privacyPolicy()
    {
        $_getprivacyPolicy = customeCare::where('id',2)->first();
        return view('web.pages.privacy-policy',compact('_getprivacyPolicy'))->with('title','Privacy Policy');
    }
    public function webServices()
    {
        $service = Services::where('is_active', 1)->where('is_deleted', 0)->get();
        return view('web.pages.services', compact('service'))->with('title','services');
    }
    public function webServicesDetail($slug)
    {
        $serviceDetail = Services::where('slug',$slug)->first();

        return view('web.pages.serviceDetail', compact('serviceDetail'))->with('title','service detail');
    }
    public function webAcupunture()
    {
        return view('web.pages.acupunture');
    }
    public function webAllergy()
    {
        return view('web.pages.allergy');
    }
    public function webCancer()
    {
        return view('web.pages.cancer');
    }
    public function webCirculation()
    {
        return view('web.pages.circulation');
    }
    public function webCommonConditions()
    {
        return view('web.pages.common-conditions');
    }
    public function webConsulting()
    {
        return view('web.pages.consulting');
    }
    public function webAppointment(Request $request)
    {
        $appointment = new Appointment();
        $appointment->name = $request->name;
        $appointment->phone_number = $request->phone_number;
        $appointment->social_security_number = $request->social_security_number;
        $appointment->type = 'nonmember' ?? '';
        $appointment->save();

        $data["name"] = $request->name;
        $data["phone_number"] = $request->phone_number;
        $data["social_security_number"] = $request->social_security_number;

        // $mails = ['danielross0041@gmail.com'];
        $mails = ['sybexlab.team@gmail.com'];

        //return view('web.pages.mailing.nonUserAppointment',compact('data'));
        Mail::send('web.pages.mailing.nonUserAppointment', $data, function ($message) use ($mails) {
            $message->to($mails);
            $message->subject('Non User Appointment');
        });

        return redirect()->route('web.home')->with('message','Appointment book successfully');
    }
    public function webContact()
    {
        return view('web.pages.contact');
    }
    public function contactSubmit(Request $request)
    {

        $inquiryForm = new Inquiries();
        $inquiryForm->name = $request->name?? ''.' '.$request->lastName ?? '';
        $inquiryForm->email = $request->email ?? '';
        $inquiryForm->number = $request->number ?? '';
        $inquiryForm->message = $request->text ?? '';
        $inquiryForm->save();

        $data["name"] = $request->name ?? '';
        $data["email"] = $request->email ?? '';
        $data["number"] = $request->number ?? '';
        $data["text"] = $request->text ?? '';

        $mails = ['sybexlab.team@gmail.com'];

        //return view('web.pages.mailing.nonUserAppointment',compact('data'));

        Mail::send('web.pages.mailing.contact', $data, function ($message) use ($mails) {
            $message->to($mails);
            $message->subject('Contact Inquiry');
        });

        return redirect()->back()->with('message','Thank you for contacting us; we will respond as soon as possible.');
    }
    public function webCosmeticAcupunture()
    {
        return view('web.pages.cosmetic-acupunture');
    }
    public function webDigestive()
    {
        return view('web.pages.digestive');
    }
    public function webEvent()
    {
        return view('web.pages.event');
    }
    public function webFaq()
    {
        return view('web.pages.faq');
    }
    public function webHormone()
    {
        return view('web.pages.hormone');
    }
    public function webImmune()
    {
        return view('web.pages.immune');
    }
    public function webJointInjured()
    {
        return view('web.pages.joint-injured');
    }
    public function webMentalHealth()
    {
        return view('web.pages.mental-health');
    }
    public function webMetabolism()
    {
        return view('web.pages.metabolism');
    }
    public function webMuscular()
    {
        return view('web.pages.muscular');
    }
    public function webNeuropathy()
    {
        return view('web.pages.neuropathy');
    }
    public function webOurProviders()
    {
        return view('web.pages.our-providers');
    }
    public function webPrescription()
    {
        return view('web.pages.prescription');
    }
    public function webPricing()
    {
        return view('web.pages.pricing');
    }
    public function webPrimaryCare()
    {
        return view('web.pages.primary-care');
    }
    public function webProviders()
    {
        return view('web.pages.providers');
    }
    public function webReproductive()
    {
        return view('web.pages.reproductive');
    }
    public function webRespiratory()
    {
        return view('web.pages.respiratory');
    }

    public function webLogin()
    {
        return view('web.pages.login')->with('title','Login');
    }

    public function LoginSubmit(Request $request)
    {
        $validated = Validator::make($request->all(), [
            'email' => 'required',
            'password' => 'required',
        ]);
        if ($validated->fails()) {
            return redirect()->back()->with('validationerror', $validated->errors()->all());
        }

        $credentials = $request->only('email', 'password');
        if (!Auth::validate($credentials)) {
            return redirect()->back()->with('error', 'Invalid Login Credentials');
        }

        $user = User::where('email', $request->email)->first();

        $date1=date_create($user->membership_cancel_date);
        $date2=date_create(date('Y-m-d'));
        $diff=date_diff($date1,$date2);
        $diffDays = $diff->format("%a");

        if ($user->is_active != 1 || $user->is_deleted != 0) {
            if($diffDays <= 180){
                return redirect()->back()->with('error', 'Your account is either inactive or deleted. Try again in 180 days.');
            }
            $user->is_active = 1;
            $user->is_deleted = 0;
            $user->membership_cancel_date = null;
            $user->save();
        }

        if (Auth::attempt($credentials)) {
            $user = Auth::user();
            if ($user->role_id == 1) {
                Auth::logout();
                return redirect()->route('web.Login')->with('error', 'Invalid Login Credentials');
            }
            elseif($user->role_id == 2){
                $purchasePackage = PurchasePackages::where('user_id', $user->id)
                    ->where('is_active', 1)
                    ->where('is_deleted', 0)
                    ->orderBy('id', 'DESC')
                    ->first();
                if ($purchasePackage) {
                    $expiryDate = $purchasePackage->expiry_date;
                    if (now()->greaterThan($expiryDate)) {
                        return redirect()->route('web.webPackagesView')->with('error', 'Your package is expired. Update your package first to continue.');
                    }
                }
            }
            return redirect()->route('admin.home')->with('message', 'Login Successfully');
        }
        return redirect()->back()->with('error', 'This user is not exist');
    }

    public function webUserRegister()
    {
        $Role_id = 2;
        $role_type = 'patient';
        return view('web.pages.register', compact('Role_id','role_type'))->with('title','Registeration');
    }
    public function RegisterSubmit(Request $request)
    {
        $validated = Validator::make($request->all(), [
            'email' => 'required|unique:users|max:255',
            // 'social_security_number' => 'required|unique:users|max:255',
            'password' => 'required|min:6',
            'cnfpassword' => 'required_with:password|same:password|min:6'
        ]);
        if ($validated->fails()) {
            return redirect()->back()->with('validationerror', $validated->errors()->all());
        }
        $password = Hash::make($request->password);
        $userRegister = new User();
        $userRegister->name = $request->name;
        // $userRegister->social_security_number = $request->social_security_number;
        $userRegister->email = $request->email;
        $userRegister->password = $password;
        $userRegister->role_id = $request->role_id;
        $userRegister->role_type = $request->role_type;
        $userRegister->save();
        Auth::attempt(['email'=> $request->email,'password'=> $request->password]);
        return redirect()->route('web.webPackagesView')->with('message', 'Account Registered Successfully Buy Package First To Continue...');
    }

    public function webForgotPassword()
    {
        return view('web.pages.forgotPassword')->with('title',"Forgotten Password | Can't Login");
    }

    public function webSearchEmail(Request $request)
    {
        $request->validate([
            'email' => 'required|email',
        ]);

        $user = User::where('email', $request->email)->first();

        if (!$user) {
            return redirect()->back()->with('error', 'Email address not found.');
        }

        $otp = rand(100000, 999999);
        $user->otp = $otp;
        // $user->otp_expiry = now()->addMinutes(10);
        $user->save();

        Mail::send('web.pages.mailing.otp', ['otp' => $otp], function ($message) use ($user) {
            $message->to($user->email);
            $message->subject('Your OTP for Password Reset');
        });

        return redirect()->route('web.EnterOtp')->with('message', 'OTP sent to your email address.');
    }

    public function webEnterOtp()
    {
        return view('web.pages.enterOtp')->with('title', 'Enter OTP');
    }

    public function webSubmitOtp(Request $request)
    {

        $validated = Validator::make($request->all(), [
            'email' => 'required|email',
            'otp' => 'required|numeric',
            'password' => 'required|min:6',
            'cnfpassword' => 'required_with:password|same:password|min:6'
        ]);

        $user = User::where('email', $request->email)
                ->where('otp', $request->otp)
                // ->where('otp_expiry', '>', now())
                ->first();

        if (!$user) {
            return redirect()->back()->with('error', 'Invalid OTP or OTP expired.');
        }
        if ($validated->fails()) {
            return redirect()->back()->with('validationerror', $validated->errors()->all());
        }

        $password = Hash::make($request->password);
        $user->password = $password;
        $user->otp = null;
        // $user->otp_expiry = null;
        $user->save();

        return redirect()->route('web.Login')->with('message', 'Password changed successfully. Please login with your new password.');
    }

    Public function DPCAgreementForms() {
        $logo = Logo::where('slug', 'logo_dark')->where('tag', 'logo_fav')->first();
        return view('web.pages.agreementForm', compact('logo'))->with('title', 'DPC Agreement forms');
    }

    Public function acupunctureIntakeForm() {
        $logo = Logo::where('slug', 'logo_dark')->where('tag', 'logo_fav')->first();
        return view('web.pages.acupunctureIntake', compact('logo'))->with('title', 'Acupuncture intake form');
    }

    Public function carolynIntakeForm() {
        $logo = Logo::where('slug', 'logo_dark')->where('tag', 'logo_fav')->first();
        return view('web.pages.carolynIntake', compact('logo'))->with('title', 'Carolyn Intake form');
    }
}
