<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Rooms;
use App\Models\Appointment;
use App\Models\AppointmentReport;
use App\Models\Document;
use App\Models\RedFlag;
use App\Models\User;
use App\Models\AppointmentMedication;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Validator;

class ProvidersController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('isProviders');
    }
    public function roomsView()
    {
        $room = Rooms::where('provider_id', Auth::user()->id)->where('is_active', 1)->where('is_deleted', 0)->get();
        return view('admin.pages.providers.room.roomList', compact('room'))->with('title', 'room');
    }
    public function roomsCreate($id)
    {
        if ($id > 0) {
            $room = Rooms::find($id);
            if ($room) {
                return view('admin.pages.providers.room.roomCreate', compact('room'))->with('title', 'room edit');
            }
        }

        $userRooms = Rooms::where('provider_id', Auth::user()->id)->get();

        $selectedDaysCount = $userRooms->pluck('day')->flatten()->unique()->count();
        if (!is_int($selectedDaysCount)) {
            $selectedDaysCount = 0;
        }

        $maxDays = 7;
        if ($selectedDaysCount >= $maxDays) {
            return redirect()->back()->with('error', 'maximum number of days selected.');
        }
        return view('admin.pages.providers.room.roomCreate')->with('title', 'room Create');
    }

    public function roomsUpdate(Request $request)
    {
        $roomId = $request->input('room_id');

        if ($roomId) {
            $room = Rooms::find($roomId);
            if (!$room) {
                return redirect()->back()->with('error', 'room not found.');
            }
        } else {
            $room = new Rooms();
        }

        $selectedDays = $request->input('day', []);
        $maxDays = 7;

        if (!is_array($selectedDays)) {
            $selectedDays = [];
        }

        if (count($selectedDays) > $maxDays) {
            return redirect()->back()->with('error', 'You cannot select more than ' . $maxDays . ' days.');
        }


        $user_id = Auth::user()->id;
        $room->provider_id = $user_id ?? '';
        $room->day = $request->day ?? '';
        $room->start_time = $request->start_time ?? '';
        $room->end_time = $request->end_time ?? '';
        $room->duration = $request->duration ?? '';
        $room->save();
        return redirect()->back()->with('message', 'Record updated Sucessfully');
    }
    public function roomsDelete(Request $request)
    {
        if ($request->id) {
            $room = Rooms::where('id', $request->id)->first();
            if ($room) {
                $room->is_active = 0;
                $room->is_deleted = 1;
                $room->save();

                return response()->json(['status' => 1, 'message' => 'room Deleted Successfully!']);
            }
        }
        return response()->json(['status' => 0, 'message' => 'room Not Found!']);
    }
    public function providerAppointmnetList() {
        $appList = Appointment::where('provider_id', Auth::user()->id)->where('is_active', 1)->where('is_deleted', 0)->get();
        return view('admin.pages.providers.memberAppointmentList', compact('appList'))->with('title','Members appointment List');
    }

    public function patientAppointmnetStatus(Request $request) {
        $appointment = Appointment::find($request->id);
        if (!$appointment) {
            return response()->json(['message' => 'Appointment not found.'], 404);
        }
        $appointment->status = $request->status;
        $appointment->save();
        $problem = $appointment->problem;
        $flags = RedFlag::where('user_id', $request->user_id)->where('is_active', 1)->where('is_deleted', 0)->get();
        return response()->json([
            'message' => 'Status updated successfully!',
            'flags' => $flags,
            'status' => $request->status,
            'problem' => $problem
        ]);
    }

    public function providerPateints() {
        $patients = User::where('role_id', 2)->get();
        return view('admin.pages.providers.providerPateints', compact('patients'))->with('title','Pateints List');
    }

    public function patientDocumentsByProviders($id) {
        $documents = Document::where('user_id', $id)->where('upload_by', 'patient')->where('is_active', 1)->where('is_deleted', 0)->get();
        return view('admin.pages.providers.providerPateintDocuments', compact('documents'))->with('title','Pateint Documents List');
    }

    public function patientreportsByProviders($id) {
        $report = Document::where('user_id', $id)->where('upload_by', 'provider')->where('is_active', 1)->where('is_deleted', 0)->get();
        return view('admin.pages.providers.providerPateintReports', compact('report','id'))->with('title','Reports List');
    }

    public function reportAgainstAppointment($id) {
        $appointmentReport = AppointmentReport::where('appointment_id', $id)->where('is_active', 1)->where('is_deleted', 0)->get();
        return view('admin.pages.providers.reportsAginstAppointment', compact('appointmentReport','id'))->with('title','Reports List');
    }

    public function reportAgainstAppointmentSave(Request $request)
    {
        $appointmentReport = new AppointmentReport();

        $validated = Validator::make($request->all(), [
            'file' => 'required|max:20480',
        ]);
        if ($validated->fails()) {
            return redirect()->back()->with('validationerror', $validated->errors()->all());
        }

        if ($request->hasFile('file')) {
            $file = $request->file('file');
            $file_name = $file->getClientOriginalName();
            $file_size = $file->getSize();
            if ($file_size > 20971520) {
                return redirect()->back()->with('error', 'Please upload a file less than 20MB.');
            }
            $file_name = pathinfo($file_name, PATHINFO_FILENAME);
            $file_extension = $file->getClientOriginalExtension();
            $file_name = $file_name . '_' . time() . '.' . $file_extension;
            $destinationPath = public_path('uploads/reportsAgainstAppointment');
            $file->move($destinationPath, $file_name);
            $appointmentReport->file = 'uploads/reportsAgainstAppointment/' . $file_name;
            $appointmentReport->file_name = $file->getClientOriginalName();
            $appointmentReport->file_size = $file_size;
        }

        $appointmentReport->appointment_id = $request->appointment_id ?? '';
        $appointmentReport->save();
        return redirect()->back()->with('message', 'Report Uploaded Successfully');
    }

    public function reportAgainstAppointmentDelete(Request $request)
    {
        if ($request->id) {
            $appointmentReport = AppointmentReport::where('id', $request->id)->first();
            if ($appointmentReport) {
                $appointmentReport->is_active = 0;
                $appointmentReport->is_deleted = 1;
                $appointmentReport->save();

                return response()->json(['status' => 1, 'message' => 'Report Deleted Successfully!']);
            }
        }
        return response()->json(['status' => 0, 'message' => 'Report Not Found!']);
    }

    public function patientMedicalProfile($id) {
        $providerId = Auth::user()->id;

        $appointments = Appointment::where('provider_id', $providerId)
        ->where('user_id', $id)
        ->where('status', 'completed')
        ->where('is_active', 1)
        ->where('is_deleted', 0)
        ->get();
        // dd($appointments);

        $appointmentId = $appointments->pluck('id');
        // dd($appointmentId);

        $medicalReports = AppointmentReport::whereIn('appointment_id', $appointmentId)
        ->where('is_active', 1)
        ->where('is_deleted', 0)
        ->get()
        ->groupBy('appointment_id');
        // dd($medicalReports);

        return view('admin.pages.patient.medicalProfile', compact('medicalReports','appointments'))->with('title','Medical Profile');
    }

    public function medicationHistory($id){
        $medication = AppointmentMedication::where('appointment_id', $id)->where('is_active', 1)->where('is_deleted', 0)->first();
        $redFlag = Appointment::find($id);
        return view('admin.pages.providers.appointmentMedication', compact('medication','id','redFlag'))->with('title','Appointment Medication');
    }

    public function medicationHistorySave(Request $request){
        $medicationId = $request->input('medication_id');

        if ($medicationId) {
            $medication = AppointmentMedication::find($medicationId);
            if (!$medication) {
                return redirect()->back()->with('error', 'Appointment Medication not found.');
            }
        } else {
            $medication = new AppointmentMedication();
        }

        $medication->appointment_id = $request->appointment_id ?? '';
        $medication->problem_condition = $request->problem_condition ?? '';
        $medication->current_medication = $request->current_medication ?? '';
        $medication->current_supplement = $request->current_supplement ?? '';
        $medication->notes = $request->notes ?? '';
        $medication->allergies_redflag = $request->allergies_redflag ?? '';
        $medication->save();
        return redirect()->back()->with('message', 'Record updated Successfully');
    }
}
