
<?php $__env->startSection('content'); ?>
    <div class="ms-content-wrapper">
        <div class="row">
            <div class="col-md-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb pl-0">
                        <li class="breadcrumb-item"><a href="javascript:;"><i class="material-icons">home</i> Home</a></li>
                        <li class="breadcrumb-item"><a href="javascript:;"><?php echo e($title); ?></a></li>
                    </ol>
                </nav>
                <div class="ms-panel">
                    <div class="ms-panel-header ms-panel-custome">
                        <h6><?php echo e($title); ?></h6>
                    </div>
                    <div class="ms-panel-body">
                        <div class="table-responsive">
                            <table class="table table-striped thead-primary w-100 dataTable-main">
                                <thead>
                                    <tr>
                                        <th scope="col">#</th>
                                        <th scope="col">Name</th>
                                        <th scope="col">Phone Number</th>
                                        <th scope="col">SSN</th>
                                        <th scope="col">Appointment Date & Time</th>
                                        <th scope="col">Status</th>
                                        <th scope="col">Check In</th>
                                        <th scope="col">Check Out</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $approveAppointmnets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <th scope="row"><?php echo e($key + 1); ?></th>
                                            <td><?php echo e($item->name ?? ''); ?></td>
                                            <td><?php echo e($item->phone_number ?? ''); ?></td>
                                            <td><?php echo e($item->social_security_number ?? '-'); ?></td>
                                            <td>
                                                <ul class="formatTime">
                                                    <li>
                                                        <h4>Date</h4>
                                                        <p><?php echo e($item->appointment_date ? \Carbon\Carbon::parse($item->appointment_date)->format('M d, Y') : ''); ?></p>
                                                    </li>
                                                    <li>
                                                        <h4>Time</h4>
                                                        <p><?php echo e($item->appointment_time ? \Carbon\Carbon::parse($item->appointment_time)->format('h:i A') : ''); ?></p>
                                                    </li>
                                                </ul>
                                            </td>
                                            <td>
                                                <?php if($item->status == 'pending'): ?>
                                                    <h2 class="main-status pending">Pending</h2>
                                                <?php elseif($item->status == 'cancel'): ?>
                                                    <h2 class="main-status cancel">Cancel</h2>
                                                <?php elseif($item->status == 'completed'): ?>
                                                    <h2 class="main-status completed">Completed</h2>
                                                <?php else: ?>
                                                    <h2 class="main-status approve">Approve</h2>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if($item->check_in == ''): ?>
                                                    <div class="btn-box">
                                                        <a href="javascript:;" data-id="<?php echo e($item->id); ?>"
                                                            data-userid="<?php echo e($item->user->id); ?>"
                                                            data-providerid="<?php echo e($item->provider->id); ?>"
                                                            class="btn btn-primary checkIn">Check In</a>
                                                    </div>
                                                <?php else: ?>
                                                    <?php
                                                        $dateTime = new \DateTime($item->check_in);
                                                        $formattedDate = $dateTime->format('F j, Y');
                                                        $formattedTime = $dateTime->format('h:i:s A');
                                                    ?>
                                                    <ul class="formatTime">
                                                        <li>
                                                            <h4>Date</h4>
                                                            <p><?php echo e($formattedDate); ?></p>
                                                        </li>
                                                        <li>
                                                            <h4>Time</h4>
                                                            <p><?php echo e($formattedTime); ?></p>
                                                        </li>
                                                    </ul>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <div class="btn-box">
                                                    <?php if($item->is_checked == 0): ?>
                                                        <a href="javascript:;" class="btn btn-primary notYet-error error">Check Out</a>
                                                    <?php else: ?>
                                                        <?php if($item->check_out == ''): ?>
                                                            <div class="btn-box">
                                                                <a href="javascript:;" data-id="<?php echo e($item->id); ?>"
                                                                    data-userid="<?php echo e($item->user->id); ?>"
                                                                    data-providerid="<?php echo e($item->provider->id); ?>"
                                                                    class="btn btn-primary notYet">Check Out</a>
                                                            </div>
                                                        <?php else: ?>
                                                            <?php
                                                                $dateTime = new \DateTime($item->check_out);
                                                                $formattedDate = $dateTime->format('F j, Y');
                                                                $formattedTime = $dateTime->format('h:i:s A');
                                                            ?>
                                                            <ul class="formatTime">
                                                                <li>
                                                                    <h4>Date</h4>
                                                                    <p><?php echo e($formattedDate); ?></p>
                                                                </li>
                                                                <li>
                                                                    <h4>Time</h4>
                                                                    <p><?php echo e($formattedTime); ?></p>
                                                                </li>
                                                            </ul>
                                                        <?php endif; ?>
                                                    <?php endif; ?>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        $('.error').click(function() {
            toastr.options = {
                "closeButton": true,
                "progressBar": true,
                "debug": false,
                "positionClass": "toast-bottom-right",
            }
            toastr.error("<?php echo e(session('error', 'CheckIn first')); ?>");
        });

        $(document).on('click', '.checkIn', function() {
            console.log('here');
            var appId = $(this).attr("data-id");
            var userId = $(this).attr("data-userid");
            var providerId = $(this).attr("data-providerid");
            console.log('appointment id', appId);
            console.log('user id', userId);
            console.log('provider id', providerId);
            $.ajax({
                type: 'GEt',
                url: '<?php echo e(route('admin.appointmentCheckIn')); ?>',
                datatype: 'json',
                data: {
                    id: appId,
                    user_id: userId,
                    provider_id: providerId,
                },
                success: function(data) {
                    console.log(data);
                    setTimeout(function() {
                        location.reload();
                    }, 1000);
                    toastr.success(data.message);
                }
            });
        });

        $(document).on('click', '.notYet', function() {
            console.log('here');
            var appId = $(this).attr("data-id");
            var userId = $(this).attr("data-userid");
            var providerId = $(this).attr("data-providerid");
            console.log('appointment id', appId);
            console.log('user id', userId);
            console.log('provider id', providerId);
            $.ajax({
                type: 'GEt',
                url: '<?php echo e(route('admin.appointmentCheckOut')); ?>',
                datatype: 'json',
                data: {
                    id: appId,
                    user_id: userId,
                    provider_id: providerId,
                },
                success: function(data) {
                    console.log(data);
                    setTimeout(function() {
                        location.reload();
                    }, 1000);
                    toastr.success(data.message);
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/holisticim/public_html/resources/views/admin/pages/staff/approveAppointmentsStaff.blade.php ENDPATH**/ ?>