<?php $__env->startSection('content'); ?>
    <div class="ms-content-wrapper">
        <div class="row">
            <div class="col-md-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb pl-0">
                        <li class="breadcrumb-item"><a href="javascript:;"><i class="material-icons">home</i> Home</a></li>
                        <li class="breadcrumb-item"><a href="javascript:;">laboratory</a></li>
                    </ol>
                </nav>
            </div>
            <div class="col-xl-12 col-md-12">
                <div class="ms-panel">
                    <div class="ms-panel-header ms-panel-custome">
                        <h6>Add laboratory</h6>
                        <a href="<?php echo e(route('admin.laboratoryView')); ?>" class="ms-text-primary">Laboratory List</a>
                    </div>
                    <div class="ms-panel-body">
                        <form class="needs-validation" action="<?php echo e(route('admin.laboratorySave')); ?>" method="POST" novalidate>
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="laboratory_id" value="<?php echo e($laboratory->id ?? ''); ?>">
                            <div class="form-row">
                                <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 mb-3">
                                    <label for="validationCustom001">Name</label>
                                    <div class="input-group">
                                        <input type="text" class="form-control" name="name"
                                            value="<?php echo e($laboratory->name ?? ''); ?>" id="validationCustom001" placeholder="Name"
                                            required>
                                    </div>
                                </div>
                                <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 mb-3">
                                    <label for="validationCustom002">Email</label>
                                    <div class="input-group">
                                        <input type="email" class="form-control" name="email"
                                            value="<?php echo e($laboratory->email ?? ''); ?>" id="validationCustom002" placeholder="Email"
                                            required>
                                    </div>
                                </div>
                                <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 mb-3">
                                    <label for="validationCustom003">Phone</label>
                                    <div class="input-group">
                                        <input type="text" class="form-control" name="phone"
                                            value="<?php echo e($laboratory->phone ?? ''); ?>" id="validationCustom003" placeholder="Phone"
                                            required>
                                    </div>
                                </div>
                                <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 mb-3">
                                    <label for="validationCustom004">Timing</label>
                                    <div class="time-box">
                                        <?php
                                            $start_time = '';
                                            $end_time = '';
                                            if (isset($laboratory->timing)) {
                                                $times = explode(' to ', $laboratory->timing);
                                                if (count($times) == 2) {
                                                    $start_time = date('H:i', strtotime($times[0]));
                                                    $end_time = date('H:i', strtotime($times[1]));
                                                }
                                            }
                                        ?>
                                        <div class="input-group">
                                            <p>Start time</p>
                                            <input type="time" class="form-control" name="start_time" value="<?php echo e($start_time); ?>" id="validationCustom004" required>
                                        </div>
                                        <div class="input-group">
                                            <p>End time</p>
                                            <input type="time" class="form-control" name="end_time" value="<?php echo e($end_time); ?>" id="validationCustom004" required>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12 mb-2">
                                    <label>Address</label>
                                    <div class="form-group">
                                        <textarea class="form-control" id="exampleTextarea1" name="address" rows="3" required><?php echo e($laboratory->address ?? ''); ?></textarea>
                                    </div>
                                </div>
                            </div>
                            <button class="btn btn-primary mt-4 d-inline w-20" type="submit">save/update</button>
                        </form>

                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/holisticim/public_html/resources/views/admin/pages/laboratory/laboratorySave.blade.php ENDPATH**/ ?>