<?php $__env->startSection('content'); ?>
    <div class="ms-content-wrapper">
        <div class="row">
            <div class="col-md-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb pl-0">
                        <li class="breadcrumb-item"><a href="javascript:;"><i class="material-icons">home</i> Home</a></li>
                        <li class="breadcrumb-item"><a href="javascript:;">Provider Room</a></li>
                    </ol>
                </nav>
                <div class="ms-panel">
                    <div class="ms-panel-header ms-panel-custome">
                        <h6>Provider Room List</h6>
                    </div>
                    <div class="ms-panel-body">
                        <div class="table-responsive">
                            <table class="table table-striped thead-primary w-100 dataTable-main">
                                <thead>
                                    <tr>
                                        <th scope="col">#</th>
                                        <th scope="col">Day</th>
                                        <th scope="col">Start Time</th>
                                        <th scope="col">End Time</th>
                                        <th scope="col">Duration</th>
                                        <th scope="col">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $providersRooms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <th scope="row"><?php echo e($key + 1); ?></th>
                                            <td><?php echo e($item->day ?? ''); ?></td>
                                            <td><?php echo e($item->start_time ? date('g:i A', strtotime($item->start_time)) : ''); ?>

                                            </td>
                                            <td><?php echo e($item->end_time ? date('g:i A', strtotime($item->end_time)) : ''); ?></td>
                                            <td><?php echo e($item->duration ?? ''); ?> Minutes</td>
                                            <td>
                                                <div class="btn-box">
                                                    <a href="javascript:;" data-id="<?php echo e($item->id); ?>"
                                                        data-start-time="<?php echo e($item->start_time); ?>"
                                                        data-end-time="<?php echo e($item->end_time); ?>"
                                                        class="icon-bt editProviderTime">
                                                        <i class="fas fa-pencil-alt ms-text-primary"></i>
                                                    </a>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="providerTime" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog ms-modal-dialog-width">
            <div class="modal-content ms-modal-content-width">
                <div class="modal-header  ms-modal-header-radius-0">
                    <h4 class="modal-title text-white">Provider Time</h4>
                    <button type="button" class="close  text-white" data-dismiss="modal" aria-hidden="true">x</button>
                </div>
                <div class="modal-body p-0 text-left">
                    <div class="col-xl-12 col-md-12">
                        <div class="ms-panel ms-panel-bshadow-none">
                            <div class="ms-panel-header">
                                <h6>Provider Time</h6>
                            </div>
                            <div class="ms-panel-body">
                                <form class="needs-validation" action="<?php echo e(route('admin.roomUpdateAdmin')); ?>" method="POST" novalidate>
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" id="roomId" name="room_id" value="">
                                    <div class="form-row">
                                        <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12 mb-3">
                                            <label for="">Start time</label>
                                            <div class="input-group">
                                                <input type="time" class="form-control" id="startTimeInput" name="start_time" value="" placeholder="Start time" required>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-row">
                                        <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12 mb-3">
                                            <label>End time</label>
                                            <div class="input-group">
                                                <input type="time" class="form-control" id="endTimeInput" name="end_time" value="" placeholder="End time" required>
                                            </div>
                                        </div>
                                    </div>
                                    <button class="btn btn-warning mt-4 d-inline w-20" type="submit">Save</button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        $(document).on('click', '.editProviderTime', function() {
            var ele = $(this).attr("data-id");
            var startTime = $(this).attr("data-start-time");
            var endTime = $(this).attr("data-end-time");
            $('#roomId').val(ele);
            $('#startTimeInput').val(startTime);
            $('#endTimeInput').val(endTime);
            $('#providerTime').modal('show');
        });

        $('#providerTime').on('hidden.bs.modal', function() {
            $('#roomId').val('');
            $('#startTimeInput').val('');
            $('#endTimeInput').val('');
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\Ahmed-Shoaib\laravel-projects\holistic-Laravel\resources\views/admin/pages/providers/providerRooms.blade.php ENDPATH**/ ?>