<?php $__env->startSection('content'); ?>
    <div class="ms-content-wrapper">
        <div class="row">
            <div class="col-md-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb pl-0">
                        <li class="breadcrumb-item"><a href="javascript:;"><i class="material-icons">home</i> Home</a></li>
                        <li class="breadcrumb-item"><a href="javascript:;">Medical Profile</a></li>
                    </ol>
                </nav>
                <div class="ms-panel">
                    <div class="ms-panel-header ms-panel-custome">
                        <h6>Medical Profile</h6>
                    </div>
                    <div class="ms-panel-body">
                        <div class="medical-profile">
                            <?php $__currentLoopData = $appointments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="user-box">
                                    <div class="user-info">
                                        <ul>
                                            <li>
                                                <span>Name</span>
                                                <p><?php echo e($item->name ?? ''); ?></p>
                                            </li>
                                            <li>
                                                <span>Appointment Date</span>
                                                <p><?php echo e($item->appointment_date ? \Carbon\Carbon::parse($item->appointment_date)->format('M d, Y') : ''); ?></p>
                                            </li>
                                            <li>
                                                <span>Appointment Time</span>
                                                <p><?php echo e($item->appointment_time ? \Carbon\Carbon::parse($item->appointment_time)->format('h:i A') : ''); ?></p>
                                            </li>
                                        </ul>
                                    </div>
                                    <div class="user-profile">
                                        <div class="head-info">
                                            <h2>Ref Flag :</h2>
                                            <p><?php echo e($item->problem); ?></p>
                                        </div>
                                        <div class="head-report">
                                            <h3>Reports</h3>
                                        </div>
                                        <?php if(isset($medicalReports[$item->id]) && count($medicalReports[$item->id]) > 0): ?>
                                            <div class="reports-box">
                                                <?php $__currentLoopData = $medicalReports[$item->id] ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="report-card">
                                                        <div class="info">
                                                            
                                                            <h4>
                                                                <?php
                                                                    // Split the filename by the last occurrence of the dot to handle multiple dots
                                                                    $filenameParts = explode('.', $data->file_name);
                                                                    // Get the extension which is the last part of the split
                                                                    $extension = array_pop($filenameParts);
                                                                    // Reconstruct the filename without the extension part
                                                                    $baseName = implode('.', $filenameParts);
                                                                    // Split the base filename by the hyphen
                                                                    $nameParts = explode('-', $baseName);
                                                                    // Get the first part of the filename
                                                                    $firstName = $nameParts[0];
                                                                    // Construct the new filename with the extension
                                                                    $newFileName = $firstName . '.' . $extension;
                                                                    echo $newFileName;
                                                                ?>
                                                            </h4>
                                                            <p><?php echo e(round($data->file_size / 1024, 2)); ?> KB</p>
                                                        </div>
                                                        <div class="icon">
                                                            <a href="<?php echo e(asset($data->file)); ?>" download><i class="fa-solid fa-download"></i></a>
                                                        </div>
                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                        <?php else: ?>
                                            <div class="head-report">
                                                <p>No reports yet to show</p>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/holisticim/public_html/resources/views/admin/pages/patient/medicalProfile.blade.php ENDPATH**/ ?>