
<?php $__env->startSection('content'); ?>
    <div class="ms-content-wrapper">
        <div class="row">
            <div class="col-md-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb pl-0">
                        <li class="breadcrumb-item"><a href="javascript:;"><i class="material-icons">home</i> Home</a></li>
                        <li class="breadcrumb-item"><a href="javascript:;">Report</a></li>
                    </ol>
                </nav>
                <div class="ms-panel">
                    <div class="ms-panel-header ms-panel-custome">
                        <h6><?php echo e($title); ?></h6>
                        <a href="javascript:;" class="btn btn-primary documentCreate">Add Report</a>
                    </div>
                    <div class="ms-panel-body">
                        <div class="documents-box">
                            <div class="row">
                                <?php $__currentLoopData = $report; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-12 col-sm-6 col-md-4 col-lg-3 col-xl-3 col-xxl-3">
                                        <div class="document-card">
                                            <div class="main-img">
                                                <?php if(in_array(strtolower(pathinfo($item->file, PATHINFO_EXTENSION)), ['jpg', 'jpeg', 'png', 'gif', 'webp'])): ?>
                                                    <img src="<?php echo e(asset($item->file)); ?>" alt="img" class="img-fluid">
                                                <?php else: ?>
                                                    <img src="<?php echo e(asset('assets/web/images/doc-img.jpg')); ?>" alt="img" class="img-fluid">
                                                <?php endif; ?>
                                            </div>
                                            <div class="desc">
                                                <h4><?php echo e($item->file_name); ?></h4>
                                                <p><?php echo e(round($item->file_size / 1024, 2)); ?> KB</p>
                                            </div>
                                            <div class="icon-list">
                                                <ul>
                                                    <li>
                                                        <a href="javascript:;" data-id="<?php echo e($item->id); ?>" class="remove-item">
                                                            <i class="fa-solid fa-trash"></i>
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a href="<?php echo e(asset($item->file)); ?>" download><i class="fa-solid fa-download"></i></a>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="documentModal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog ms-modal-dialog-width">
            <div class="modal-content ms-modal-content-width">
                <div class="modal-header  ms-modal-header-radius-0">
                    <h4 class="modal-title text-white">Add Report</h4>
                    <button type="button" class="close  text-white" data-dismiss="modal" aria-hidden="true">x</button>
                </div>
                <div class="modal-body p-0 text-left">
                    <div class="col-xl-12 col-md-12">
                        <div class="ms-panel ms-panel-bshadow-none">
                            <div class="ms-panel-header">
                                <h6>Report</h6>
                            </div>
                            <div class="ms-panel-body">
                                <form class="needs-validation" action="<?php echo e(route('admin.patientreportsSave')); ?>"
                                    method="POST" enctype="multipart/form-data" novalidate>
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="upload_by" value="<?php echo e(Auth::user()->role_type); ?>">
                                    <input type="hidden" name="user_id" value="<?php echo e($id); ?>">
                                    <div class="form-row">
                                        <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12 mb-3">
                                            <label for="validationCustom16">Report</label>
                                            <div class="input-group">
                                                <input type="file" class="form-control" name="file"
                                                    id="validationCustom16" required>
                                            </div>
                                        </div>
                                    </div>
                                    <button class="btn btn-warning mt-4 d-inline w-20" type="submit">Save</button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        $(document).on('click', '.documentCreate', function() {
            var ele = $(this).attr("data-id");
            $('#documentModal').modal('show');
        });

        $("input[type='file']").on("change", function() {
            console.log('here');
            var sizeInMB = (this.files[0].size / (1024 * 1024)).toFixed(2);
            console.log(sizeInMB);
            if (sizeInMB > 20) {
                console.log(this.files[0].size);
                toastr.options = {
                    "closeButton": true,
                    "progressBar": true
                }
                toastr.error("<?php echo e(session('error', 'Please upload file less than 20MB.')); ?>");
                $(this).val('');
            }
        });

        $(document).on('click', '.remove-item', function() {
            var ele_id = $(this).data('id');
            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#0073b1',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        type: 'post',
                        dataType: 'json',
                        url: "<?php echo e(route('admin.patientreportsDelete')); ?>",
                        data: {
                            id: ele_id,
                            _token: '<?php echo e(csrf_token()); ?>'
                        },
                        success: function(response) {
                            if (response.status == 0) {
                                toastr.error(response.message);
                            } else {
                                toastr.success(response.message);
                                location.reload();
                            }
                        }
                    });
                    console.log("here");
                }
            })
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/holisticim/public_html/resources/views/admin/pages/providers/providerPateintReports.blade.php ENDPATH**/ ?>