<?php $logo_dark = DB::table('logo')->where('slug', 'logo_dark')->where('tag', 'logo_fav')->first(); ?>
<!-- Sidebar Navigation Left -->
<aside id="ms-side-nav" class="side-nav fixed ms-aside-scrollable ms-aside-left">
    <div class="logo-sn ms-d-block-lg">
        <a href="#" class="text-center ms-logo-img-link">
            <img src="<?php echo e(asset($logo_dark->value ?? '')); ?>" alt="logo">
        </a>
        <h5 class="text-center text-white mt-2"><?php echo e(Auth::user()->name ?? ''); ?></h5>
        <?php if (\Illuminate\Support\Facades\Blade::check('admin')): ?>
            <h6 class="text-center text-white">Admin</h6>
        <?php endif; ?>
        <?php if (\Illuminate\Support\Facades\Blade::check('patient')): ?>
            <h6 class="text-center text-white">Patient</h6>
        <?php endif; ?>
        <?php if (\Illuminate\Support\Facades\Blade::check('staff')): ?>
            <h6 class="text-center text-white">Staff</h6>
        <?php endif; ?>
        <?php if (\Illuminate\Support\Facades\Blade::check('providers')): ?>
            <h6 class="text-center text-white">Providers</h6>
        <?php endif; ?>
    </div>

    <ul class="accordion ms-main-aside fs-14" id="side-nav-accordion">
        <li class="menu-item">
            <h2>General</h2>
        </li>
        <li class="menu-item">
            <a href="<?php echo e(route('admin.home')); ?>">
                <span><i class="fa-solid fa-gauge"></i>Dashboard</span>
            </a>
        </li>
        <li class="menu-item">
            <a href="<?php echo e(route('web.home')); ?>" target="_blank">
                <span><i class="fa fa-globe"></i>Visit website</span>
            </a>
        </li>
        <?php if (\Illuminate\Support\Facades\Blade::check('admin')): ?>
            <li class="menu-item">
                <a href="#" class="has-chevron" data-toggle="collapse" data-target="#config" aria-expanded="false"
                    aria-controls="config">
                    <span><i class="far fa-globe"></i>Config Management</span>
                </a>
                <ul id="config" class="collapse" aria-labelledby="config" data-parent="#side-nav-accordion">
                    <li>
                        <a href="<?php echo e(route('admin.logoEdit')); ?>">Logo/Fav</a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('admin.configEdit')); ?>">Config</a>
                    </li>
                </ul>
            </li>
            <li class="menu-item">
                <a href="<?php echo e(route('admin.announcemenView')); ?>">
                    <span><i class="fa fa-bars"></i>Announcement</span>
                </a>
            </li>
            <li class="menu-item">
                <a href="<?php echo e(route('admin.usersNewsletters')); ?>">
                    <span><i class="fa fa-bars"></i>Newsletter</span>
                </a>
            </li>
            <li class="menu-item">
                <h2>Providers Management</h2>
            </li>
            <li class="menu-item">
                <a href="<?php echo e(route('admin.providerList')); ?>">
                    <span><i class="fa fa-bars"></i>Providers</span>
                </a>
            </li>

            <li class="menu-item">
                <h2>Staff Management</h2>
            </li>
            <li class="menu-item">
                <a href="<?php echo e(route('admin.staffList')); ?>">
                    <span><i class="fa fa-bars"></i>Staff</span>
                </a>
            </li>

            <li class="menu-item">
                <h2>Pateint Management</h2>
            </li>
            <li class="menu-item">
                <a href="<?php echo e(route('admin.pateintList')); ?>">
                    <span><i class="fa fa-bars"></i>Pateint</span>
                </a>
            </li>
            <li class="menu-item">
                <a href="#" class="has-chevron" data-toggle="collapse" data-target="#memberappointment" aria-expanded="false"
                    aria-controls="memberappointment">
                    <span><i class="far fa-globe"></i>Appointment Management</span>
                </a>
                <ul id="memberappointment" class="collapse" aria-labelledby="memberappointment" data-parent="#side-nav-accordion">
                    <li>
                        <a href="<?php echo e(route('admin.allAppointmentFilter')); ?>">Member Appointment</a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('admin.ApppointmentList')); ?>">Non Member Appointment</a>
                    </li>
                </ul>
            </li>

            <li class="menu-item">
                <h2>Managements</h2>
            </li>
            <li class="menu-item">
                <a href="<?php echo e(route('admin.packageView')); ?>">
                    <span><i class="fa fa-bars"></i>Packages</span>
                </a>
            </li>
            <li class="menu-item">
                <a href="<?php echo e(route('admin.laboratoryView')); ?>">
                    <span><i class="fa fa-bars"></i>Laboratory</span>
                </a>
            </li>
            <li class="menu-item">
                <a href="<?php echo e(route('admin.pharmaceuticalView')); ?>">
                    <span><i class="fa fa-bars"></i>Pharmaceutical</span>
                </a>
            </li>
            <li class="menu-item">
                <a href="<?php echo e(route('admin.contactInquiry')); ?>">
                    <span><i class="fa fa-bars"></i>Inquiry Management</span>
                </a>
            </li>
            <li class="menu-item">
                <a href="<?php echo e(route('admin.servicesView')); ?>">
                    <span><i class="fa fa-bars"></i>Services Management</span>
                </a>
            </li>
            <li class="menu-item">
                <a href="<?php echo e(route('admin.testimonialsView')); ?>">
                    <span><i class="fa fa-list"></i>Testimonials Management</span>
                </a>
            </li>
            <li class="menu-item">
                <h2>CMS Managements</h2>
            </li>
            <li class="menu-item">
                <a href="<?php echo e(route('cms.Home')); ?>">
                    <span><i class="fa fa-bars"></i>Home</span>
                </a>
            </li>
            <li class="menu-item">
                <a href="<?php echo e(route('cms.AboutUs')); ?>">
                    <span><i class="fa fa-bars"></i>About us</span>
                </a>
            </li>
            <li class="menu-item">
                <a href="<?php echo e(route('cms.Pricing')); ?>">
                    <span><i class="fa fa-bars"></i>Pricing</span>
                </a>
            </li>
            <li class="menu-item">
                <a href="<?php echo e(route('cms.Services')); ?>">
                    <span><i class="fa fa-bars"></i>Services</span>
                </a>
            </li>
            <li class="menu-item">
                <a href="<?php echo e(route('cms.Providers')); ?>">
                    <span><i class="fa fa-bars"></i>Providers</span>
                </a>
            </li>
            <li class="menu-item">
                <a href="<?php echo e(route('cms.CustomerCare')); ?>">
                    <span><i class="fa fa-bars"></i>Customer Care</span>
                </a>
            </li>
            <li class="menu-item">
                <a href="<?php echo e(route('cms.PrivacyPolicy')); ?>">
                    <span><i class="fa fa-bars"></i>Privacy Policy</span>
                </a>
            </li>
            <li class="menu-item">
                <a href="<?php echo e(route('cms.Support')); ?>">
                    <span><i class="fa fa-bars"></i>24/7 Support</span>
                </a>
            </li>
        <?php endif; ?>

        <?php if (\Illuminate\Support\Facades\Blade::check('patient')): ?>
            <li class="menu-item">
                <h2>Managements</h2>
            </li>
            <li class="menu-item">
                <a href="#" class="has-chevron" data-toggle="collapse" data-target="#pateintappointment"
                    aria-expanded="false" aria-controls="pateintappointment">
                    <span><i class="far fa-check-square"></i>Appointment</span>
                </a>
                <ul id="pateintappointment" class="collapse" aria-labelledby="pateintappointment" data-parent="#side-nav-accordion">
                    <li> <a href="<?php echo e(route('admin.patientAppointmnet')); ?>">Make Appointment</a> </li>
                    <li> <a href="<?php echo e(route('admin.patientAppointmnetList')); ?>">Appointment List</a> </li>
                </ul>
            </li>
            <li class="menu-item">
                <a href="<?php echo e(route('admin.usersChat')); ?>">
                    <span><i class="material-icons fs-16">chat</i>Send Messages</span>
                </a>
            </li>
            <li class="menu-item">
                <a href="<?php echo e(route('admin.paymentHistory')); ?>">
                    <span><i class="fas fa-list-alt"></i>Payment History</span>
                </a>
            </li>
            <li class="menu-item">
                <a href="#" class="has-chevron" data-toggle="collapse" data-target="#Documents" aria-expanded="false"
                    aria-controls="Documents">
                    <span><i class="fas fa-file-alt"></i>Documents</span>
                </a>
                <ul id="Documents" class="collapse" aria-labelledby="Documents" data-parent="#side-nav-accordion">
                    <li> <a href="<?php echo e(route('admin.patientDocumentsList')); ?>">Documents</a> </li>
                    <li> <a href="<?php echo e(route('admin.ReportsDocumentList')); ?>">Reports</a> </li>
                </ul>
            </li>
            
            <li class="menu-item">
                <a href="<?php echo e(route('admin.membershipManage')); ?>">
                    <span><i class="fas fa-list-alt"></i>Membership</span>
                </a>
            </li>
            <li class="menu-item">
                <a href="javascript:void(0);" onclick="checkAccessMedicalProfile()">
                    <span><i class="fas fa-list-alt"></i>Medical Profile</span>
                </a>
            </li>

            <script>
                function checkAccessMedicalProfile() {
                    <?php if(Auth::user()->access_medical_profile == 0): ?>
                        $('#accessprofileModal').modal('show');
                    <?php else: ?>
                        window.location.href = "<?php echo e(route('admin.medicalProfileAccess')); ?>";
                    <?php endif; ?>
                }
            </script>
        <?php endif; ?>

        <?php if (\Illuminate\Support\Facades\Blade::check('providers')): ?>
            <li class="menu-item">
                <h2>Managements</h2>
            </li>
            <li class="menu-item">
                <a href="<?php echo e(route('admin.providerPateints')); ?>">
                    <span><i class="fa fa-bars"></i>Pateints</span>
                </a>
            </li>
            <li class="menu-item">
                <a href="<?php echo e(route('admin.roomsView')); ?>">
                    <span><i class="fa fa-bars"></i>Room</span>
                </a>
            </li>
            <li class="menu-item">
                <a href="#" class="has-chevron" data-toggle="collapse" data-target="#providerappointment"
                    aria-expanded="false" aria-controls="providerappointment">
                    <span><i class="far fa-check-square"></i>Appointments</span>
                </a>
                <ul id="providerappointment" class="collapse" aria-labelledby="providerappointment" data-parent="#side-nav-accordion">
                    <li> <a href="<?php echo e(route('admin.providerAppointmnetList')); ?>">Member Appointment List</a></li>
                </ul>
            </li>
            <li class="menu-item">
                <a href="<?php echo e(route('admin.usersChat')); ?>">
                    <span><i class="material-icons fs-16">chat</i>Send Messages</span>
                </a>
            </li>
            <li class="menu-item">
                <a href="<?php echo e(route('admin.laboratoryView')); ?>">
                    <span><i class="fa fa-bars"></i>Laboratory</span>
                </a>
            </li>
            <li class="menu-item">
                <a href="<?php echo e(route('admin.pharmaceuticalView')); ?>">
                    <span><i class="fa fa-bars"></i>Pharmaceutical</span>
                </a>
            </li>
        <?php endif; ?>

        <?php if (\Illuminate\Support\Facades\Blade::check('staff')): ?>
            <li class="menu-item">
                <h2>Appointments</h2>
            </li>
            <li class="menu-item">
                <a href="<?php echo e(route('admin.inStaffPatientList')); ?>">
                    <span><i class="fa fa-bars"></i>Pateint</span>
                </a>
            </li>
            <li class="menu-item">
                <a href="<?php echo e(route('admin.staffAppointmnetList')); ?>">
                    <span><i class="fa fa-bars"></i>Appointment List</span>
                </a>
            </li>
            <li class="menu-item">
                <a href="<?php echo e(route('admin.approvedAppointmnets')); ?>">
                    <span><i class="fa fa-bars"></i>Approved Appointments</span>
                </a>
            </li>
            <li class="menu-item">
                <a href="<?php echo e(route('admin.usersChat')); ?>">
                    <span><i class="material-icons fs-16">chat</i>Send Messages</span>
                </a>
            </li>
        <?php endif; ?>
    </ul>
</aside>
<!-- Sidebar Right -->
<aside id="ms-recent-activity" class="side-nav fixed ms-aside-right ms-scrollable">
    <div class="ms-aside-header">
        <ul class="nav nav-tabs tabs-bordered d-flex nav-justified mb-3" role="tablist">
            <li role="presentation" class="fs-12"><a href="#activityLog" aria-controls="activityLog"
                    class="active" role="tab" data-toggle="tab"> Activity Log</a></li>
            <li role="presentation" class="fs-12"><a href="#recentPosts" aria-controls="recentPosts"
                    role="tab" data-toggle="tab"> Settings </a></li>
            <li><button type="button" class="close ms-toggler text-center" data-target="#ms-recent-activity"
                    data-toggle="slideRight"><span aria-hidden="true">&times;</span></button></li>
        </ul>
    </div>
    <div class="ms-aside-body">
        <div class="tab-content">
            <div role="tabpanel" class="tab-pane active fade show" id="activityLog">
                <ul class="ms-activity-log">
                    <li>
                        <div class="ms-btn-icon btn-pill icon btn-light">
                            <i class="flaticon-gear"></i>
                        </div>
                        <h6>Update 1.0.0 Pushed</h6>
                        <span> <i class="material-icons">event</i>1 January, 2019</span>
                        <p class="fs-14">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Quisque scelerisque
                            diam non
                            nisi semper, ula in sodales vehicula....</p>
                    </li>
                    <li>
                        <div class="ms-btn-icon btn-pill icon btn-success">
                            <i class="flaticon-tick-inside-circle"></i>
                        </div>
                        <h6>Profile Updated</h6>
                        <span> <i class="material-icons">event</i>4 March, 2018</span>
                        <p class="fs-14">Curabitur purus sem, malesuada eu luctus eget, suscipit sed turpis. Nam
                            pellentesque
                            felis vitae justo accumsan, sed semper nisi sollicitudin...</p>
                    </li>
                    <li>
                        <div class="ms-btn-icon btn-pill icon btn-warning">
                            <i class="flaticon-alert-1"></i>
                        </div>
                        <h6>Your payment is due</h6>
                        <span> <i class="material-icons">event</i>1 January, 2019</span>
                        <p class="fs-14">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Quisque scelerisque
                            diam non
                            nisi semper, ula in sodales vehicula....</p>
                    </li>
                    <li>
                        <div class="ms-btn-icon btn-pill icon btn-danger">
                            <i class="flaticon-alert"></i>
                        </div>
                        <h6>Database Error</h6>
                        <span> <i class="material-icons">event</i>4 March, 2018</span>
                        <p class="fs-14">Curabitur purus sem, malesuada eu luctus eget, suscipit sed turpis. Nam
                            pellentesque
                            felis vitae justo accumsan, sed semper nisi sollicitudin...</p>
                    </li>
                    <li>
                        <div class="ms-btn-icon btn-pill icon btn-info">
                            <i class="flaticon-information"></i>
                        </div>
                        <h6>Checkout what's Trending</h6>
                        <span> <i class="material-icons">event</i>1 January, 2019</span>
                        <p class="fs-14">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Quisque scelerisque
                            diam non
                            nisi semper, ula in sodales vehicula....</p>
                    </li>
                    <li>
                        <div class="ms-btn-icon btn-pill icon btn-secondary">
                            <i class="flaticon-diamond"></i>
                        </div>
                        <h6>Your Dashboard is ready</h6>
                        <span> <i class="material-icons">event</i>4 March, 2018</span>
                        <p class="fs-14">Curabitur purus sem, malesuada eu luctus eget, suscipit sed turpis. Nam
                            pellentesque
                            felis vitae justo accumsan, sed semper nisi sollicitudin...</p>
                    </li>
                </ul>
                <a href="#" class="btn btn-primary d-block"> View All </a>
            </div>
            <div role="tabpanel" class="tab-pane fade" id="recentPosts">
                <h6>General Settings</h6>
                <div class="ms-form-group">
                    <span class="ms-option-name fs-14">Location Tracking</span>
                    <label class="ms-switch float-right">
                        <input type="checkbox">
                        <span class="ms-switch-slider round"></span>
                    </label>
                </div>
                <div class="ms-form-group">
                    <span class="ms-option-name fs-14">Allow Notifications</span>
                    <label class="ms-switch float-right">
                        <input type="checkbox">
                        <span class="ms-switch-slider round"></span>
                    </label>
                </div>
                <div class="ms-form-group">
                    <span class="ms-option-name fs-14">Allow Popups</span>
                    <label class="ms-switch float-right">
                        <input type="checkbox" checked>
                        <span class="ms-switch-slider round"></span>
                    </label>
                </div>
                <h6>Log Settings</h6>
                <div class="ms-form-group">
                    <span class="ms-option-name fs-14">Enable Logging</span>
                    <label class="ms-switch float-right">
                        <input type="checkbox" checked>
                        <span class="ms-switch-slider round"></span>
                    </label>
                </div>
                <div class="ms-form-group">
                    <span class="ms-option-name fs-14">Audit Logs</span>
                    <label class="ms-switch float-right">
                        <input type="checkbox">
                        <span class="ms-switch-slider round"></span>
                    </label>
                </div>
                <div class="ms-form-group">
                    <span class="ms-option-name fs-14">Error Logs</span>
                    <label class="ms-switch float-right">
                        <input type="checkbox" checked>
                        <span class="ms-switch-slider round"></span>
                    </label>
                </div>
                <h6>Advanced Settings</h6>
                <div class="ms-form-group">
                    <span class="ms-option-name fs-14">Enable Logging</span>
                    <label class="ms-switch float-right">
                        <input type="checkbox" checked>
                        <span class="ms-switch-slider round"></span>
                    </label>
                </div>
                <div class="ms-form-group">
                    <span class="ms-option-name fs-14">Audit Logs</span>
                    <label class="ms-switch float-right">
                        <input type="checkbox">
                        <span class="ms-switch-slider round"></span>
                    </label>
                </div>
                <div class="ms-form-group">
                    <span class="ms-option-name fs-14">Error Logs</span>
                    <label class="ms-switch float-right">
                        <input type="checkbox" checked>
                        <span class="ms-switch-slider round"></span>
                    </label>
                </div>
            </div>
        </div>
    </div>
</aside>
<?php /**PATH D:\xampp\htdocs\Ahmed-Shoaib\laravel-projects\holistic-Laravel\resources\views/admin/layouts/sidebar.blade.php ENDPATH**/ ?>