
<?php $__env->startSection('content'); ?>
    <div class="ms-content-wrapper">
        <div class="row">
            <div class="col-md-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb pl-0">
                        <li class="breadcrumb-item"><a href="javascript:;"><i class="material-icons">home</i> Home</a></li>
                        <li class="breadcrumb-item"><a href="javascript:;"><?php echo e($title); ?></a></li>
                    </ol>
                </nav>
                <div class="ms-panel">
                    <div class="ms-panel-header ms-panel-custome">
                        <h6><?php echo e($title); ?></h6>
                    </div>
                    <div class="ms-panel-body">
                        <div class="filter-area">
                            <div class="filter-box">
                                <h5>Filter by</h5>
                                <form action="" method="GET" id="filterForm">
                                    <div class="input-group">
                                        <select class="form-control filteryBy" name="filter_by" required>
                                            <option selected disabled>select option</option>
                                            <option value="all" <?php echo e((isset($filterby) && $filterby == 'all') ? 'selected' : ''); ?>>All</option>
                                            <option value="weekly" <?php echo e((isset($filterby) && $filterby == 'weekly') ? 'selected' : ''); ?>>Current Week</option>
                                            <option value="monthly" <?php echo e((isset($filterby) && $filterby == 'monthly') ? 'selected' : ''); ?>>Current Month</option>
                                        </select>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <div class="table-responsive">
                            <table class="table table-striped thead-primary w-100 dataTable-main appointmentData">
                                <thead>
                                    <tr>
                                        <th scope="col">#</th>
                                        <th scope="col">Name</th>
                                        <th scope="col">Phone Number</th>
                                        <th scope="col">SSN</th>
                                        <th scope="col">Appointment Date & Time</th>
                                        
                                        <th scope="col">Check In</th>
                                        <th scope="col">Check Out</th>
                                        <th scope="col">Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $allAppointments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <th scope="row"><?php echo e($key + 1); ?></th>
                                            <td><?php echo e($item->name ?? ''); ?></td>
                                            <td>
                                                <?php if(empty($item->phone_number)): ?>
                                                    <?php echo e($item->user->phone ?? '-'); ?>

                                                <?php else: ?>
                                                    <?php echo e($item->phone_number ?? '-'); ?>

                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if(empty($item->social_security_number)): ?>
                                                    <?php echo e($item->user->social_security_number ?? '-'); ?>

                                                <?php else: ?>
                                                    <?php echo e($item->social_security_number ?? '-'); ?>

                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <ul class="formatTime">
                                                    <li>
                                                        <h4>Date</h4>
                                                        <p><?php echo e($item->appointment_date ? \Carbon\Carbon::parse($item->appointment_date)->format('M d, Y') : ''); ?>

                                                        </p>
                                                    </li>
                                                    <li>
                                                        <h4>Time</h4>
                                                        <p><?php echo e($item->appointment_time ? \Carbon\Carbon::parse($item->appointment_time)->format('h:i A') : ''); ?>

                                                        </p>
                                                    </li>
                                                </ul>
                                            </td>
                                            
                                            <td>
                                                <?php if($item->status == 'cancel'): ?>
                                                    <p>-----</p>
                                                <?php else: ?>
                                                    <?php if($item->check_in == ''): ?>
                                                        <p>-----</p>
                                                    <?php else: ?>
                                                        <?php
                                                            $dateTime = new \DateTime($item->check_in);
                                                            $formattedDate = $dateTime->format('F j, Y');
                                                            $formattedTime = $dateTime->format('h:i:s A');
                                                        ?>
                                                        <ul class="formatTime">
                                                            <li>
                                                                <h4>Date</h4>
                                                                <p><?php echo e($formattedDate); ?></p>
                                                            </li>
                                                            <li>
                                                                <h4>Time</h4>
                                                                <p><?php echo e($formattedTime); ?></p>
                                                            </li>
                                                        </ul>
                                                    <?php endif; ?>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if($item->status == 'cancel'): ?>
                                                    <p>-----</p>
                                                <?php else: ?>
                                                    <div class="btn-box">
                                                        <?php if($item->is_checked == 0): ?>
                                                            <p>-----</p>
                                                        <?php else: ?>
                                                            <?php if($item->check_out == ''): ?>
                                                                <p>-----</p>
                                                            <?php else: ?>
                                                                <?php
                                                                    $dateTime = new \DateTime($item->check_out);
                                                                    $formattedDate = $dateTime->format('F j, Y');
                                                                    $formattedTime = $dateTime->format('h:i:s A');
                                                                ?>
                                                                <ul class="formatTime">
                                                                    <li>
                                                                        <h4>Date</h4>
                                                                        <p><?php echo e($formattedDate); ?></p>
                                                                    </li>
                                                                    <li>
                                                                        <h4>Time</h4>
                                                                        <p><?php echo e($formattedTime); ?></p>
                                                                    </li>
                                                                </ul>
                                                            <?php endif; ?>
                                                        <?php endif; ?>
                                                    </div>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if($item->status == 'pending'): ?>
                                                    <h2 class="main-status pending">Pending</h2>
                                                <?php elseif($item->status == 'cancel'): ?>
                                                    <h2 class="main-status cancel">Cancel</h2>
                                                <?php elseif($item->status == 'completed'): ?>
                                                    <h2 class="main-status completed">Completed</h2>
                                                <?php else: ?>
                                                    <h2 class="main-status approve">Approve</h2>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        $(document).on('change', '.filteryBy', function() {
            $("#filterForm").submit();
        });
    </script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\Ahmed-Shoaib\laravel-projects\holistic-Laravel\resources\views/admin/pages/appointment/allMemeberapointments.blade.php ENDPATH**/ ?>