<?php $__env->startSection('content'); ?>
    <div class="ms-content-wrapper">
        <div class="row">
            <div class="col-md-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb pl-0">
                        <li class="breadcrumb-item"><a href="javascript:;"><i class="material-icons">home</i> Home</a></li>
                        <li class="breadcrumb-item"><a href="javascript:;"><?php echo e($title); ?></a></li>
                    </ol>
                </nav>
                <div class="ms-panel">
                    <div class="ms-panel-header ms-panel-custome">
                        <h6><?php echo e($title); ?></h6>
                    </div>
                    <div class="ms-panel-body">
                        <form class="needs-validation form-details" action="<?php echo e(route('admin.medicationHistorySave')); ?>"
                            method="POST" novalidate>
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="appointment_id" value="<?php echo e($id ?? ''); ?>">
                            <input type="hidden" name="medication_id" value="<?php echo e($medication->id ?? ''); ?>">
                            <div class="medication-box">
                                <h2>Problems & Conditions</h2>
                                <div class="form-row">
                                    <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12 mb-2">
                                        <div class="input-group">
                                            <textarea class="form-control" placeholder="Problems & Conditions" id="exampleTextarea" name="problem_condition"
                                                rows="4"><?php echo e($medication->problem_condition ?? ''); ?></textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="medication-box">
                                <h2>Current Medications</h2>
                                <div class="form-row">
                                    <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12 mb-2">
                                        <div class="input-group">
                                            <textarea class="form-control" placeholder="Current Medications" id="exampleTextarea" name="current_medication"
                                                rows="4"><?php echo e($medication->current_medication ?? ''); ?></textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="medication-box">
                                <h2>Current Supplements</h2>
                                <div class="form-row">
                                    <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12 mb-2">
                                        <div class="input-group">
                                            <textarea class="form-control" placeholder="Current Supplements" id="exampleTextarea" name="current_supplement"
                                                rows="4"><?php echo e($medication->current_supplement ?? ''); ?></textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="medication-box">
                                <h2>Notes & Charts</h2>
                                <div class="form-row">
                                    <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12 mb-2">
                                        <div class="input-group">
                                            <textarea class="form-control" placeholder="Notes & Charts" id="exampleTextarea" name="notes" rows="4"><?php echo e($medication->notes ?? ''); ?>

                                            </textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="medication-box">
                                <h2>Allergies & Red flags</h2>
                                <div class="form-row">
                                    <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12 mb-2">
                                        <div class="input-group">
                                            <textarea class="form-control" placeholder="Allergies & Red flags" id="exampleTextarea" name="allergies_redflag"
                                                rows="4"><?php echo e(isset($medication) && !empty($medication->allergies_redflag) ? $medication->allergies_redflag : ($redFlag->problem ?? '')); ?></textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <button class="btn btn-primary mt-4 d-inline w-20" type="submit">Save</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/holisticim/public_html/resources/views/admin/pages/providers/appointmentMedication.blade.php ENDPATH**/ ?>