<?php $__env->startSection('content'); ?>
    <div class="ms-content-wrapper">
        <div class="row">
            <div class="col-md-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb pl-0">
                        <li class="breadcrumb-item"><a href="javascript:;"><i class="material-icons">home</i> Home</a></li>
                        <li class="breadcrumb-item"><a href="javascript:;"><?php echo e($title); ?></a></li>
                    </ol>
                </nav>
                <div class="ms-panel">
                    <div class="ms-panel-header ms-panel-custome">
                        <h6><?php echo e($title); ?></h6>
                    </div>
                    <div class="ms-panel-body">
                        <div class="table-responsive">
                            <table class="table table-striped thead-primary w-100 dataTable-main">
                                <thead>
                                    <tr>
                                        <th scope="col">#</th>
                                        <th scope="col">Name</th>
                                        <th scope="col">Phone Number</th>
                                        <th scope="col">SSN</th>
                                        <th scope="col">Appointment Date & Time</th>
                                        <th scope="col">Re-schedule</th>
                                        <th scope="col">Request for test</th>
                                        <th scope="col">Status</th>
                                        <th scope="col">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $appList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <th scope="row"><?php echo e($key + 1); ?></th>
                                            <td><?php echo e($item->name ?? ''); ?></td>
                                            <td>
                                                <?php if(empty($item->phone_number)): ?>
                                                    <?php echo e($item->user->phone ?? '-'); ?>

                                                <?php else: ?>
                                                    <?php echo e($item->phone_number ?? '-'); ?>

                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if(empty($item->social_security_number)): ?>
                                                    <?php echo e($item->user->social_security_number ?? '-'); ?>

                                                <?php else: ?>
                                                    <?php echo e($item->social_security_number ?? '-'); ?>

                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <ul class="formatTime">
                                                    <li>
                                                        <h4>Date</h4>
                                                        <p><?php echo e($item->appointment_date ? \Carbon\Carbon::parse($item->appointment_date)->format('M d, Y') : ''); ?></p>
                                                    </li>
                                                    <li>
                                                        <h4>Time</h4>
                                                        <p><?php echo e($item->appointment_time ? \Carbon\Carbon::parse($item->appointment_time)->format('h:i A') : ''); ?></p>
                                                    </li>
                                                </ul>
                                            </td>
                                            <td>
                                                <?php if($item->status == 'cancel'): ?>
                                                    <p>-----</p>
                                                <?php else: ?>
                                                    <?php if($item->is_checked == 0): ?>
                                                        <div class="btn-box">
                                                            <a href="javascript:;" data-id="<?php echo e($item->id); ?>"
                                                                data-userid="<?php echo e($item->user->id); ?>"
                                                                data-providerid="<?php echo e($item->provider->id); ?>"
                                                                data-providername="<?php echo e($item->provider->name); ?>"
                                                                class="btn btn-primary reschedule">Re-schedule</a>
                                                        </div>
                                                    <?php else: ?>
                                                        <p>Pateint Checked In</p>
                                                    <?php endif; ?>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if($item->status == 'cancel'): ?>
                                                    <p>-----</p>
                                                <?php else: ?>
                                                    <?php if($item->is_checked == 0): ?>
                                                        <div class="btn-box">
                                                            <a href="javascript:;" class="btn btn-primary reportAdd">Test request</a>
                                                        </div>
                                                    <?php else: ?>
                                                        <div class="btn-box">
                                                            <a href="javascript:;" data-id="<?php echo e($item->id); ?>"
                                                                class="btn btn-primary test-request">Test request
                                                            </a>
                                                        </div>
                                                    <?php endif; ?>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if($item->status == 'pending'): ?>
                                                    <h2 class="main-status pending">Pending</h2>
                                                <?php elseif($item->status == 'cancel'): ?>
                                                    <h2 class="main-status cancel">Cancel</h2>
                                                <?php elseif($item->status == 'completed'): ?>
                                                    <h2 class="main-status completed">Completed</h2>
                                                <?php else: ?>
                                                    <h2 class="main-status approve">Approve</h2>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <div class="btn-box">
                                                    <a data-id="<?php echo e($item->id); ?>" class="remove-item icon-bt">
                                                        <i class="far fa-trash-alt ms-text-danger"></i>
                                                    </a>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="reScheduleModal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog ms-modal-dialog-width">
            <div class="modal-content ms-modal-content-width">
                <div class="modal-header  ms-modal-header-radius-0">
                    <h4 class="modal-title text-white">Re-schedule Appointment</h4>
                    <button type="button" class="close  text-white" data-dismiss="modal" aria-hidden="true">x</button>
                </div>
                <div class="modal-body p-0 text-left">
                    <div class="col-xl-12 col-md-12">
                        <div class="ms-panel ms-panel-bshadow-none">
                            <div class="ms-panel-header">
                                <h6>Re-schedule Appointment</h6>
                            </div>
                            <div class="ms-panel-body">
                                <form class="needs-validation form-details" novalidate>
                                    <input type="hidden" id="appointment_id" name="appointment_id" value="">
                                    <input type="hidden" id="user_id" name="user_id" value="">
                                    <input type="hidden" id="provider_id" name="provider_id" value="">
                                    <div class="form-row">
                                        <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 mb-3">
                                            <label>Choose Doctor</label>
                                            <div class="input-group">
                                                <div class="input-group">
                                                    <input type="text" class="form-control" name="provider_name"
                                                        id="provider_name" value="" placeholder="" disabled>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 mb-3">
                                            <label>Appointment Date</label>
                                            <div class="input-group">
                                                <input type="date" class="form-control appointmentDate" name="appointment_date"
                                                    id="appointmentDate" placeholder="Appointment Date" required>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-row">
                                        <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12 mb-2" id="schedules"
                                            style="display: none;">
                                            <label>Appointment Time</label>
                                            <div class="day-select"></div>
                                        </div>
                                    </div>
                                    <button class="btn btn-primary mt-4 d-inline w-20 appointmntSubmit" type="button">Save</button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <div class="modal fade" id="requestTestModal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog ms-modal-dialog-width">
            <div class="modal-content ms-modal-content-width">
                <div class="modal-header  ms-modal-header-radius-0">
                    <h4 class="modal-title text-white">Request for laboratory test</h4>
                    <button type="button" class="close  text-white" data-dismiss="modal" aria-hidden="true">x</button>
                </div>
                <div class="modal-body p-0 text-left">
                    <div class="col-xl-12 col-md-12">
                        <div class="ms-panel ms-panel-bshadow-none">
                            <div class="ms-panel-header">
                                <h6>Request for laboratory test</h6>
                            </div>
                            <div class="ms-panel-body">
                                <form class="needs-validation form-details" novalidate>
                                    <input type="hidden" id="appointment_id" name="appointment_id" value="">
                                    <div class="form-row">
                                        <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12 mb-3">
                                            <label>Choose laboratory</label>
                                            <div class="input-group">
                                                <select class="form-control" id="providerId" name="provider_id" required>
                                                    <option selected disabled>Select laboratory</option>
                                                    <?php $__currentLoopData = $labs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($item->id); ?>" data-name="<?php echo e($item->name); ?>"><?php echo e($item->name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12 mb-3">
                                            <label>Priscription</label>
                                            <div class="input-group">
                                                <textarea class="form-control" name="" id="" rows="4" required></textarea>
                                            </div>
                                        </div>
                                        <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12 mb-3">
                                            <label>Upload file</label>
                                            <div class="input-group">
                                                <input type="file" class="form-control" name=""
                                                    id="" placeholder="Upload file" required>
                                            </div>
                                        </div>
                                    </div>
                                    <button class="btn btn-primary mt-4 d-inline w-20" type="button">Send</button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?>
    <style>
        .form-row .day-select .table thead th {
            font-size: 16px;
            padding: 10px 10px;
        }
        .form-row .day-select .table tbody tr td .form-check {
            width: 100px;
        }
        .form-row .day-select .table tbody tr td {
            padding: 8px 8px;
        }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        $('.reportAdd').click(function() {
            toastr.options = {
                "closeButton": true,
                "progressBar": true,
                "debug": false,
                "positionClass": "toast-bottom-right",
            }
            toastr.error("<?php echo e(session('error', 'Pateint Not Checkedin Yet')); ?>");
        });
        $(document).on('click', '.test-request', function() {
            $('#requestTestModal').modal('show');
            var appId = $(this).attr("data-id");
        });
        $(document).on('click', '.reschedule', function() {
            $('#reScheduleModal').modal('show');
            var appId = $(this).attr("data-id");
            var userId = $(this).attr("data-userid");
            var providerId = $(this).attr("data-providerid");
            var providerName = $(this).attr("data-providername");
            console.log('appointment id', appId);
            console.log('user id', userId);
            console.log('provider id', providerId);
            $('#appointment_id').val(appId);
            $('#user_id').val(userId);
            $('#provider_id').val(providerId);
            $('#provider_name').val(providerName);
        });

        $('#reScheduleModal').on('hidden.bs.modal', function () {
            $(this).find('form')[0].reset();
            $('#appointment_id').val('');
            $('#user_id').val('');
            $('#provider_id').val('');
            $('#provider_name').val('');
            $('#appointmentDate').val('');
            $('#schedules').hide();
            $('.day-select').empty();
        });

        $(document).on('click', '.appointmntSubmit', function() {
            var $button = $(this);
            var originalText = $button.text();
            $button.text('Submitting...').css({
                'cursor': 'not-allowed',
                'pointer-events': 'none'
            });
            var ele_id = $('#appointment_id').val();
            var user_id = $('#user_id').val();
            var provider_id = $('#provider_id').val();
            var appointment_date = $("input[name='appointment_time']:checked").attr('data-daydate');
            var appointment_time = $("input[name='appointment_time']:checked").val();
            $.ajax({
                type: 'POST',
                url: '<?php echo e(route('admin.reScheduleAppointment')); ?>',
                datatype: 'json',
                data: {
                    id: ele_id,
                    user_id: user_id,
                    provider_id: provider_id,
                    appointment_date: appointment_date,
                    appointment_time: appointment_time,
                    _token: '<?php echo e(csrf_token()); ?>'
                },
                success: function(data) {
                    console.log(data);
                    setTimeout(function() {
                        location.reload();
                    }, 1000);
                    toastr.success(data.message);
                }
            });
        });

        $(document).on('change', '.appointmentDate', function() {
            var selectedDay = getSelectedDay();
            appointmentData(selectedDay);
            $('#schedules').css("display", "block");
        });

        document.addEventListener('DOMContentLoaded', function () {
            var today = new Date().toISOString().split('T')[0]; // Get today's date in YYYY-MM-DD format
            document.getElementById("appointmentDate").setAttribute('min', today);
        });

        function getSelectedDay() {
            var selectedDate = $('#appointmentDate').val();
            var date = new Date(selectedDate);
            var dayOfWeek = date.toLocaleDateString('en-US', { weekday: 'long' });
            return dayOfWeek;
        }

        function appointmentData(selectedDay) {
            var provider_id = $('#provider_id').val();
            var user_id = $('#user_id').val();
            var appointment_date = $('#appointmentDate').val();
            if (provider_id == null || provider_id == '' || appointment_date == null || appointment_date == '' ) {
                return;
            }

            $.ajax({
                type: 'GEt',
                url: '<?php echo e(route('admin.getRooms')); ?>',
                datatype: 'json',
                data: {
                    provider_id: provider_id,
                    user_id: user_id,
                    appointment_date: appointment_date,
                    selected_day: selectedDay,
                },
                success: function(data) {
                    console.log(data);
                    // schedulesApp(data);
                    if (data.rooms.length != undefined && data.rooms.length != null && data.rooms.length > 0) {
                        schedulesApp2(data,appointment_date);
                    } else {
                        $('.day-select').html('<h2>Not available</h2>');
                    }
                }
            });
        }

        function selectedDays(appointment_date) {
            var selectedDate = new Date(appointment_date);
            var selectedDayIndex = selectedDate.getDay();
            var daysOfWeek = ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];

            var adjustedDaysOfWeek = daysOfWeek.slice(selectedDayIndex).concat(daysOfWeek.slice(0, selectedDayIndex));
            var daysHtml = '';
            adjustedDaysOfWeek.forEach(function(day) {
                daysHtml += `<th scope="col">${day}</th>`;
            });
            console.log(daysHtml);
            return daysHtml;
        }

        function schedulesApp2(data,appointment_date) {
            var selectedDate = new Date(appointment_date);
            var selectedDayIndex = selectedDate.getDay();
            var daysOfWeek = ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];

            var adjustedDaysOfWeek = daysOfWeek.slice(selectedDayIndex).concat(daysOfWeek.slice(0, selectedDayIndex));
            var daysHtml = '';
            var durationHtml = ``;
            adjustedDaysOfWeek.forEach(function(day) {
                daysHtml += `<th scope="col">${day}</th>`;

                const roomIndex = data.rooms.findIndex((sRoom)=> sRoom.day.toLowerCase() == day.toLowerCase());
                if(roomIndex == -1){
                    durationHtml = durationHtml+'<td></td>';
                    return;
                }
                const room = data.rooms[roomIndex];

                durationHtml = durationHtml+'<td>';
                var dayDate = room.day_date;
                for (let j = 0; j < room.available_time.length; j++) {
                    const singleTime = room.available_time[j];
                    var disabled = '';
                    console.log('booked_times', room.booked_times.includes(singleTime))
                    if (room.booked_times.includes(singleTime)) {
                        disabled = 'disabled';
                    }
                    durationHtml = durationHtml+`<div class="form-check">
                                        <input class="form-check-input" type="radio"
                                            name="appointment_time" ${disabled} data-daydate="${dayDate}"
                                            id="availableTime-${roomIndex}-${j}" value="${singleTime}">
                                        <label class="form-check-label"
                                            for="availableTime-${roomIndex}-${j}">
                                            ${singleTime}
                                        </label>
                                    </div>`;
                }
                durationHtml = durationHtml+'</td>';
            });
            console.log(daysHtml);


            roomsHtml = daysHtml

            var html = `
            <table class="table">
                <thead>
                    <tr>
                        ${roomsHtml}
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        ${durationHtml}
                    </tr>
                </tbody>
            </table>
            `
            $('.day-select').html(html);
        }


        $(document).on('click', '.remove-item', function() {
            var ele_id = $(this).data('id');
            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#0073b1',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        type: 'post',
                        dataType: 'json',
                        url: "<?php echo e(route('admin.memberAppointmentDelete')); ?>",
                        data: {
                            id: ele_id,
                            _token: '<?php echo e(csrf_token()); ?>'
                        },
                        success: function(response) {
                            if (response.status == 0) {
                                toastr.error(response.message);
                            } else {
                                toastr.success(response.message);
                                location.reload();
                            }
                        }
                    });
                    console.log("here");
                }
            })
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\Ahmed-Shoaib\laravel-projects\holistic-Laravel\resources\views/admin/pages/staff/memAppointmentListStaff.blade.php ENDPATH**/ ?>