<?php $__env->startSection('content'); ?>
    <div class="ms-content-wrapper">
        <div class="row">
            <!-- Notifications Widgets -->
            <?php if (\Illuminate\Support\Facades\Blade::check('admin')): ?>
            <div class="col-12 col-sm-12 col-md-6 col-lg-4 col-xl-4 col-xxl-4">
                <a href="#">
                    <div class="ms-card card-gradient-custom ms-widget ms-infographics-widget ms-p-relative">
                        <div class="ms-card-body media">
                            <div class="media-body">
                                <h6>Providers</h6>
                                <p class="ms-card-change"><?php echo e(providersCount()); ?></p>
                            </div>
                        </div>
                        <i class="fas fa-stethoscope ms-icon-mr"></i>
                    </div>
                </a>
            </div>
            <div class="col-12 col-sm-12 col-md-6 col-lg-4 col-xl-4 col-xxl-4">
                <a href="#">
                    <div class="ms-card card-gradient-custom ms-widget ms-infographics-widget ms-p-relative">
                        <div class="ms-card-body media">
                            <div class="media-body">
                                <h6>Staff</h6>
                                <p class="ms-card-change"><?php echo e(staffCount()); ?></p>
                            </div>
                        </div>
                        <i class="fas fa-user-plus ms-icon-mr"></i>
                    </div>
                </a>
            </div>
            <div class="col-12 col-sm-12 col-md-6 col-lg-4 col-xl-4 col-xxl-4">
                <a href="#">
                    <div class="ms-card card-gradient-custom ms-widget ms-infographics-widget ms-p-relative">
                        <div class="ms-card-body media">
                            <div class="media-body">
                                <h6 class="bold">Patients</h6>
                                <p class="ms-card-change"><?php echo e(patientCount()); ?></p>
                            </div>
                        </div>
                        <i class="fa fa-wheelchair ms-icon-mr"></i>
                    </div>
                </a>
            </div>
            <div class="col-xl-12 col-md-12">
                <div class="ms-panel">
                    <div class="ms-panel-header">
                        <h6>Upcoming Appointments</h6>
                    </div>
                    <div class="ms-panel-body">
                        <div class="table-responsive">
                            <table class="table table-hover thead-primary">
                                <thead>
                                    <tr>
                                        <th scope="col">Patient</th>
                                        <th scope="col">Doctor</th>
                                        <th scope="col">Date</th>
                                        <th scope="col">Timing</th>
                                        <th scope="col">Contact</th>
                                        
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $recentAppAdmin; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td class="ms-table-f-w">
                                                <img src="<?php echo e(asset($item->user->image ?? '' )); ?>"
                                                    alt="people"><?php echo e($item->user->name ?? ''); ?></td>
                                            <td><?php echo e($item->provider->name ?? ''); ?></td>
                                            <td><?php echo e($item->appointment_date ? \Carbon\Carbon::parse($item->appointment_date)->format('M d, Y') : ''); ?></td>
                                            <td><?php echo e($item->appointment_time ? \Carbon\Carbon::parse($item->appointment_time)->format('h:i A') : ''); ?></td>
                                            <td><?php echo e($item->user->phone ?? ''); ?></td>
                                            
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <?php endif; ?>

            <?php if (\Illuminate\Support\Facades\Blade::check('providers')): ?>
                <div class="col-xl-12 col-md-12">
                    <div class="ms-panel">
                        <div class="ms-panel-header">
                            <h6>Upcoming Appointments</h6>
                        </div>
                        <div class="ms-panel-body">
                            <div class="table-responsive">
                                <table class="table table-hover thead-primary">
                                    <thead>
                                        <tr>
                                            <th scope="col">Patient</th>
                                            <th scope="col">Date</th>
                                            <th scope="col">Timing</th>
                                            <th scope="col">Contact</th>
                                            
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $recentAppProviders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td class="ms-table-f-w">
                                                    <img src="<?php echo e(asset($item->user->image ?? '' )); ?>"
                                                        alt="people"><?php echo e($item->user->name ?? ''); ?>

                                                </td>
                                                <td><?php echo e($item->appointment_date ? \Carbon\Carbon::parse($item->appointment_date)->format('M d, Y') : ''); ?></td>
                                                <td><?php echo e($item->appointment_time ? \Carbon\Carbon::parse($item->appointment_time)->format('h:i A') : ''); ?></td>
                                                <td><?php echo e($item->user->phone ?? ''); ?></td>
                                                
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <?php if (\Illuminate\Support\Facades\Blade::check('patient')): ?>
                <div class="col-xl-12 col-md-12">
                    <div class="ms-panel">
                        <div class="ms-panel-header">
                            <h6>Upcoming Appointments</h6>
                        </div>
                        <div class="ms-panel-body">
                            <div class="table-responsive">
                                <table class="table table-hover thead-primary">
                                    <thead>
                                        <tr>
                                            <th scope="col">Doctor</th>
                                            <th scope="col">Date</th>
                                            <th scope="col">Timing</th>
                                            <th scope="col">Contact</th>
                                            
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $recentAppCustomer; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td class="ms-table-f-w">
                                                    <img src="<?php echo e(asset($item->provider->image ?? '' )); ?>"
                                                        alt="people"><?php echo e($item->provider->name ?? ''); ?>

                                                </td>
                                                <td><?php echo e($item->appointment_date ? \Carbon\Carbon::parse($item->appointment_date)->format('M d, Y') : ''); ?></td>
                                                <td><?php echo e($item->appointment_time ? \Carbon\Carbon::parse($item->appointment_time)->format('h:i A') : ''); ?></td>
                                                <td><?php echo e($item->user->phone ?? ''); ?></td>
                                                
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            
            
            
            
            

            
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\Ahmed-Shoaib\laravel-projects\holistic-Laravel\resources\views/admin/index.blade.php ENDPATH**/ ?>