<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e(isset($title) ? $title : 'Sign In'); ?></title>
    <link rel="icon" href="<?php echo e(asset('assets/admin/images/fav-icon.png')); ?>" type="image/png" sizes="">
    <link href="https://site-assets.fontawesome.com/releases/v6.0.0/css/all.css" rel="stylesheet">
    <link href="<?php echo e(asset('assets/admin/vendors/iconic-fonts/font-awesome/css/all.min.css')); ?>" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(asset('assets/admin/vendors/iconic-fonts/flat-icons/flaticon.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/admin/vendors/iconic-fonts/cryptocoins/cryptocoins.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/admin/vendors/iconic-fonts/cryptocoins/cryptocoins-colors.css')); ?>">
    <link href="<?php echo e(asset('assets/admin/css/bootstrap.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/admin/css/jquery-ui.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/admin/css/style.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/admin/css/morris.css')); ?>" rel="stylesheet">
</head>

<body>
    <div class="ms-content-wrapper ms-auth">
        <div class="ms-auth-container">
            <div class="ms-auth-col">
                <div class="ms-auth-bg"></div>
            </div>
            <div class="ms-auth-col">
                <div class="ms-auth-form">
                    <form class="needs-validation" method="POST" action="<?php echo e(route('login')); ?>" novalidate="">
                        <?php echo csrf_field(); ?>
                        <h1>Sign in your account</h1>
                        <p>Please enter your email and password to continue</p>
                        <div class="mb-3">
                            <label for="validationCustom01"><?php echo e(__('Email Address')); ?></label>
                            <div class="input-group">
                                <input id="email" type="email"
                                    class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="email"
                                    value="<?php echo e(old('email')); ?>" required autocomplete="email" autofocus
                                    id="validationCustom01">
                                <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback" role="alert">
                                        <?php echo e($message); ?>

                                    </div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class="mb-2">
                            <label for="validationCustom02"><?php echo e(__('Password')); ?></label>
                            <div class="input-group">
                                <input id="password" type="password"
                                    class="form-control <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="password"
                                    required autocomplete="current-password" id="validationCustom02">

                                <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback" role="alert">
                                        <?php echo e($message); ?>

                                    </div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="ms-checkbox-wrap">
                                <input class="form-check-input" type="checkbox" name="remember" id="remember"
                                    <?php echo e(old('remember') ? 'checked' : ''); ?>>
                                <i class="ms-checkbox-check"></i>
                            </label>
                            <span><?php echo e(__('Remember Me')); ?></span>
                        </div>
                        <button class="btn btn-primary mt-4 d-block w-100" type="submit">Sign In</button>
                        <div class="form-group">
                            <label class="d-block mt-3">
                                <?php if(Route::has('password.request')): ?>
                                    <a class="btn-link" href="<?php echo e(route('password.request')); ?>">
                                        <?php echo e(__('Forgot Your Password?')); ?>

                                    </a>
                                <?php endif; ?>
                            </label>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</body>

<script src="<?php echo e(asset('assets/admin/js/jquery-3.3.1.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/admin/js/popper.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/admin/js/bootstrap.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/admin/js/jquery-ui.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/admin/js/framework.js')); ?>"></script>
<script src="<?php echo e(asset('assets/admin/js/settings.js')); ?>"></script>

</html>
<?php /**PATH D:\xampp\htdocs\Ahmed-Shoaib\laravel-projects\holistic-Laravel\resources\views/auth/login.blade.php ENDPATH**/ ?>