<?php $__env->startSection('content'); ?>
    <div class="ms-content-wrapper">
        <div class="row">
            <div class="col-md-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb pl-0">
                        <li class="breadcrumb-item"><a href="javascript:;"><i class="material-icons">home</i> Home</a></li>
                        <li class="breadcrumb-item"><a href="javascript:;">Room</a></li>
                    </ol>
                </nav>
            </div>
            <div class="col-xl-12 col-md-12">
                <div class="ms-panel">
                    <div class="ms-panel-header ms-panel-custome">
                        <h6>Add Room</h6>
                        <a href="<?php echo e(route('admin.roomsView')); ?>" class="ms-text-primary">Room List </a>
                    </div>
                    <div class="ms-panel-body">
                        <form class="needs-validation" action="<?php echo e(route('admin.roomsUpdate')); ?>" method="POST" novalidate>
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="room_id" value="<?php echo e($room->id ?? ''); ?>">
                            <div class="form-row">
                                <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12 mb-3">
                                    <label for="validationCustom001">Day</label>
                                    <div class="input-group">
                                        <select class="form-control" name="day" required>
                                            <option selected disabled>Select Day</option>
                                            <?php
                                                $daysOfWeek = [
                                                    'Monday',
                                                    'Tuesday',
                                                    'Wednesday',
                                                    'Thursday',
                                                    'Friday',
                                                    'Saturday',
                                                    'Sunday',
                                                ];
                                            ?>
                                            <?php $__currentLoopData = $daysOfWeek; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $day): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($day); ?>"
                                                    <?php echo e(isset($room) && $room->day == $day ? 'selected' : ''); ?>><?php echo e($day); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12 mb-3">
                                    <label for="validationCustom002">Start time</label>
                                    <div class="input-group">
                                        <input type="time" class="form-control" name="start_time"
                                            value="<?php echo e($room->start_time ?? ''); ?>" id="validationCustom002"
                                            placeholder="Start time" required>
                                    </div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12 mb-3">
                                    <label for="validationCustom003">End time</label>
                                    <div class="input-group">
                                        <input type="time" class="form-control" name="end_time"
                                            value="<?php echo e($room->end_time ?? ''); ?>" id="validationCustom003"
                                            placeholder="End time" required>
                                    </div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12 mb-3">
                                    <label for="validationCustom003">Duration</label>
                                    <div class="input-group">
                                        <input type="number" class="form-control" min="5" max="60" step="5" name="duration"
                                            value="<?php echo e($room->duration ?? ''); ?>" id="validationCustom003"
                                            placeholder="Duration" required>
                                    </div>
                                </div>
                            </div>
                            <button class="btn btn-primary mt-4 d-inline w-20" type="submit">save/update</button>
                        </form>

                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        <?php if(Session::has('validationerror')): ?>
            <?php $__currentLoopData = Session::get('validationerror'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                toastr.options = {
                    "closeButton": true,
                    "progressBar": true,
                    "debug": false,
                    "positionClass": "toast-bottom-right",
                }
                toastr.error("<?php echo e($error); ?>");
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/holisticim/public_html/resources/views/admin/pages/providers/room/roomCreate.blade.php ENDPATH**/ ?>