@extends('web.layouts.master')
@section('content')
    <section class="section1-services" style="background-image: url({{ asset($services_banner_image->value ?? '') }})">
        <div class="container-fluid">
            <h1 class="display-2 text-center sec-services-heading sec-heading">{!! $services_banner_title->value ?? '' !!}</h1>
            <p class="text-center services-parah">
                <a href="{{ route('web.home') }}" class="services-parah">HOME &nbsp</a>
                /
                <a href="{{ route('web.Services') }}" class="services-parah">&nbsp SERVICES</a>
            </p>
        </div>
    </section>

    <section class="services-text my-5">
        {!! $services_content->value ?? '' !!}
    </section>

    <section class=" mb-5">
        <div class="container services">
            <div class="row my-5">
                @foreach ($service as $item)
                    <div class="col-12 col-sm-12 col-xl-4 col-lg-4 col-md-4">
                        <div class="card">
                            <img src="{{ asset($item->image ?? '') }}" class="card-img-top" alt="...">
                            <div class="card-body">
                                <h5 class="card-title">{{ $item->title ?? '' }}</h5>
                                <p class="card-text">{!! $item->short_desc ?? '' !!}</p>
                                <a href="{{ route('web.ServicesDetail', $item->slug ?? '') }}" class="btn services-btn">See
                                    Details</a>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </section>
@endsection
