@extends('web.layouts.master')
@section('content')
    <!-- Banner Section Start -->
    <div class="banner-sec">
        <div class="" data-aos="fade-right" data-aos-duration="1000">
            <h1 class="sec-heading fw-bold">Packages</h1>
        </div>
    </div>
    <!-- Banner Section Ends -->
    <section class="packages-sec-wrap">
        <div class="container">
            <div class="row justify-content-center">
                @foreach ($packages as $item)
                    <div class="col-12 col-sm-12 col-md-6 col-lg-4 col-xl-4 col-xxl-4">
                        <div class="package-card">
                            <div class="top">
                                <h2>{{ $item->title }}</h2>
                                <p><span>$</span>{{ $item->price }}</p>
                            </div>
                            <div class="bottom">
                                {!! $item->desc !!}
                                <div class="btn-box">
                                    <a href="{{ route('web.PackagesPurchase', $item->id) }}" class="btn btn-wh">Buy now</a>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </section>
@endsection
