@extends('web.layouts.master')
@section('content')
    <section class="section1-services">
        <div class="container-fluid">
            <h1 class="display-2 text-center sec-services-heading sec-heading">Free Consulting</h1>
            <p class="text-center services-parah"><a href="{{ route('web.home') }}" class="services-parah">Home &nbsp</a>/<a
                    href="{{ route('web.Consulting') }}" class="services-parah">&nbsp Free Consulting</a></p>
        </div>
    </section>


    <div class="consulting">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="txt-block pr-30">
                        <h3 class="h3-md steelblue-color">Book an Appointment</h3>
                        <p>
                            If you have any questions, please do not hesitate to contact us immediately. We will be happy to
                            answer all your questions and schedule a free consultation with you. Please leave your name,
                            phone number, and email, and the time and date you want us to contact with you. We will contact
                            you as soon as possible.
                        </p>
                        <div id="appointment-form-holder" class="text-center">
                            <form class="row appointment-form" action="{{ route('web.Appointment') }}" method="POST"
                                novalidate="novalidate">
                                @csrf

                                @if ($errors->any())
                                    <div class="alert alert-danger">
                                        <ul>
                                            @foreach ($errors->all() as $error)
                                                <li>{{ $error }}</li>
                                            @endforeach
                                        </ul>
                                    </div>
                                @endif
                                <div id="input-date" class="col-lg-12 form-group">
                                    <input id="datetimepicker" type="text" name="social_security_number"
                                        class="form-control" placeholder="enter your social security numbers (SSNs)*"
                                        required>
                                    <span class="invalid-feedback" role="alert">
                                        <strong>
                                            @error('social_security_number')
                                                {{ $message }}
                                            @enderror
                                        </strong>
                                    </span>
                                </div>
                                <div id="input-name" class="col-lg-12 form-group">
                                    <input type="text" name="name" class="form-control name"
                                        placeholder="enter your name*" required>
                                    <span class="invalid-feedback" role="alert">
                                        <strong>
                                            @error('name')
                                                {{ $message }}
                                            @enderror
                                        </strong>
                                    </span>
                                </div>

                                <div id="input-phone" class="col-lg-12 form-group">
                                    <input type="text" name="phone_number" class="form-control"
                                        placeholder="enter your phone number*" required>
                                    <span class="invalid-feedback" role="alert">
                                        <strong>
                                            @error('phone_number')
                                                {{ $message }}
                                            @enderror
                                        </strong>
                                    </span>
                                </div>

                                {{-- <div id="input-email" class="col-lg-12">
                                    <input type="email" name="email" class="form-control email"
                                        placeholder="Enter Your Email*" required="">
                                </div>
                                <div id="input-message" class="col-lg-12 input-message">
                                    <textarea class="form-control message" name="message" rows="6" placeholder="Your Message ..."></textarea>
                                </div> --}}

                                <div class="col-lg-12 form-btn">
                                    <button type="submit" class="btn btn-blue blue-hover submit appointment-submit">
                                        Request an Appointment</button>
                                </div>

                                <div class="col-lg-12 appointment-form-msg text-center">
                                    <div class="sending-msg"><span class="loading"></span></div>
                                </div>
                            </form>
                        </div>
                        <p class="p-sm grey-color mb-30">* is a required field.</p>
                    </div>
                </div>

            </div>
        </div>
    </div>
@endsection
@section('scripts')
    <script>
        $(document).on('click', '.appointment-submit', function(event) {
            event.preventDefault();

            var has_error = false;
            var form = $(this).closest('.appointment-form');

            form.find(".is-invalid").removeClass('is-invalid');

            form.find("select, textarea, input").each(function() {
                if ($(this).prop("required")) {
                    if ($(this).val() == "") {
                        has_error = true;
                        $(this).addClass('is-invalid');

                        var fieldName = $(this).attr('placeholder') || $(this).attr('name');
                        fieldName = fieldName.replace('*', '');
                        form.find('input[name="' + $(this).attr('name') + '"]').siblings(
                            '.invalid-feedback').find('strong').text("Please " + fieldName);
                    }
                }
            });

            if (!has_error) {
                form.submit();
            } else {
                toastr.options = {
                    "closeButton": true,
                    "progressBar": true,
                    "debug": false,
                    "positionClass": "toast-bottom-right",
                };
                toastr.error("Fill All Required Fields");
            }
        });
    </script>
@endsection
