<?php $logo_dark = DB::table('logo')->where('slug', 'logo_dark')->where('tag', 'logo_fav')->first(); ?>
<?php $service = DB::table('services')->where('is_active', 1)->where('is_deleted', 0)->get(); ?>

<header class="main-header">
    <div class="h-one">
        <div class="container d-flex justify-content-between">
            <div class="header-top">
                <div class="header-text">
                    <p> <span>🏠</span> Call us today, to receive FREE Immunity boosting teabag</p>
                </div>
                <div class="header-icon">
                    <i class="fa-brands fa-facebook-f icons"></i>
                    <i class="fa-brands fa-twitter icons"></i>
                    <i class="fa-brands fa-pinterest icons"></i>
                    <i class="fa-brands fa-linkedin-in icons"></i>
                    <i class="fa-brands fa-telegram icons"></i>
                </div>
            </div>
        </div>
        <div class="h-two">
            <div class="container">
                <nav class="navbar navbar-expand-lg">
                    <a class="navbar-brand" href="{{ route('web.home') }}">
                        <img src="{{ asset($logo_dark->value ?? '') }}" alt="logo" class="img-fluid logo">
                    </a>
                    <button class="navbar-toggler" type="button" data-bs-toggle="collapse"
                        data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent"
                        aria-expanded="false" aria-label="Toggle navigation">
                        <span class="navbar-toggler-icon"></span>
                    </button>
                    <div class="collapse navbar-collapse" id="navbarSupportedContent">
                        <ul class="navbar-nav">
                            <li class="nav-item">
                                <a class="nav-link active" aria-current="page" href="{{ route('web.home') }}">HOME</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="{{ route('web.Aboutus') }}">ABOUT US</a>
                            </li>

                            <li class="nav-item">
                                <a class="nav-link" href="{{ route('web.Providers') }}">Providers</a>
                            </li>

                            <li class="nav-item">
                                <a class="nav-link" href="{{ route('web.Pricing') }}">Pricing</a>
                            </li>

                            <li class="nav-item dropdown">
                                <a class="nav-link dropdown-toggle" href="{{ route('web.Services') }}"
                                    id="navbarDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                                    SERVICES
                                </a>
                                <ul class="dropdown-menu" aria-labelledby="navbarDropdown">
                                    <li><a class="dropdown-item" href="{{ route('web.Services') }}">Our Service</a></li>
                                    @foreach ($service as $item)
                                        <li>
                                            <a class="dropdown-item" href="{{ route('web.ServicesDetail', $item->slug ?? '') }}">{{ $item->title ?? ''}}</a>
                                        </li>
                                    @endforeach
                                </ul>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="{{ route('web.Contact') }}">CONTACT US</a>
                            </li>
                        </ul>
                        <div class="navbar-buttons">
                            @if (Auth::user())
                                <a class="popup-btn" href="{{ route('admin.home') }}" target="_blank">Dashboard</a>
                                <a href="{{ route('logout') }}" class="popup-btn">Logout</a>
                            @else
                                <a href="{{route('web.Login')}}" class="popup-btn">Sign up/log in</a>
                                <a href="{{ route('web.Consulting') }}" class="popup-btn">Make appointment</a>
                            @endif
                        </div>
                    </div>
                </nav>
            </div>
        </div>
    </div>
</header>
