@extends('admin.layouts.master')
@section('content')
    <div class="ms-content-wrapper">
        <div class="row">
            <div class="col-md-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb pl-0">
                        <li class="breadcrumb-item"><a href="javascript:;"><i class="material-icons">home</i> Home</a></li>
                        <li class="breadcrumb-item"><a href="javascript:;">{{ $title }}</a></li>
                    </ol>
                </nav>
            </div>
            <div class="col-xl-12 col-md-12">
                <div class="ms-panel">
                    <div class="ms-panel-body main-cms-body">
                        <form class="needs-validation" action="{{ route('cms.update') }}" method="POST"
                            enctype="multipart/form-data">
                            @csrf

                            <div class="row">
                                <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                                    <h2 class="title-head">Banner</h2>
                                </div>
                            </div>
                            <div class="cms-box">
                                <div class="form-row">
                                    <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                                        <div class="avatar-upload">
                                            <div class="avatar-edit">
                                                <input type='file' type="file" name="{{ $providers_banner_image->slug ?? '' }}"
                                                    id="{{ $providers_banner_image->id ?? '' }}" class="change-img"
                                                    accept=".png, .jpg, .jpeg, .webp" />
                                                <label for="{{ $providers_banner_image->id ?? '' }}"></label>
                                            </div>
                                            <div class="avatar-preview">
                                                <div class="imagePreview">
                                                    <img src="{{ asset($providers_banner_image->value ?? 'assets/web/images/user.jpg') }}"
                                                        alt="img" class="img-fluid">
                                                </div>
                                            </div>
                                            <h5>{{ $providers_banner_image->name ?? '' }}</h5>
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                                        <div class="form-group">
                                            <label for="{{ $providers_banner_title->id ?? '' }}">
                                                {{ $providers_banner_title->name ?? '' }}
                                            </label>
                                            <div class="input-group">
                                                <input type="text" class="form-control"
                                                    name="{{ $providers_banner_title->slug ?? '' }}"
                                                    value="{{ $providers_banner_title->value ?? '' }}"
                                                    id="{{ $providers_banner_title->id ?? '' }}"
                                                    placeholder="{{ $providers_banner_title->name ?? '' }}" required>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                                    <h2 class="title-head">Section 1</h2>
                                </div>
                            </div>
                            <div class="cms-box">
                                <div class="form-row">
                                    <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                                        <div class="avatar-upload">
                                            <div class="avatar-edit">
                                                <input type='file' type="file" name="{{ $providers_sec1_image->slug ?? '' }}"
                                                    id="{{ $providers_sec1_image->id ?? '' }}" class="change-img"
                                                    accept=".png, .jpg, .jpeg, .webp" />
                                                <label for="{{ $providers_sec1_image->id ?? '' }}"></label>
                                            </div>
                                            <div class="avatar-preview">
                                                <div class="imagePreview">
                                                    <img src="{{ asset($providers_sec1_image->value ?? 'assets/web/images/user.jpg') }}"
                                                        alt="img" class="img-fluid">
                                                </div>
                                            </div>
                                            <h5>{{ $providers_sec1_image->name ?? '' }}</h5>
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                                        <div class="form-group">
                                            <label for="{{ $providers_sec1_content->id ?? '' }}">
                                                {{ $providers_sec1_content->name ?? '' }}
                                            </label>
                                            <div class="form-group">
                                                <textarea class="form-control tinyEditor" id="{{ $providers_sec1_content->id ?? '' }}"
                                                    name="{{ $providers_sec1_content->slug ?? '' }}" rows="3">
                                                    {{ $providers_sec1_content->value ?? '' }}
                                                </textarea>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                                    <h2 class="title-head">Section 2</h2>
                                </div>
                            </div>
                            <div class="cms-box">
                                <div class="form-row">
                                    <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                                        <div class="avatar-upload">
                                            <div class="avatar-edit">
                                                <input type='file' type="file" name="{{ $providers_sec2_image->slug ?? '' }}"
                                                    id="{{ $providers_sec2_image->id ?? '' }}" class="change-img"
                                                    accept=".png, .jpg, .jpeg, .webp" />
                                                <label for="{{ $providers_sec2_image->id ?? '' }}"></label>
                                            </div>
                                            <div class="avatar-preview">
                                                <div class="imagePreview">
                                                    <img src="{{ asset($providers_sec2_image->value ?? 'assets/web/images/user.jpg') }}"
                                                        alt="img" class="img-fluid">
                                                </div>
                                            </div>
                                            <h5>{{ $providers_sec2_image->name ?? '' }}</h5>
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                                        <div class="form-group">
                                            <label for="{{ $providers_sec2_content->id ?? '' }}">
                                                {{ $providers_sec2_content->name ?? '' }}
                                            </label>
                                            <div class="form-group">
                                                <textarea class="form-control tinyEditor" id="{{ $providers_sec2_content->id ?? '' }}"
                                                    name="{{ $providers_sec2_content->slug ?? '' }}" rows="3">
                                                    {{ $providers_sec2_content->value ?? '' }}
                                                </textarea>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                                    <button class="btn btn-primary mt-4 d-inline w-20" type="submit">save/update</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
