@extends('admin.layouts.master')
@section('content')
    <div class="ms-content-wrapper">
        <div class="row">
            <div class="col-md-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb pl-0">
                        <li class="breadcrumb-item"><a href="javascript:;"><i class="material-icons">home</i> Home</a></li>
                        <li class="breadcrumb-item"><a href="javascript:;">{{ $title }}</a></li>
                    </ol>
                </nav>
            </div>
            <div class="col-xl-12 col-md-12">
                <div class="ms-panel">
                    <div class="ms-panel-body main-cms-body">
                        <form class="needs-validation" action="{{ route('cms.update') }}" method="POST"
                            enctype="multipart/form-data">
                            @csrf

                            <div class="row">
                                <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                                    <h2 class="title-head">Banner</h2>
                                </div>
                            </div>
                            <div class="cms-box">
                                <div class="form-row">
                                    <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                                        <div class="avatar-upload">
                                            <div class="avatar-edit">
                                                <input type='file' type="file" name="{{ $pricing_banner_image->slug ?? '' }}"
                                                    id="{{ $pricing_banner_image->id ?? '' }}" class="change-img"
                                                    accept=".png, .jpg, .jpeg, .webp" />
                                                <label for="{{ $pricing_banner_image->id ?? '' }}"></label>
                                            </div>
                                            <div class="avatar-preview">
                                                <div class="imagePreview">
                                                    <img src="{{ asset($pricing_banner_image->value ?? 'assets/web/images/user.jpg') }}"
                                                        alt="img" class="img-fluid">
                                                </div>
                                            </div>
                                            <h5>{{ $pricing_banner_image->name ?? '' }}</h5>
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                                        <div class="form-group">
                                            <label for="{{ $pricing_banner_title->id ?? '' }}">
                                                {{ $pricing_banner_title->name ?? '' }}
                                            </label>
                                            <div class="input-group">
                                                <input type="text" class="form-control"
                                                    name="{{ $pricing_banner_title->slug ?? '' }}"
                                                    value="{{ $pricing_banner_title->value ?? '' }}"
                                                    id="{{ $pricing_banner_title->id ?? '' }}"
                                                    placeholder="{{ $pricing_banner_title->name ?? '' }}" required>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                                    <h2 class="title-head">Pricing content</h2>
                                </div>
                            </div>
                            <div class="cms-box">
                                <div class="form-row">
                                    <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                                        <div class="form-group">
                                            <label for="{{ $pricing_content->id ?? '' }}">
                                                {{ $pricing_content->name ?? '' }}
                                            </label>
                                            <div class="form-group">
                                                <textarea class="form-control tinyEditor" id="{{ $pricing_content->id ?? '' }}"
                                                    name="{{ $pricing_content->slug ?? '' }}" rows="3">
                                                    {{ $pricing_content->value ?? '' }}
                                                </textarea>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                                    <button class="btn btn-primary mt-4 d-inline w-20" type="submit">save/update</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
