@extends('admin.layouts.master')
@section('content')
    <div class="ms-content-wrapper">
        <div class="row">
            <div class="col-md-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb pl-0">
                        <li class="breadcrumb-item"><a href="javascript:;"><i class="material-icons">home</i> Home</a></li>
                        <li class="breadcrumb-item"><a href="javascript:;">{{ $title }}</a></li>
                    </ol>
                </nav>
            </div>
            <div class="col-xl-12 col-md-12">
                <div class="ms-panel">
                    <div class="ms-panel-body main-cms-body">
                        <form class="needs-validation" action="{{ route('cms.update') }}" method="POST"
                            enctype="multipart/form-data">
                            @csrf

                            <div class="row">
                                <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                                    <h2 class="title-head">Banner</h2>
                                </div>
                            </div>
                            <div class="cms-box">
                                <div class="form-row">
                                    <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                                        <div class="avatar-upload">
                                            <div class="avatar-edit">
                                                <input type='file' type="file" name="{{ $home_banner_img->slug ?? '' }}"
                                                    id="{{ $home_banner_img->id ?? '' }}" class="change-img"
                                                    accept=".png, .jpg, .jpeg, .webp" />
                                                <label for="{{ $home_banner_img->id ?? '' }}"></label>
                                            </div>
                                            <div class="avatar-preview">
                                                <div class="imagePreview">
                                                    <img src="{{ asset($home_banner_img->value ?? 'assets/web/images/user.jpg') }}"
                                                        alt="img" class="img-fluid">
                                                </div>
                                            </div>
                                            <h5>{{ $home_banner_img->name ?? '' }}</h5>
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                                        <div class="form-group">
                                            <label for="{{ $home_banner_title->id ?? '' }}">
                                                {{ $home_banner_title->name ?? '' }}
                                            </label>
                                            <div class="input-group">
                                                <input type="text" class="form-control"
                                                    name="{{ $home_banner_title->slug ?? '' }}"
                                                    value="{{ $home_banner_title->value ?? '' }}"
                                                    id="{{ $home_banner_title->id ?? '' }}"
                                                    placeholder="{{ $home_banner_title->name ?? '' }}" required>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                                        <div class="form-group">
                                            <label for="{{ $home_banner_desc->id ?? '' }}">
                                                {{ $home_banner_desc->name ?? '' }}
                                            </label>
                                            <div class="form-group">
                                                <textarea class="form-control tinyEditor" id="{{ $home_banner_desc->id ?? '' }}"
                                                    name="{{ $home_banner_desc->slug ?? '' }}" rows="3">
                                                    {{ $home_banner_desc->value ?? '' }}
                                                </textarea>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                                    <h2 class="title-head">Section 1</h2>
                                </div>
                            </div>
                            <div class="cms-box">
                                <div class="form-row">
                                    <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                                        <div class="avatar-upload">
                                            <div class="avatar-edit">
                                                <input type='file' type="file" name="{{ $home_sec1_image->slug ?? '' }}"
                                                    id="{{ $home_sec1_image->id ?? '' }}" class="change-img"
                                                    accept=".png, .jpg, .jpeg, .webp" />
                                                <label for="{{ $home_sec1_image->id ?? '' }}"></label>
                                            </div>
                                            <div class="avatar-preview">
                                                <div class="imagePreview">
                                                    <img src="{{ asset($home_sec1_image->value ?? 'assets/web/images/user.jpg') }}"
                                                        alt="img" class="img-fluid">
                                                </div>
                                            </div>
                                            <h5>{{ $home_sec1_image->name ?? '' }}</h5>
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                                        <div class="form-group">
                                            <label for="{{ $home_sec1_content->id ?? '' }}">
                                                {{ $home_sec1_content->name ?? '' }}
                                            </label>
                                            <div class="form-group">
                                                <textarea class="form-control tinyEditor" id="{{ $home_sec1_content->id ?? '' }}"
                                                    name="{{ $home_sec1_content->slug ?? '' }}" rows="3">
                                                    {{ $home_sec1_content->value ?? '' }}
                                                </textarea>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                                    <h2 class="title-head">Section 2</h2>
                                </div>
                            </div>
                            <div class="cms-box">
                                <div class="form-row">
                                    <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                                        <div class="avatar-upload">
                                            <div class="avatar-edit">
                                                <input type='file' type="file" name="{{ $home_sec2_image->slug ?? '' }}"
                                                    id="{{ $home_sec2_image->id ?? '' }}" class="change-img"
                                                    accept=".png, .jpg, .jpeg, .webp" />
                                                <label for="{{ $home_sec2_image->id ?? '' }}"></label>
                                            </div>
                                            <div class="avatar-preview">
                                                <div class="imagePreview">
                                                    <img src="{{ asset($home_sec2_image->value ?? 'assets/web/images/user.jpg') }}"
                                                        alt="img" class="img-fluid">
                                                </div>
                                            </div>
                                            <h5>{{ $home_sec2_image->name ?? '' }}</h5>
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                                        <div class="form-group">
                                            <label for="{{ $home_sec2_content->id ?? '' }}">
                                                {{ $home_sec2_content->name ?? '' }}
                                            </label>
                                            <div class="form-group">
                                                <textarea class="form-control tinyEditor" id="{{ $home_sec2_content->id ?? '' }}"
                                                    name="{{ $home_sec2_content->slug ?? '' }}" rows="3">
                                                    {{ $home_sec2_content->value ?? '' }}
                                                </textarea>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-12 col-md-4 col-lg-4 col-xl-4 col-xxl-4">
                                        <div class="form-group">
                                            <label for="{{ $home_sec2_progress1->id ?? '' }}">
                                                {{ $home_sec2_progress1->name ?? '' }}
                                            </label>
                                            <div class="input-group">
                                                <input type="text" class="form-control"
                                                    name="{{ $home_sec2_progress1->slug ?? '' }}"
                                                    value="{{ $home_sec2_progress1->value ?? '' }}"
                                                    id="{{ $home_sec2_progress1->id ?? '' }}"
                                                    placeholder="{{ $home_sec2_progress1->name ?? '' }}" required>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-12 col-md-4 col-lg-4 col-xl-4 col-xxl-4">
                                        <div class="form-group">
                                            <label for="{{ $home_sec2_progress2->id ?? '' }}">
                                                {{ $home_sec2_progress2->name ?? '' }}
                                            </label>
                                            <div class="input-group">
                                                <input type="text" class="form-control"
                                                    name="{{ $home_sec2_progress2->slug ?? '' }}"
                                                    value="{{ $home_sec2_progress2->value ?? '' }}"
                                                    id="{{ $home_sec2_progress2->id ?? '' }}"
                                                    placeholder="{{ $home_sec2_progress2->name ?? '' }}" required>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-12 col-md-4 col-lg-4 col-xl-4 col-xxl-4">
                                        <div class="form-group">
                                            <label for="{{ $home_sec2_progress3->id ?? '' }}">
                                                {{ $home_sec2_progress3->name ?? '' }}
                                            </label>
                                            <div class="input-group">
                                                <input type="text" class="form-control"
                                                    name="{{ $home_sec2_progress3->slug ?? '' }}"
                                                    value="{{ $home_sec2_progress3->value ?? '' }}"
                                                    id="{{ $home_sec2_progress3->id ?? '' }}"
                                                    placeholder="{{ $home_sec2_progress3->name ?? '' }}" required>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                                    <h2 class="title-head">Section 3</h2>
                                </div>
                            </div>
                            <div class="cms-box">
                                <div class="form-row">
                                    <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                                        <div class="avatar-upload">
                                            <div class="avatar-edit">
                                                <input type='file' type="file" name="{{ $home_sec3_image->slug ?? '' }}"
                                                    id="{{ $home_sec3_image->id ?? '' }}" class="change-img"
                                                    accept=".png, .jpg, .jpeg, .webp" />
                                                <label for="{{ $home_sec3_image->id ?? '' }}"></label>
                                            </div>
                                            <div class="avatar-preview">
                                                <div class="imagePreview">
                                                    <img src="{{ asset($home_sec3_image->value ?? 'assets/web/images/user.jpg') }}"
                                                        alt="img" class="img-fluid">
                                                </div>
                                            </div>
                                            <h5>{{ $home_sec3_image->name ?? '' }}</h5>
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                                        <div class="form-group">
                                            <label for="{{ $home_sec3_content->id ?? '' }}">
                                                {{ $home_sec3_content->name ?? '' }}
                                            </label>
                                            <div class="form-group">
                                                <textarea class="form-control tinyEditor" id="{{ $home_sec3_content->id ?? '' }}"
                                                    name="{{ $home_sec3_content->slug ?? '' }}" rows="3">
                                                    {{ $home_sec3_content->value ?? '' }}
                                                </textarea>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                                    <h2 class="title-head">Section 4</h2>
                                </div>
                            </div>
                            <div class="cms-box">
                                <div class="form-row">
                                    <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                                        <div class="avatar-upload">
                                            <div class="avatar-edit">
                                                <input type='file' type="file" name="{{ $home_sec4_image->slug ?? '' }}"
                                                    id="{{ $home_sec4_image->id ?? '' }}" class="change-img"
                                                    accept=".png, .jpg, .jpeg, .webp" />
                                                <label for="{{ $home_sec4_image->id ?? '' }}"></label>
                                            </div>
                                            <div class="avatar-preview">
                                                <div class="imagePreview">
                                                    <img src="{{ asset($home_sec4_image->value ?? 'assets/web/images/user.jpg') }}"
                                                        alt="img" class="img-fluid">
                                                </div>
                                            </div>
                                            <h5>{{ $home_sec4_image->name ?? '' }}</h5>
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                                        <div class="form-group">
                                            <label for="{{ $home_sec4_content->id ?? '' }}">
                                                {{ $home_sec4_content->name ?? '' }}
                                            </label>
                                            <div class="form-group">
                                                <textarea class="form-control tinyEditor" id="{{ $home_sec4_content->id ?? '' }}"
                                                    name="{{ $home_sec4_content->slug ?? '' }}" rows="3">
                                                    {{ $home_sec4_content->value ?? '' }}
                                                </textarea>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-row align-items-center">
                                    <div class="col-12 col-sm-12 col-md-4 col-lg-3 col-xl-3 col-xxl-3">
                                        <div class="avatar-upload">
                                            <div class="avatar-edit">
                                                <input type='file' type="file" name="{{ $home_sec4_box1_image->slug ?? '' }}"
                                                    id="{{ $home_sec4_box1_image->id ?? '' }}" class="change-img"
                                                    accept=".png, .jpg, .jpeg, .webp" />
                                                <label for="{{ $home_sec4_box1_image->id ?? '' }}"></label>
                                            </div>
                                            <div class="avatar-preview">
                                                <div class="imagePreview">
                                                    <img src="{{ asset($home_sec4_box1_image->value ?? 'assets/web/images/user.jpg') }}"
                                                        alt="img" class="img-fluid">
                                                </div>
                                            </div>
                                            <h5>{{ $home_sec4_box1_image->name ?? '' }}</h5>
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-12 col-md-4 col-lg-4 col-xl-4 col-xxl-4">
                                        <div class="form-group">
                                            <label for="{{ $home_sec4_box1_title->id ?? '' }}">
                                                {{ $home_sec4_box1_title->name ?? '' }}
                                            </label>
                                            <div class="input-group">
                                                <input type="text" class="form-control"
                                                    name="{{ $home_sec4_box1_title->slug ?? '' }}"
                                                    value="{{ $home_sec4_box1_title->value ?? '' }}"
                                                    id="{{ $home_sec4_box1_title->id ?? '' }}"
                                                    placeholder="{{ $home_sec4_box1_title->name ?? '' }}" required>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-12 col-md-4 col-lg-5 col-xl-5 col-xxl-5">
                                        <div class="form-group">
                                            <label for="{{ $home_sec4_box1_description->id ?? '' }}">
                                                {{ $home_sec4_box1_description->name ?? '' }}
                                            </label>
                                            <div class="input-group">
                                                <input type="text" class="form-control"
                                                    name="{{ $home_sec4_box1_description->slug ?? '' }}"
                                                    value="{{ $home_sec4_box1_description->value ?? '' }}"
                                                    id="{{ $home_sec4_box1_description->id ?? '' }}"
                                                    placeholder="{{ $home_sec4_box1_description->name ?? '' }}" required>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-row align-items-center">
                                    <div class="col-12 col-sm-12 col-md-4 col-lg-3 col-xl-3 col-xxl-3">
                                        <div class="avatar-upload">
                                            <div class="avatar-edit">
                                                <input type='file' type="file" name="{{ $home_sec4_box2_image->slug ?? '' }}"
                                                    id="{{ $home_sec4_box2_image->id ?? '' }}" class="change-img"
                                                    accept=".png, .jpg, .jpeg, .webp" />
                                                <label for="{{ $home_sec4_box2_image->id ?? '' }}"></label>
                                            </div>
                                            <div class="avatar-preview">
                                                <div class="imagePreview">
                                                    <img src="{{ asset($home_sec4_box2_image->value ?? 'assets/web/images/user.jpg') }}"
                                                        alt="img" class="img-fluid">
                                                </div>
                                            </div>
                                            <h5>{{ $home_sec4_box2_image->name ?? '' }}</h5>
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-12 col-md-4 col-lg-4 col-xl-4 col-xxl-4">
                                        <div class="form-group">
                                            <label for="{{ $home_sec4_box2_title->id ?? '' }}">
                                                {{ $home_sec4_box2_title->name ?? '' }}
                                            </label>
                                            <div class="input-group">
                                                <input type="text" class="form-control"
                                                    name="{{ $home_sec4_box2_title->slug ?? '' }}"
                                                    value="{{ $home_sec4_box2_title->value ?? '' }}"
                                                    id="{{ $home_sec4_box2_title->id ?? '' }}"
                                                    placeholder="{{ $home_sec4_box2_title->name ?? '' }}" required>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-12 col-md-4 col-lg-5 col-xl-5 col-xxl-5">
                                        <div class="form-group">
                                            <label for="{{ $home_sec4_box2_description->id ?? '' }}">
                                                {{ $home_sec4_box2_description->name ?? '' }}
                                            </label>
                                            <div class="input-group">
                                                <input type="text" class="form-control"
                                                    name="{{ $home_sec4_box2_description->slug ?? '' }}"
                                                    value="{{ $home_sec4_box2_description->value ?? '' }}"
                                                    id="{{ $home_sec4_box2_description->id ?? '' }}"
                                                    placeholder="{{ $home_sec4_box2_description->name ?? '' }}" required>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-row align-items-center">
                                    <div class="col-12 col-sm-12 col-md-4 col-lg-3 col-xl-3 col-xxl-3">
                                        <div class="avatar-upload">
                                            <div class="avatar-edit">
                                                <input type='file' type="file" name="{{ $home_sec4_box3_image->slug ?? '' }}"
                                                    id="{{ $home_sec4_box3_image->id ?? '' }}" class="change-img"
                                                    accept=".png, .jpg, .jpeg, .webp" />
                                                <label for="{{ $home_sec4_box3_image->id ?? '' }}"></label>
                                            </div>
                                            <div class="avatar-preview">
                                                <div class="imagePreview">
                                                    <img src="{{ asset($home_sec4_box3_image->value ?? 'assets/web/images/user.jpg') }}"
                                                        alt="img" class="img-fluid">
                                                </div>
                                            </div>
                                            <h5>{{ $home_sec4_box3_image->name ?? '' }}</h5>
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-12 col-md-4 col-lg-4 col-xl-4 col-xxl-4">
                                        <div class="form-group">
                                            <label for="{{ $home_sec4_box3_title->id ?? '' }}">
                                                {{ $home_sec4_box3_title->name ?? '' }}
                                            </label>
                                            <div class="input-group">
                                                <input type="text" class="form-control"
                                                    name="{{ $home_sec4_box3_title->slug ?? '' }}"
                                                    value="{{ $home_sec4_box3_title->value ?? '' }}"
                                                    id="{{ $home_sec4_box3_title->id ?? '' }}"
                                                    placeholder="{{ $home_sec4_box3_title->name ?? '' }}" required>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-12 col-md-4 col-lg-5 col-xl-5 col-xxl-5">
                                        <div class="form-group">
                                            <label for="{{ $home_sec4_box3_description->id ?? '' }}">
                                                {{ $home_sec4_box3_description->name ?? '' }}
                                            </label>
                                            <div class="input-group">
                                                <input type="text" class="form-control"
                                                    name="{{ $home_sec4_box3_description->slug ?? '' }}"
                                                    value="{{ $home_sec4_box3_description->value ?? '' }}"
                                                    id="{{ $home_sec4_box3_description->id ?? '' }}"
                                                    placeholder="{{ $home_sec4_box3_description->name ?? '' }}" required>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-row align-items-center">
                                    <div class="col-12 col-sm-12 col-md-4 col-lg-3 col-xl-3 col-xxl-3">
                                        <div class="avatar-upload">
                                            <div class="avatar-edit">
                                                <input type='file' type="file" name="{{ $home_sec4_box4_image->slug ?? '' }}"
                                                    id="{{ $home_sec4_box4_image->id ?? '' }}" class="change-img"
                                                    accept=".png, .jpg, .jpeg, .webp" />
                                                <label for="{{ $home_sec4_box4_image->id ?? '' }}"></label>
                                            </div>
                                            <div class="avatar-preview">
                                                <div class="imagePreview">
                                                    <img src="{{ asset($home_sec4_box4_image->value ?? 'assets/web/images/user.jpg') }}"
                                                        alt="img" class="img-fluid">
                                                </div>
                                            </div>
                                            <h5>{{ $home_sec4_box4_image->name ?? '' }}</h5>
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-12 col-md-4 col-lg-4 col-xl-4 col-xxl-4">
                                        <div class="form-group">
                                            <label for="{{ $home_sec4_box4_title->id ?? '' }}">
                                                {{ $home_sec4_box4_title->name ?? '' }}
                                            </label>
                                            <div class="input-group">
                                                <input type="text" class="form-control"
                                                    name="{{ $home_sec4_box4_title->slug ?? '' }}"
                                                    value="{{ $home_sec4_box4_title->value ?? '' }}"
                                                    id="{{ $home_sec4_box4_title->id ?? '' }}"
                                                    placeholder="{{ $home_sec4_box4_title->name ?? '' }}" required>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-12 col-md-4 col-lg-5 col-xl-5 col-xxl-5">
                                        <div class="form-group">
                                            <label for="{{ $home_sec4_box4_description->id ?? '' }}">
                                                {{ $home_sec4_box4_description->name ?? '' }}
                                            </label>
                                            <div class="input-group">
                                                <input type="text" class="form-control"
                                                    name="{{ $home_sec4_box4_description->slug ?? '' }}"
                                                    value="{{ $home_sec4_box4_description->value ?? '' }}"
                                                    id="{{ $home_sec4_box4_description->id ?? '' }}"
                                                    placeholder="{{ $home_sec4_box4_description->name ?? '' }}" required>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                                    <button class="btn btn-primary mt-4 d-inline w-20" type="submit">save/update</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
