@extends('admin.layouts.master')
@section('content')
    <div class="ms-content-wrapper">
        <div class="row">
            <div class="col-md-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb pl-0">
                        <li class="breadcrumb-item"><a href="javascript:;"><i class="material-icons">home</i> Home</a></li>
                        <li class="breadcrumb-item"><a href="javascript:;">Testimonials</a></li>
                    </ol>
                </nav>
            </div>
            <div class="col-xl-12 col-md-12">
                <div class="ms-panel">
                    <div class="ms-panel-header ms-panel-custome">
                        <h6>Add Testimonials</h6>
                        <a href="{{ route('admin.servicesView') }}" class="ms-text-primary">Testimonials List </a>
                    </div>
                    <div class="ms-panel-body">
                        <form class="needs-validation" action="{{ route('admin.testimonialsUpdate') }}" method="POST" enctype="multipart/form-data" novalidate>
                            @csrf
                            <input type="hidden" name="testimonial_id" value="{{ $getTestimonial->id ?? 0 }}">
                            
                            <div class="form-row">
                                <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12 mb-3">
                                    <label for="validationCustom001">User Name</label>
                                    <div class="input-group">
                                        <input type="text" class="form-control" name="user_name" value="{{ $getTestimonial->user_name ?? '' }}" id="validationCustom001"
                                            placeholder="Title" required>
                                    </div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12 mb-2">
                                    <label>Testimonials</label>
                                    <div class="input-group">
                                        <textarea class="form-control" id="exampleTextarea" name="testimonial" rows="3">{{ $getTestimonial->testimonial ?? '' }}</textarea>
                                    </div>
                                </div>
                            </div>
                            <button class="btn btn-primary mt-4 d-inline w-20" type="submit">Save/Update</button>
                        </form>

                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
