@extends('admin.layouts.master')
@section('content')
    <div class="ms-content-wrapper">
        <div class="row">
            <div class="col-md-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb pl-0">
                        <li class="breadcrumb-item"><a href="javascript:;"><i class="material-icons">home</i> Home</a></li>
                        <li class="breadcrumb-item"><a href="javascript:;">Services</a></li>
                    </ol>
                </nav>
            </div>
            <div class="col-xl-12 col-md-12">
                <div class="ms-panel">
                    <div class="ms-panel-header ms-panel-custome">
                        <h6>Add Services</h6>
                        <a href="{{ route('admin.servicesView') }}" class="ms-text-primary">Services List </a>
                    </div>
                    <div class="ms-panel-body">
                        <form class="needs-validation" action="{{ route('admin.servicesUpdate') }}" method="POST" enctype="multipart/form-data" novalidate>
                            @csrf
                            <input type="hidden" name="service_id" value="{{ $service->id ?? '' }}">
                            <div class="form-row">
                                <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                                    <div class="avatar-upload">
                                        <div class="avatar-edit">
                                            <input type='file' type="file" name="image" id="serviceId"
                                                class="change-img" accept=".png, .jpg, .jpeg, .webp" />
                                            <label for="serviceId"></label>
                                        </div>
                                        <div class="avatar-preview">
                                            <div class="imagePreview">
                                                @if(isset($service) && $service != null)
                                                    <img src="{{ asset($service->image ?? '') }}" alt="img" class="img-fluid">
                                                @else
                                                    <img src="{{ asset('assets/web/images/user.jpg') }}" alt="img" class="img-fluid">
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12 mb-3">
                                    <label for="validationCustom001">Title</label>
                                    <div class="input-group">
                                        <input type="text" class="form-control" name="title" value="{{ $service->title ?? '' }}" id="validationCustom001"
                                            placeholder="Title" required>

                                    </div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12 mb-2">
                                    <label>Short Description</label>
                                    <div class="input-group">
                                        <textarea class="form-control" id="exampleTextarea" name="short_desc" rows="3">{{ $service->short_desc ?? '' }}</textarea>
                                    </div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12 mb-2">
                                    <label>Description</label>
                                    <div class="form-group">
                                        <textarea class="form-control tinyEditor" id="exampleTextarea1" name="description" rows="3">{{ $service->description ?? '' }}</textarea>
                                    </div>
                                </div>
                            </div>
                            <button class="btn btn-primary mt-4 d-inline w-20" type="submit">save/update</button>
                        </form>

                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
