@extends('admin.layouts.master')
@section('content')
    <div class="ms-content-wrapper">
        <div class="row">
            <div class="col-md-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb pl-0">
                        <li class="breadcrumb-item"><a href="javascript:;"><i class="material-icons">home</i> Home</a></li>
                        <li class="breadcrumb-item"><a href="javascript:;">Room</a></li>
                    </ol>
                </nav>
            </div>
            <div class="col-xl-12 col-md-12">
                <div class="ms-panel">
                    <div class="ms-panel-header ms-panel-custome">
                        <h6>Add Room</h6>
                        <a href="{{ route('admin.roomsView') }}" class="ms-text-primary">Room List </a>
                    </div>
                    <div class="ms-panel-body">
                        <form class="needs-validation" action="{{ route('admin.roomsUpdate') }}" method="POST" novalidate>
                            @csrf
                            <input type="hidden" name="room_id" value="{{ $room->id ?? '' }}">
                            <div class="form-row">
                                <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12 mb-3">
                                    <label for="validationCustom001">Day</label>
                                    <div class="input-group">
                                        <select class="form-control" name="day" required>
                                            <option selected disabled>Select Day</option>
                                            @php
                                                $daysOfWeek = [
                                                    'Monday',
                                                    'Tuesday',
                                                    'Wednesday',
                                                    'Thursday',
                                                    'Friday',
                                                    'Saturday',
                                                    'Sunday',
                                                ];
                                            @endphp
                                            @foreach ($daysOfWeek as $day)
                                                <option value="{{ $day }}"
                                                    {{ isset($room) && $room->day == $day ? 'selected' : '' }}>{{ $day }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12 mb-3">
                                    <label for="validationCustom002">Start time</label>
                                    <div class="input-group">
                                        <input type="time" class="form-control" name="start_time"
                                            value="{{ $room->start_time ?? '' }}" id="validationCustom002"
                                            placeholder="Start time" required>
                                    </div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12 mb-3">
                                    <label for="validationCustom003">End time</label>
                                    <div class="input-group">
                                        <input type="time" class="form-control" name="end_time"
                                            value="{{ $room->end_time ?? '' }}" id="validationCustom003"
                                            placeholder="End time" required>
                                    </div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12 mb-3">
                                    <label for="validationCustom003">Duration</label>
                                    <div class="input-group">
                                        <input type="number" class="form-control" min="5" max="60" step="5" name="duration"
                                            value="{{ $room->duration ?? '' }}" id="validationCustom003"
                                            placeholder="Duration" required>
                                    </div>
                                </div>
                            </div>
                            <button class="btn btn-primary mt-4 d-inline w-20" type="submit">save/update</button>
                        </form>

                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('scripts')
    <script>
        @if (Session::has('validationerror'))
            @foreach (Session::get('validationerror') as $error)
                toastr.options = {
                    "closeButton": true,
                    "progressBar": true,
                    "debug": false,
                    "positionClass": "toast-bottom-right",
                }
                toastr.error("{{ $error }}");
            @endforeach
        @endif
    </script>
@endsection
