@extends('admin.layouts.master')
@section('content')
    <div class="ms-content-wrapper">
        <div class="row">
            <div class="col-md-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb pl-0">
                        <li class="breadcrumb-item"><a href="javascript:;"><i class="material-icons">home</i> Home</a></li>
                        <li class="breadcrumb-item"><a href="javascript:;">User</a></li>
                    </ol>
                </nav>
            </div>
            <div class="col-xl-12 col-md-12">
                <div class="ms-panel">
                    <div class="ms-panel-header ms-panel-custome">
                        <h6>Add Users</h6>
                    </div>
                    <div class="ms-panel-body">
                        <form class="needs-validation" action="{{ route('admin.providerAdd') }}" method="POST" enctype="multipart/form-data" novalidate>
                            @csrf
                            <input type="hidden" name="role_id" value="{{ $Role_id }}">
                            <input type="hidden" name="role_type" value="{{ $role_type }}">
                            <div class="form-row">
                                <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                                    <div class="avatar-upload">
                                        <div class="avatar-edit">
                                            <input type='file' type="file" name="image" id="UserId"
                                                class="change-img" accept=".png, .jpg, .jpeg, .webp" />
                                            <label for="UserId"></label>
                                        </div>
                                        <div class="avatar-preview">
                                            <div class="imagePreview">
                                                @if(isset($providers) && $providers != null)
                                                    <img src="{{ asset($providers->image ?? '') }}" alt="img" class="img-fluid">
                                                @else
                                                    <img src="{{ asset('assets/web/images/user.jpg') }}" alt="img" class="img-fluid">
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 mb-3">
                                    <label for="validationCustom001">Name</label>
                                    <div class="input-group">
                                        <input type="text" class="form-control" name="name"  id="validationCustom001" placeholder="Name" required>
                                    </div>
                                </div>
                                <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 mb-3">
                                    <label for="validationCustom001">Email</label>
                                    <div class="input-group">
                                        <input type="email" class="form-control" name="email"  id="validationCustom001" placeholder="Email" required>
                                    </div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12 mb-3">
                                    <label for="validationCustom001">Phone No</label>
                                    <div class="input-group">
                                        <input type="text" class="form-control" name="phone" id="validationCustom001" placeholder="Phone No" required>
                                    </div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 mb-3">
                                    <label for="validationCustom001">password</label>
                                    <div class="input-group">
                                        <input type="password" class="form-control" name="password"  id="validationCustom001" placeholder="Enter Password" required>
                                    </div>
                                </div>
                                <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 mb-3">
                                    <label for="validationCustom001">Confirm password</label>
                                    <div class="input-group">
                                        <input type="password" class="form-control" name="cnfpassword"  id="validationCustom001" placeholder="Confirm Password" required>
                                    </div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12 mb-2">
                                    <label>Address</label>
                                    <div class="input-group">
                                        <textarea class="form-control" id="exampleTextarea" name="address" rows="3"></textarea>
                                    </div>
                                </div>
                            </div>
                            <button class="btn btn-primary mt-4 d-inline w-20" type="submit">save</button>
                        </form>

                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('scripts')
    <script>
        @if (Session::has('validationerror'))
            @foreach (Session::get('validationerror') as $error)
                toastr.options = {
                    "closeButton": true,
                    "progressBar": true,
                    "debug": false,
                    "positionClass": "toast-bottom-right",
                }
                toastr.error("{{ $error }}");
            @endforeach
        @endif
    </script>
@endsection
