@extends('admin.layouts.master')
@section('content')
    <div class="ms-content-wrapper">
        <div class="row">
            <div class="col-md-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb pl-0">
                        <li class="breadcrumb-item"><a href="javascript:;"><i class="material-icons">home</i> Home</a></li>
                        <li class="breadcrumb-item"><a href="javascript:;">Profile</a></li>
                    </ol>
                </nav>
            </div>
            <div class="col-xl-12 col-md-12">
                <div class="ms-panel">
                    <div class="ms-panel-header ms-panel-custome">
                        <h6>Profile</h6>
                    </div>
                    <div class="ms-panel-body">
                        <form class="needs-validation profile-form" action="{{ route('admin.profileUpdate') }}" method="POST"
                            enctype="multipart/form-data" novalidate>
                            @csrf
                            @if ($errors->any())
                                <div class="alert alert-danger">
                                    <ul>
                                        @foreach ($errors->all() as $error)
                                            <li>{{ $error }}</li>
                                        @endforeach
                                    </ul>
                                </div>
                            @endif
                            <input type="hidden" name="user_id" value="{{ $profile->id }}">
                            <div class="form-row mb-3">
                                <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                                    <div class="avatar-upload">
                                        <div class="avatar-edit input-group">
                                            <input type='file' type="file" name="image" placeholder="image" id="imageUpload1"
                                                class="change-img form-control" accept=".png, .jpg, .jpeg" @if(Auth::user()->image == null) required @endif />
                                                <label for="imageUpload1"></label>
                                            <span class="invalid-feedback" role="alert">
                                                <strong>
                                                    @error('image')
                                                        {{ $message }}
                                                    @enderror
                                                </strong>
                                            </span>
                                        </div>
                                        <div class="avatar-preview">
                                            <div class="imagePreview">
                                                <img src="{{ asset($profile->image ?? 'assets/admin/img/user.jpg') }}" alt="img" class="img-fluid">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="form-row mb-2">
                                <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                    <label for="validationCustom001">Name</label>
                                    <div class="input-group">
                                        <input type="text" class="form-control" placeholder="Name" name="name"
                                            id="validationCustom001" value="{{ $profile->name }}" @if (Auth::user()->role_id != 1 &&  $profile->profile_edit == 1) readonly @endif>
                                    </div>
                                    <span class="invalid-feedback" role="alert">
                                        <strong>
                                            @error('name')
                                                {{ $message }}
                                            @enderror
                                        </strong>
                                    </span>
                                </div>
                                <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                    <label for="validationCustom002">Phone</label>
                                    <div class="input-group">
                                        <input type="text" class="form-control" placeholder="Phone" name="phone"
                                            id="validationCustom002" value="{{ $profile->phone }}" required>
                                        <span class="invalid-feedback" role="alert">
                                            <strong>
                                                @error('phone')
                                                    {{ $message }}
                                                @enderror
                                            </strong>
                                        </span>
                                    </div>
                                </div>
                            </div>

                            <div class="form-row mb-2">
                                <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                    <label for="validationCustom003">Social security number</label>
                                    <div class="input-group">
                                        <input type="text" class="form-control" placeholder="Social security number" name="social_security_number"
                                            id="validationCustom003" value="{{ $profile->social_security_number }}" @if (Auth::user()->role_id != 1 && $profile->profile_edit == 1) readonly @endif required>
                                        <span class="invalid-feedback" role="alert">
                                            <strong>
                                                @error('social_security_number')
                                                    {{ $message }}
                                                @enderror
                                            </strong>
                                        </span>
                                    </div>
                                </div>

                                <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                    <label for="validationCustom004">Email</label>
                                    <div class="input-group">
                                        <input type="email" class="form-control" placeholder="Email" name="email"
                                            id="validationCustom004" value="{{ $profile->email }}" disabled>
                                    </div>
                                </div>
                            </div>

                            <div class="form-row mb-2">
                                <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                    <label for="validationCustom005">Date of birth</label>
                                    <div class="input-group">
                                        <input type="date" class="form-control" placeholder="Date of birth" name="date_of_birth"
                                            id="validationCustom005" value="{{ $profile->date_of_birth }}" @if (Auth::user()->role_id != 1 && $profile->profile_edit == 1) readonly @endif required>
                                    </div>
                                    <span class="invalid-feedback" role="alert">
                                        <strong>
                                            @error('date_of_birth')
                                                {{ $message }}
                                            @enderror
                                        </strong>
                                    </span>
                                </div>
                                <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                    <label for="validationCustom006">Age</label>
                                    <div class="input-group">
                                        <input type="number" class="form-control" placeholder="Age"
                                            id="ageInput" readonly>
                                    </div>
                                </div>
                            </div>

                            <div class="form-row">
                                <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                                    <label>Address</label>
                                    <div class="input-group">
                                        <textarea class="form-control" id="exampleTextarea1" rows="3" name="address" placeholder="Address" required>{{ $profile->address }}</textarea>
                                        <span class="invalid-feedback" role="alert">
                                            <strong>
                                                @error('address')
                                                    {{ $message }}
                                                @enderror
                                            </strong>
                                        </span>
                                    </div>
                                </div>
                            </div>

                            @if (Auth::user()->role_id == 1 && $profile->profile_edit == 0)
                                <div class="form-row">
                                    <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                                        <p class="note"><b>Note:</b> You can edit your name, SSNs, date of birth, and age once; you cannot re-edit it.</p>
                                    </div>
                                </div>
                            @endif

                            <button class="btn btn-primary mt-4 d-inline w-20 profile-submit" type="submit">Create Profile</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('css')
<style>
    .avatar-upload .avatar-edit.input-group{
        margin-bottom: 0;
        width: auto;
    }
    .form-row .note{
        font-size: 20px;
        color: #ff0000;
        font-style: italic;
        font-weight: 500;
    }
    .form-row .note b{
        font-weight: 700;
    }
</style>
@endsection
@section('scripts')
<script>
    // change img start
    function readURLcl(input) {
        if (input.files && input.files[0]) {
            var reader = new FileReader();
            reader.onload = function(e) {
                $(input).closest('.avatar-upload').find('img').attr('src', e.target.result);
            }
            reader.readAsDataURL(input.files[0]);
        }
    }
    $(".change-img").change(function() {
        readURLcl(this);
    });
    // change img start

    // Function to calculate age
    $(document).ready(function() {
        function calculateAge(dob) {
            const dobDate = new Date(dob);
            const diffMs = Date.now() - dobDate.getTime();
            const ageDt = new Date(diffMs);
            return Math.abs(ageDt.getUTCFullYear() - 1970);
        }

        $('#validationCustom005').on('change', function() {
            const dobValue = $(this).val();
            if (dobValue) {
                const age = calculateAge(dobValue);
                $('#ageInput').val(age);
            } else {
                $('#ageInput').val('');
            }
        });

        const initialDobValue = $('#validationCustom005').val();
        if (initialDobValue) {
            const age = calculateAge(initialDobValue);
            $('#ageInput').val(age);
        }
    });
    // Function to calculate age

    $(document).on('click', '.profile-submit', function(event) {
        event.preventDefault();

        var has_error = false;
        var form = $(this).closest('.profile-form');

        form.find(".is-invalid").removeClass('is-invalid');

        form.find("select, textarea, input").each(function() {
            if ($(this).prop("required")) {
                if ($(this).val() === "") {
                    has_error = true;
                    $(this).addClass('is-invalid');

                    var fieldName = $(this).attr('placeholder') || $(this).attr('name');
                    fieldName = fieldName.replace('*', '');
                    $(this).siblings('.invalid-feedback').find('strong').text("Please fill out the " + fieldName);
                }
            }
        });

        if (!has_error) {
            form.submit();
        } else {
            toastr.options = {
                "closeButton": true,
                "progressBar": true,
                "positionClass": "toast-bottom-right",
            };
            toastr.error("Fill All Required Fields");
        }
    });

    @if (Session::has('validationerror'))
        @foreach (Session::get('validationerror') as $error)
            toastr.options = {
                "closeButton": true,
                "progressBar": true,
                "debug": false,
                "positionClass": "toast-bottom-right",
            }
            toastr.error("{{ $error }}");
        @endforeach
    @endif
</script>
@endsection
