@extends('admin.layouts.master')
@section('content')
    <div class="ms-content-wrapper">
        <div class="row">
            <div class="col-md-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb pl-0">
                        <li class="breadcrumb-item"><a href="javascript:;"><i class="material-icons">home</i> Home</a></li>
                        <li class="breadcrumb-item"><a href="javascript:;">Pateint</a></li>
                    </ol>
                </nav>
                <div class="ms-panel">
                    <div class="ms-panel-header ms-panel-custome">
                        <h6>Pateint List</h6>
                    </div>
                    <div class="ms-panel-body">
                        <div class="table-responsive">
                            <table class="table table-striped thead-primary w-100 dataTable-main">
                                <thead>
                                    <tr>
                                        <th scope="col">#</th>
                                        <th scope="col">Name</th>
                                        <th scope="col">Email</th>
                                        <th scope="col">Phone No</th>
                                        <th scope="col">Documents</th>
                                        <th scope="col">Medical Profile</th>
                                        <th scope="col">Medication</th>
                                        <th scope="col">Order</th>
                                        <th scope="col">Update Password</th>
                                        <th scope="col">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($pateint as $key => $item)
                                        <tr>
                                            <th scope="row">{{ $key + 1 }}</th>
                                            <td>{{ $item->name ?? '-' }}</td>
                                            <td>{{ $item->email ?? '-' }}</td>
                                            <td>{{ $item->phone ?? '-' }}</td>
                                            <td>
                                                <div class="btn-box">
                                                    <a href="{{ route('admin.patientDocuments', $item->id) }}" class="btn btn-primary">View Documents</a>
                                                    <a href="{{ route('admin.patientreportsList', $item->id) }}" class="btn btn-primary">Add Reports</a>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="btn-box">
                                                    <a href="{{ route('admin.medicalProfilePatient', $item->id) }}" class="btn btn-primary">Medical Profile</a>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="btn-box">
                                                    <a href="{{ route('admin.medicationReport', $item->id) }}" class="btn btn-primary">Current Medication</a>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="btn-box">
                                                    <a href="{{ route('admin.patientChargeHistoryView', $item->id) }}" class="btn btn-primary">Pateint orders</a>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="btn-box">
                                                    <button type="button" data-id="{{ $item->id }}"
                                                        class="btn btn-primary passchange">
                                                        Change Passowrd
                                                    </button>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="btn-box">
                                                    <a href="{{ route('admin.profileEdit', $item->id) }}" class="icon-bt"><i class="fas fa-pencil-alt ms-text-primary"></i></a>
                                                    <a data-id="{{ $item->id }}" class="remove-item icon-bt">
                                                        <i class="far fa-trash-alt ms-text-danger"></i>
                                                    </a>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="passwordModal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog ms-modal-dialog-width">
            <div class="modal-content ms-modal-content-width">
                <div class="modal-header  ms-modal-header-radius-0">
                    <h4 class="modal-title text-white">Change password</h4>
                    <button type="button" class="close  text-white" data-dismiss="modal" aria-hidden="true">x</button>
                </div>
                <div class="modal-body p-0 text-left">
                    <div class="col-xl-12 col-md-12">
                        <div class="ms-panel ms-panel-bshadow-none">
                            <div class="ms-panel-header">
                                <h6>Change password</h6>
                            </div>
                            <div class="ms-panel-body">
                                <form action="{{ route('admin.USerPasswordManage') }}" method="POST" class="needs-validation" novalidate>
                                    @csrf
                                    <input type="hidden" id="user_id" name="id" value="">
                                    <div class="form-row">
                                        <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12 mb-3">
                                            <label for="validationCustom1">New Password</label>
                                            <div class="input-group">
                                                <input type="password" class="form-control" name="newpassword" id="validationCustom1"
                                                    placeholder="********" required>
                                            </div>
                                        </div>
                                        <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12 mb-3">
                                            <label for="validationCustom2">Date Of Birth</label>
                                            <div class="input-group">
                                                <input type="password" class="form-control" name="cnfpassword" id="validationCustom2"
                                                    placeholder="********" required>
                                            </div>
                                        </div>
                                    </div>
                                    <button class="btn btn-warning mt-4 d-inline w-20" type="submit">Submit</button>
                                </form>
                            </div>

                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
@endsection
@section('scripts')
    <script>
        $(document).on('click', '.remove-item', function() {
            var ele_id = $(this).data('id');
            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#0073b1',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        type: 'post',
                        dataType: 'json',
                        url: "{{ route('admin.deleteProfile') }}",
                        data: {
                            id: ele_id,
                            _token: '{{ csrf_token() }}'
                        },
                        success: function(response) {
                            if (response.status == 0) {
                                toastr.error(response.message);
                            } else {
                                toastr.success(response.message);
                                location.reload();
                            }
                        }
                    });
                    console.log("here");
                }
            })
        });

        $(document).on('click', '.passchange', function() {
            var ele = $(this).data('id');
            $('#passwordModal').modal('show');
            $('#user_id').val(ele);
        });

        @if (Session::has('validationerror'))
            @foreach (Session::get('validationerror') as $error)
                toastr.options = {
                    "closeButton": true,
                    "progressBar": true,
                    "debug": false,
                    "positionClass": "toast-bottom-right",
                }
                toastr.error("{{ $error }}");
            @endforeach
        @endif
    </script>
@endsection
