@extends('admin.layouts.master')
@section('content')
    <div class="ms-content-wrapper">
        <div class="row">
            <div class="col-md-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb pl-0">
                        <li class="breadcrumb-item"><a href="javascript:;"><i class="material-icons">home</i> Home</a></li>
                        <li class="breadcrumb-item"><a href="javascript:;">{{ $title }}</a></li>
                    </ol>
                </nav>
                <div class="ms-panel">
                    <div class="ms-panel-header ms-panel-custome">
                        <h6>{{ $title }}</h6>
                    </div>
                    <div class="ms-panel-body">
                        <div class="medication-pofile">
                            <h3>Problems & Conditions</h3>
                            <p>{{ $medication->problem_condition ?? 'No data available' }}</p>

                            <h3>Current Medications</h3>
                            <p>{{ $medication->current_medication ?? 'No data available' }}</p>

                            <h3>Current Supplements</h3>
                            <p>{{ $medication->current_supplement ?? 'No data available' }}</p>

                            <h3>Notes & Charts</h3>
                            <p>{{ $medication->notes ?? 'No data available' }}</p>

                            <h3>Allergies & Red flags</h3>
                            <p>{{ $medication->allergies_redflag ?? 'No data available' }}</p>
                        </div>
                        <div class="medication-pofile">
                            <h3>Future Appointments</h3>

                            <div class="table-responsive">
                                <table class="table table-striped thead-primary w-100 dataTable-main appointmentData">
                                    <thead>
                                        <tr>
                                            <th scope="col">#</th>
                                            <th scope="col">Name</th>
                                            <th scope="col">Phone Number</th>
                                            <th scope="col">SSN</th>
                                            <th scope="col">Appointment Date & Time</th>
                                            <th scope="col">Appointment Problem</th>
                                            <th scope="col">Status</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($futureAppointments as $key => $item)
                                            <tr>
                                                <th scope="row">{{ $key + 1 }}</th>
                                                <td>{{ $item->name ?? '' }}</td>
                                                <td>
                                                    @if (empty($item->phone_number))
                                                        {{ $item->user->phone ?? '-' }}
                                                    @else
                                                        {{ $item->phone_number ?? '-' }}
                                                    @endif
                                                </td>
                                                <td>
                                                    @if (empty($item->social_security_number))
                                                        {{ $item->user->social_security_number ?? '-' }}
                                                    @else
                                                        {{ $item->social_security_number ?? '-' }}
                                                    @endif
                                                </td>
                                                <td>
                                                    <ul class="formatTime">
                                                        <li>
                                                            <h4>Date</h4>
                                                            <p>{{ $item->appointment_date ? \Carbon\Carbon::parse($item->appointment_date)->format('M d, Y') : '' }}
                                                            </p>
                                                        </li>
                                                        <li>
                                                            <h4>Time</h4>
                                                            <p>{{ $item->appointment_time ? \Carbon\Carbon::parse($item->appointment_time)->format('h:i A') : '' }}
                                                            </p>
                                                        </li>
                                                    </ul>
                                                </td>
                                                <td>{{ $item->problem ?? '' }}</td>
                                                <td>
                                                    @if ($item->status == 'pending')
                                                        <h2 class="main-status pending">Pending</h2>
                                                    @elseif ($item->status == 'cancel')
                                                        <h2 class="main-status cancel">Cancel</h2>
                                                    @elseif ($item->status == 'completed')
                                                        <h2 class="main-status completed">Completed</h2>
                                                    @else
                                                        <h2 class="main-status approve">Approve</h2>
                                                    @endif
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <div class="medication-pofile">
                            <h3>Orders</h3>

                            <div class="table-responsive">
                                <table class="table table-striped thead-primary w-100 dataTable-main">
                                    <thead>
                                        <tr>
                                            <th scope="col">#</th>
                                            <th scope="col">Price</th>
                                            <th scope="col">Description</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($order as $key => $item)
                                            <tr>
                                                <th scope="row">{{ $key + 1 }}</th>
                                                <td>${{ number_format($item->amount, 2) ?? '' }}</td>
                                                <td>{!! $item->description ?? '' !!}</td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
