@extends('admin.layouts.master')
@section('content')
    <div class="ms-content-wrapper">
        <div class="row">
            <div class="col-md-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb pl-0">
                        <li class="breadcrumb-item"><a href="javascript:;"><i class="material-icons">home</i> Home</a></li>
                        <li class="breadcrumb-item"><a href="javascript:;">Medical Profile</a></li>
                    </ol>
                </nav>
                <div class="ms-panel">
                    <div class="ms-panel-header ms-panel-custome">
                        <h6>Medical Profile</h6>
                    </div>
                    <div class="ms-panel-body">
                        <div class="medical-profile">
                            @foreach ($appointments as $item)
                                <div class="user-box">
                                    <div class="user-info">
                                        <ul>
                                            <li>
                                                <span>Name</span>
                                                <p>{{ $item->name ?? '' }}</p>
                                            </li>
                                            <li>
                                                <span>Appointment Date</span>
                                                <p>{{ $item->appointment_date ? \Carbon\Carbon::parse($item->appointment_date)->format('M d, Y') : '' }}</p>
                                            </li>
                                            <li>
                                                <span>Appointment Time</span>
                                                <p>{{ $item->appointment_time ? \Carbon\Carbon::parse($item->appointment_time)->format('h:i A') : '' }}</p>
                                            </li>
                                        </ul>
                                    </div>
                                    <div class="user-profile">
                                        <div class="head-info">
                                            <h2>Ref Flag :</h2>
                                            <p>{{ $item->problem }}</p>
                                        </div>
                                        <div class="head-report">
                                            <h3>Reports</h3>
                                        </div>
                                        @if (isset($medicalReports[$item->id]) && count($medicalReports[$item->id]) > 0)
                                            <div class="reports-box">
                                                @foreach ($medicalReports[$item->id] ?? [] as $data)
                                                    <div class="report-card">
                                                        <div class="info">
                                                            {{-- <h4>{{ $data->file_name }}</h4> --}}
                                                            <h4>
                                                                @php
                                                                    // Split the filename by the last occurrence of the dot to handle multiple dots
                                                                    $filenameParts = explode('.', $data->file_name);
                                                                    // Get the extension which is the last part of the split
                                                                    $extension = array_pop($filenameParts);
                                                                    // Reconstruct the filename without the extension part
                                                                    $baseName = implode('.', $filenameParts);
                                                                    // Split the base filename by the hyphen
                                                                    $nameParts = explode('-', $baseName);
                                                                    // Get the first part of the filename
                                                                    $firstName = $nameParts[0];
                                                                    // Construct the new filename with the extension
                                                                    $newFileName = $firstName . '.' . $extension;
                                                                    echo $newFileName;
                                                                @endphp
                                                            </h4>
                                                            <p>{{ round($data->file_size / 1024, 2) }} KB</p>
                                                        </div>
                                                        <div class="icon">
                                                            <a href="{{ asset($data->file) }}" download><i class="fa-solid fa-download"></i></a>
                                                        </div>
                                                    </div>
                                                @endforeach
                                            </div>
                                        @else
                                            <div class="head-report">
                                                <p>No reports yet to show</p>
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
