@extends('admin.layouts.master')
@section('content')
    <div class="ms-content-wrapper">
        <div class="row">
            <div class="col-md-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb pl-0">
                        <li class="breadcrumb-item"><a href="javascript:;"><i class="material-icons">home</i> Home</a></li>
                        <li class="breadcrumb-item"><a href="javascript:;">Logo & fav</a></li>
                    </ol>
                </nav>
            </div>
            <div class="col-xl-12 col-md-12">
                <div class="ms-panel">
                    <div class="ms-panel-header ms-panel-custome">
                        <h6>Logo & fav</h6>
                    </div>
                    <div class="ms-panel-body">
                        <form class="needs-validation" action="{{ route('admin.logoUpdate') }}" method="POST"
                            enctype="multipart/form-data" novalidate>
                            @csrf
                            <div class="form-row">
                                <div class="col-12 col-sm-12 col-md-6 col-lg-4 col-xl-4 col-xxl-4">
                                    <div class="avatar-upload">
                                        <div class="avatar-edit">
                                            <input type='file' type="file" name="{{ $logo_dark->slug }}" id="{{ $logo_dark->id }}"
                                                class="change-img" accept=".png, .jpg, .jpeg" />
                                            <label for="{{ $logo_dark->id }}"></label>
                                        </div>
                                        <div class="avatar-preview">
                                            <div class="imagePreview">
                                                <img src="{{ asset($logo_dark->value) }}" alt="img" class="img-fluid">
                                            </div>
                                        </div>
                                    </div>
                                    <h2 style="text-align: center">{{ $logo_dark->name }}</h2>
                                </div>
                                <div class="col-12 col-sm-12 col-md-6 col-lg-4 col-xl-4 col-xxl-4">
                                    <div class="avatar-upload">
                                        <div class="avatar-edit">
                                            <input type='file' type="file" name="{{ $logo_light->slug }}" id="{{ $logo_light->id }}"
                                                class="change-img" accept=".png, .jpg, .jpeg" />
                                            <label for="{{ $logo_light->id }}"></label>
                                        </div>
                                        <div class="avatar-preview">
                                            <div class="imagePreview">
                                                <img src="{{ asset($logo_light->value) }}" alt="img" class="img-fluid">
                                            </div>
                                        </div>
                                    </div>
                                    <h2 style="text-align: center">{{ $logo_light->name }}</h2>
                                </div>
                                <div class="col-12 col-sm-12 col-md-6 col-lg-4 col-xl-4 col-xxl-4">
                                    <div class="avatar-upload">
                                        <div class="avatar-edit">
                                            <input type='file' type="file" name="{{ $favicon->slug }}" id="{{ $favicon->id }}"
                                                class="change-img" accept=".png, .jpg, .jpeg" />
                                            <label for="{{ $favicon->id }}"></label>
                                        </div>
                                        <div class="avatar-preview">
                                            <div class="imagePreview">
                                                <img src="{{ asset($favicon->value) }}" alt="img" class="img-fluid">
                                            </div>
                                        </div>
                                    </div>
                                    <h2 style="text-align: center">{{ $favicon->name }}</h2>
                                </div>
                            </div>
                            <button class="btn btn-primary mt-4 d-inline w-20" type="submit">Update</button>
                        </form>

                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('content')
    <script>
        // change img start
        function readURLcl(input) {
            console.log("yes");
            if (input.files && input.files[0]) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $(input).closest('.avatar-upload').find('img').attr('src', e.target.result);
                }
                reader.readAsDataURL(input.files[0]);
            }
        }
        $(".change-img").change(function() {
            readURLcl(this);
        });
        // change img start
    </script>
@endsection
