@extends('admin.layouts.master')
@section('content')
    <div class="ms-content-wrapper">
        <div class="row">
            <div class="col-md-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb pl-0">
                        <li class="breadcrumb-item"><a href="javascript:;"><i class="material-icons">home</i> Home</a></li>
                        <li class="breadcrumb-item"><a href="javascript:;">Document</a></li>
                    </ol>
                </nav>
                <div class="ms-panel">
                    <div class="ms-panel-header ms-panel-custome">
                        <h6>{{ $title }}</h6>
                        <a href="javascript:;" class="btn btn-primary documentCreate">Add document</a>
                    </div>
                    <div class="ms-panel-body">
                        <div class="documents-box">
                            <div class="row">
                                @foreach ($document as $item)
                                    <div class="col-12 col-sm-6 col-md-4 col-lg-3 col-xl-3 col-xxl-3">
                                        <div class="document-card">
                                            <div class="main-img">
                                                @if (in_array(strtolower(pathinfo($item->file, PATHINFO_EXTENSION)), ['jpg', 'jpeg', 'png', 'gif', 'webp']))
                                                    <img src="{{ asset($item->file) }}" alt="img" class="img-fluid">
                                                @else
                                                    <img src="{{ asset('assets/web/images/doc-img.jpg') }}" alt="img" class="img-fluid">
                                                @endif
                                            </div>
                                            <div class="desc">
                                                <h4>{{ $item->file_name }}</h4>
                                                <p>{{ round($item->file_size / 1024, 2) }} KB</p>
                                            </div>
                                            <div class="icon-list">
                                                <ul>
                                                    <li>
                                                        <a href="javascript:;" data-id="{{ $item->id }}" class="remove-item">
                                                            <i class="fa-solid fa-trash"></i>
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a href="{{ asset($item->file) }}" download><i class="fa-solid fa-download"></i></a>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="documentModal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog ms-modal-dialog-width">
            <div class="modal-content ms-modal-content-width">
                <div class="modal-header  ms-modal-header-radius-0">
                    <h4 class="modal-title text-white">Add Documents</h4>
                    <button type="button" class="close  text-white" data-dismiss="modal" aria-hidden="true">x</button>
                </div>
                <div class="modal-body p-0 text-left">
                    <div class="col-xl-12 col-md-12">
                        <div class="ms-panel ms-panel-bshadow-none">
                            <div class="ms-panel-header">
                                <h6>Document</h6>
                            </div>
                            <div class="ms-panel-body">
                                <form class="needs-validation" action="{{ route('admin.patientDocumnetSave') }}"
                                    method="POST" enctype="multipart/form-data" novalidate>
                                    @csrf
                                    <input type="hidden" name="upload_by" value="{{ Auth::user()->role_type }}">
                                    <div class="form-row">
                                        <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12 mb-3">
                                            <label for="validationCustom16">Document</label>
                                            <div class="input-group">
                                                <input type="file" class="form-control" name="file"
                                                    id="validationCustom16" required>
                                            </div>
                                        </div>
                                    </div>
                                    <button class="btn btn-warning mt-4 d-inline w-20" type="submit">Save</button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('scripts')
    <script>
        $(document).on('click', '.documentCreate', function() {
            $('#documentModal').modal('show');
        });

        $("input[type='file']").on("change", function() {
            console.log('here');
            var sizeInMB = (this.files[0].size / (1024 * 1024)).toFixed(2);
            console.log(sizeInMB);
            if (sizeInMB > 20) {
                console.log(this.files[0].size);
                toastr.options = {
                    "closeButton": true,
                    "progressBar": true
                }
                toastr.error("{{ session('error', 'Please upload file less than 20MB.') }}");
                $(this).val('');
            }
        });

        $(document).on('click', '.remove-item', function() {
            var ele_id = $(this).data('id');
            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#0073b1',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        type: 'post',
                        dataType: 'json',
                        url: "{{ route('admin.patientDocumnetDelete') }}",
                        data: {
                            id: ele_id,
                            _token: '{{ csrf_token() }}'
                        },
                        success: function(response) {
                            if (response.status == 0) {
                                toastr.error(response.message);
                            } else {
                                toastr.success(response.message);
                                location.reload();
                            }
                        }
                    });
                    console.log("here");
                }
            })
        });
    </script>
@endsection
