@extends('admin.layouts.master')
@section('content')
    <div class="ms-content-wrapper">
        <div class="row">
            <div class="col-md-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb pl-0">
                        <li class="breadcrumb-item"><a href="javascript:;"><i class="material-icons">home</i> Home</a></li>
                        <li class="breadcrumb-item"><a href="javascript:;">Config</a></li>
                    </ol>
                </nav>
            </div>
            <div class="col-xl-12 col-md-12">
                <div class="ms-panel">
                    <div class="ms-panel-header ms-panel-custome">
                        <h6>{{ $title }}</h6>
                    </div>
                    <div class="ms-panel-body">
                        <form class="needs-validation" action="{{ route('admin.configUpdate') }}" method="POST" novalidate>
                            @csrf
                            <div class="form-row">
                                <div class="col-md-6 mb-3">
                                    <label for="validationCustom001">Email</label>
                                    <div class="input-group">
                                        <input type="email" class="form-control" name="email" value="{{ $config->email }}" id="validationCustom001" required>

                                    </div>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="validationCustom002">Phone no</label>
                                    <div class="input-group">
                                        <input type="text" class="form-control" name="phone_no" value="{{ $config->phone_no }}" id="validationCustom002" required>

                                    </div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="col-md-4 mb-3">
                                    <label for="validationCustom003">Facebook</label>
                                    <div class="input-group">
                                        <input type="text" class="form-control" name="facebook" value="{{ $config->facebook }}" id="validationCustom003" required>

                                    </div>
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label for="validationCustom004">Twitter</label>
                                    <div class="input-group">
                                        <input type="text" class="form-control" name="twitter" value="{{ $config->twitter }}" id="validationCustom004" required>

                                    </div>
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label for="validationCustom005">Instagram</label>
                                    <div class="input-group">
                                        <input type="text" class="form-control" name="instagram" value="{{ $config->instagram }}" id="validationCustom005" required>

                                    </div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="col-md-12 mb-2">
                                    <label>Address</label>
                                    <div class="input-group">
                                        <textarea class="form-control" name="address" id="exampleTextarea" rows="3">{{ $config->address }}</textarea>

                                    </div>
                                </div>
                                <div class="col-md-12 mb-2">
                                    <label>Copyight</label>
                                    <div class="input-group">
                                        <textarea class="form-control" name="copyright" id="exampleTextarea1" rows="3">{{ $config->copyright }}</textarea>

                                    </div>
                                </div>
                                <div class="col-md-12 mb-2">
                                    <label>Footer description</label>
                                    <div class="input-group">
                                        <textarea class="form-control" name="foot_desc" id="exampleTextarea2" rows="3">{{ $config->foot_desc }}</textarea>

                                    </div>
                                </div>
                                <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                                    <label>Notice</label>
                                    <div class="input-group">
                                        <textarea class="form-control tinyEditor" name="announcement" id="exampleTextarea3" rows="3">{{ $config->announcement }}</textarea>
                                    </div>
                                </div>
                                <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                                    <label>Timing</label>
                                    <div class="input-group">
                                        <textarea class="form-control tinyEditor" name="timing" id="exampleTextarea4" rows="3">{{ $config->timing }}</textarea>
                                    </div>
                                </div>
                            </div>
                            <button class="btn btn-primary mt-4 d-inline w-20" type="submit">Update</button>
                        </form>

                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
