@extends('admin.layouts.master')
@section('content')
    <div class="ms-content-wrapper">
        <div class="row">
            <div class="col-md-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb pl-0">
                        <li class="breadcrumb-item"><a href="javascript:;"><i class="material-icons">home</i> Home</a></li>
                        <li class="breadcrumb-item"><a href="javascript:;">{{ $title }}</a></li>
                    </ol>
                </nav>
                <div class="ms-panel">
                    <div class="ms-panel-header ms-panel-custome">
                        <h6>{{ $title }}</h6>
                    </div>
                    <div class="ms-panel-body">
                        <div class="filter-area">
                            <div class="filter-box">
                                <h5>Filter by</h5>
                                <form action="" method="GET" id="filterForm">
                                    <div class="input-group">
                                        <select class="form-control filteryBy" name="filter_by" required>
                                            <option selected disabled>select option</option>
                                            <option value="all" {{ (isset($filterby) && $filterby == 'all') ? 'selected' : '' }}>All</option>
                                            <option value="weekly" {{ (isset($filterby) && $filterby == 'weekly') ? 'selected' : '' }}>Current Week</option>
                                            <option value="monthly" {{ (isset($filterby) && $filterby == 'monthly') ? 'selected' : '' }}>Current Month</option>
                                        </select>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <div class="table-responsive">
                            <table class="table table-striped thead-primary w-100 dataTable-main appointmentData">
                                <thead>
                                    <tr>
                                        <th scope="col">#</th>
                                        <th scope="col">Name</th>
                                        <th scope="col">Phone Number</th>
                                        <th scope="col">SSN</th>
                                        <th scope="col">Appointment Date & Time</th>
                                        {{-- <th scope="col">Appointment Problem</th> --}}
                                        <th scope="col">Check In</th>
                                        <th scope="col">Check Out</th>
                                        <th scope="col">Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($allAppointments as $key => $item)
                                        <tr>
                                            <th scope="row">{{ $key + 1 }}</th>
                                            <td>{{ $item->name ?? '' }}</td>
                                            <td>
                                                @if (empty($item->phone_number))
                                                    {{ $item->user->phone ?? '-' }}
                                                @else
                                                    {{ $item->phone_number ?? '-' }}
                                                @endif
                                            </td>
                                            <td>
                                                @if (empty($item->social_security_number))
                                                    {{ $item->user->social_security_number ?? '-' }}
                                                @else
                                                    {{ $item->social_security_number ?? '-' }}
                                                @endif
                                            </td>
                                            <td>
                                                <ul class="formatTime">
                                                    <li>
                                                        <h4>Date</h4>
                                                        <p>{{ $item->appointment_date ? \Carbon\Carbon::parse($item->appointment_date)->format('M d, Y') : '' }}
                                                        </p>
                                                    </li>
                                                    <li>
                                                        <h4>Time</h4>
                                                        <p>{{ $item->appointment_time ? \Carbon\Carbon::parse($item->appointment_time)->format('h:i A') : '' }}
                                                        </p>
                                                    </li>
                                                </ul>
                                            </td>
                                            {{-- <td>{{ $item->problem ?? '' }}</td> --}}
                                            <td>
                                                @if ($item->status == 'cancel')
                                                    <p>-----</p>
                                                @else
                                                    @if ($item->check_in == '')
                                                        <p>-----</p>
                                                    @else
                                                        @php
                                                            $dateTime = new \DateTime($item->check_in);
                                                            $formattedDate = $dateTime->format('F j, Y');
                                                            $formattedTime = $dateTime->format('h:i:s A');
                                                        @endphp
                                                        <ul class="formatTime">
                                                            <li>
                                                                <h4>Date</h4>
                                                                <p>{{ $formattedDate }}</p>
                                                            </li>
                                                            <li>
                                                                <h4>Time</h4>
                                                                <p>{{ $formattedTime }}</p>
                                                            </li>
                                                        </ul>
                                                    @endif
                                                @endif
                                            </td>
                                            <td>
                                                @if ($item->status == 'cancel')
                                                    <p>-----</p>
                                                @else
                                                    <div class="btn-box">
                                                        @if ($item->is_checked == 0)
                                                            <p>-----</p>
                                                        @else
                                                            @if ($item->check_out == '')
                                                                <p>-----</p>
                                                            @else
                                                                @php
                                                                    $dateTime = new \DateTime($item->check_out);
                                                                    $formattedDate = $dateTime->format('F j, Y');
                                                                    $formattedTime = $dateTime->format('h:i:s A');
                                                                @endphp
                                                                <ul class="formatTime">
                                                                    <li>
                                                                        <h4>Date</h4>
                                                                        <p>{{ $formattedDate }}</p>
                                                                    </li>
                                                                    <li>
                                                                        <h4>Time</h4>
                                                                        <p>{{ $formattedTime }}</p>
                                                                    </li>
                                                                </ul>
                                                            @endif
                                                        @endif
                                                    </div>
                                                @endif
                                            </td>
                                            <td>
                                                @if ($item->status == 'pending')
                                                    <h2 class="main-status pending">Pending</h2>
                                                @elseif ($item->status == 'cancel')
                                                    <h2 class="main-status cancel">Cancel</h2>
                                                @elseif ($item->status == 'completed')
                                                    <h2 class="main-status completed">Completed</h2>
                                                @else
                                                    <h2 class="main-status approve">Approve</h2>
                                                @endif
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('scripts')
    <script>
        $(document).on('change', '.filteryBy', function() {
            $("#filterForm").submit();
        });
    </script>
@endsection

