<?php $__env->startSection('content'); ?>
    <div class="ms-content-wrapper">
        <div class="row">
            <div class="col-md-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb pl-0">
                        <li class="breadcrumb-item"><a href="javascript:;"><i class="material-icons">home</i> Home</a></li>
                        <li class="breadcrumb-item"><a href="javascript:;">Membership Manage</a></li>
                    </ol>
                </nav>
                <div class="ms-panel">
                    <div class="ms-panel-header ms-panel-custome">
                        <h6>Membership Manage</h6>
                    </div>
                    <div class="ms-panel-body">
                        <h2>You have bought a <?php echo e($membership->package->type); ?> package</h2>
                        <div class="row">
                            <div class="col-12 col-sm-12 col-md-6 col-lg-4 col-xl-3 col-xxl-3">
                                <div class="package-card">
                                    <div class="top">
                                        <h2><?php echo e($membership->package->title); ?></h2>
                                        <p><span>$</span><?php echo e($membership->amount); ?></p>
                                    </div>
                                    <div class="bottom">
                                        <?php echo $membership->package->desc; ?>

                                        <div class="exp-info">
                                            <h5>Expiry date:</h5>
                                            <p><?php echo e(\Carbon\Carbon::parse($membership->expiry_date)->format('F j, Y')); ?></p>
                                        </div>
                                        <div class="btn-box">
                                            <a href="javascript:;" class="btn btn-primary update-membership">Update
                                                Membership</a>
                                            <a href="javascript:;" data-id="<?php echo e($membership->id); ?>"
                                                class="btn btn-danger remove-item">Cancel Membership</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="membershipModal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog ms-modal-dialog-width">
            <div class="modal-content ms-modal-content-width">
                <div class="modal-header  ms-modal-header-radius-0">
                    <h4 class="modal-title text-white">Update Membership</h4>
                    <button type="button" class="close  text-white" data-dismiss="modal" aria-hidden="true">x</button>
                </div>
                <div class="modal-body p-0 text-left">
                    <div class="col-xl-12 col-md-12">
                        <div class="ms-panel ms-panel-bshadow-none">
                            <div class="ms-panel-header">
                                <h6>Update Membership</h6>
                            </div>
                            <div class="ms-panel-body">
                                <div class="row justify-content-center">
                                    <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="col-12 col-sm-12 col-md-6 col-lg-4 col-xl-4 col-xxl-4">
                                            <div class="package-card">
                                                <div class="top">
                                                    <h2><?php echo e($item->title); ?></h2>
                                                    <p><span>$</span><?php echo e($item->price); ?></p>
                                                </div>
                                                <div class="bottom">
                                                    <?php echo $item->desc; ?>

                                                    <div class="btn-box">
                                                        <a href="javascript:;" data-id="<?php echo e($item->id); ?>"
                                                            data-price="<?php echo e($item->price); ?>"
                                                            class="btn btn-wh payNow-membership">Buy now</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="paymentModal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog ms-modal-dialog-width">
            <div class="modal-content ms-modal-content-width">
                <div class="modal-header  ms-modal-header-radius-0">
                    <h4 class="modal-title text-white">Purchase Membership</h4>
                    <button type="button" class="close  text-white" data-dismiss="modal" aria-hidden="true">x</button>
                </div>
                <div class="modal-body p-0 text-left">
                    <div class="col-xl-12 col-md-12">
                        <div class="ms-panel ms-panel-bshadow-none">
                            <div class="ms-panel-header">
                                <h6>Purchase Membership</h6>
                            </div>
                            <div class="ms-panel-body">
                                <div class="row justify-content-center">
                                    <div class="col">
                                        <form role="form" action="<?php echo e(route('cloverApi')); ?>" method="post"
                                            id="payment-form">
                                            <?php echo csrf_field(); ?>

                                            <input type="hidden" name="package_id" id="packageId" value="">
                                            <input type="hidden" name="amount" id="packagePrice" value="">
                                            

                                            <div class="form-row row mt-4">
                                                <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                                                    <div class="form-group required">
                                                        <label class='control-label'>Card Number</label>
                                                        <input autocomplete='off' name="number"
                                                            class='form-control card-number' size='20' type='text'>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="form-row row mt-4">
                                                <div class="col-12 col-sm-12 col-md-4 col-lg-4 col-xl-4 col-xxl-4">
                                                    <div class="form-group cvc required">
                                                        <label class='control-label'>CVV</label>
                                                        <input autocomplete='off' name="cvv"
                                                            class='form-control card-cvc' placeholder='ex. 311'
                                                            size='4' type='text'>
                                                    </div>
                                                </div>
                                                <div class="col-12 col-sm-12 col-md-4 col-lg-4 col-xl-4 col-xxl-4">
                                                    <div class="form-group expiration required">
                                                        <label class='control-label'>Expiration Month</label>
                                                        <input class='form-control card-expiry-month' name="expmonth"
                                                            placeholder='MM' size='2' type='text' required>
                                                    </div>
                                                </div>
                                                <div class="col-12 col-sm-12 col-md-4 col-lg-4 col-xl-4 col-xxl-4">
                                                    <div class="form-group expiration required">
                                                        <label class='control-label'>Expiration Year</label>
                                                        <input class='form-control card-expiry-year' name="expyear"
                                                            placeholder='YYYY' size='4' type='text' required>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="row mt-4">
                                                <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12">
                                                    <button class="btn btn-primary" type="submit">Pay Now</button>
                                                </div>
                                            </div>

                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?>
    <style>
        [class*="card-"] {
            border: 1px solid rgba(0, 0, 0, 0.1);
        }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        $(document).on('click', '.remove-item', function() {
            var ele_id = $(this).data('id');
            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#0073b1',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        type: 'post',
                        dataType: 'json',
                        url: "<?php echo e(route('admin.cancelMembership')); ?>",
                        data: {
                            id: ele_id,
                            _token: '<?php echo e(csrf_token()); ?>'
                        },
                        success: function(response) {
                            if (response.status == 0) {
                                toastr.error(response.message);
                            } else {
                                window.location.href = '<?php echo e(route("web.home")); ?>';
                                // toastr.success(response.message);
                            }
                        }
                    });
                    console.log("here");
                }
            })
        });

        $(document).on('click', '.update-membership', function() {
            $('#membershipModal').modal('show');
        });

        $(document).on('click', '.payNow-membership', function() {
            var pkgId = $(this).attr('data-id');
            var pkgPrice = $(this).attr('data-price');
            $('#paymentModal').modal('show');
            $('#membershipModal').modal('hide');
            $('#packageId').val(pkgId);
            $('#packagePrice').val(pkgPrice);
        });

        $('#paymentModal').on('hidden.bs.modal', function () {
            $('#payment-form')[0].reset();
            $('#packageId').val('');
            $('#packagePrice').val('');
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\Ahmed-Shoaib\laravel-projects\holistic-Laravel\resources\views/admin/pages/patient/membershipMange.blade.php ENDPATH**/ ?>