<?php $__env->startSection('content'); ?>
    <div class="ms-content-wrapper">
        <div class="row">
            <div class="col-md-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb pl-0">
                        <li class="breadcrumb-item"><a href="#"><i class="material-icons">home</i> Home</a></li>
                        <li class="breadcrumb-item"><a href="#">Appointment</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Make Appointment</li>
                    </ol>
                </nav>
            </div>
            <div class="col-xl-12 col-md-12">
                <div class="ms-panel">
                    <div class="ms-panel-header ms-panel-custome">
                        <h6>Make Appointment</h6>
                    </div>
                    <div class="ms-panel-body">
                        <form class="needs-validation form-details" novalidate>
                            <input type="hidden" id="user_id" name="user_id" value="<?php echo e(Auth::user()->id ?? ''); ?>">
                            <input type="hidden" id="user_name" name="name" value="<?php echo e(Auth::user()->name ?? ''); ?>">
                            <input type="hidden" id="user_email" name="name" value="<?php echo e(Auth::user()->email ?? ''); ?>">
                            <input type="hidden" id="user_phone" name="phone_number" value="<?php echo e(Auth::user()->phone ?? ''); ?>">
                            <input type="hidden" id="user_ssn" name="social_security_number" value="<?php echo e(Auth::user()->social_security_number ?? ''); ?>">
                            <div class="form-row">
                                <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 mb-3">
                                    <label>Appointment Date</label>
                                    <div class="input-group">
                                        <input type="date" class="form-control appointmentDate" name="appointment_date"
                                            id="appointmentDate" placeholder="Appointment Date is required" required>
                                    </div>
                                </div>
                                <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 mb-3">
                                    <label>Choose Doctor</label>
                                    <div class="input-group">
                                        <select class="form-control providerSelect" id="providerId" name="provider_id" required>
                                            <option selected disabled>Select Doctor</option>
                                            <?php $__currentLoopData = $doctors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($item->id); ?>" data-name="<?php echo e($item->name); ?>"><?php echo e($item->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div id="doctor-error-msg" class="invalid-feedback">Doctor is required</div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12 mb-2" id="schedules"
                                    style="display: none;">
                                    <label>Appointment Time</label>
                                    <div class="day-select"></div>
                                </div>
                            </div>

                            <div class="form-row">
                                <div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12 mb-2">
                                    <label>Red Flag</label>
                                    <div class="input-group">
                                        <textarea class="form-control" id="problem" rows="3" placeholder="Red Flag" name="problem" required></textarea>
                                    </div>
                                </div>
                            </div>
                            <button class="btn btn-primary mt-4 d-inline w-20 appointmntSubmit" type="button">Save</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script type="text/javascript">
        $(document).on('click', '.appointmntSubmit', function() {
            var isValid = true;
            $('.form-details input, .form-details select, .form-details textarea').each(function() {
                if ($(this).prop('required') && !$(this).val()) {
                    isValid = false;
                    toastr.error($(this).attr('placeholder') || 'Select Doctor is required');
                }
            });

            if (!isValid) {
                return;
            }

            var $button = $(this);
            var originalText = $button.text();
            $button.text('Submitting...').css({
                'cursor': 'not-allowed',
                'pointer-events': 'none'
            });

            var user_id = $('#user_id').val();
            var name = $('#user_name').val();
            var email = $('#user_email').val();
            var phone_number = $('#user_phone').val();
            var social_security_number = $('#user_ssn').val();
            var provider_id = $('#providerId').val();
            var provider_name = $('#providerId option:selected').attr('data-name');
            console.log(provider_name);
            var appointment_date = $("input[name='appointment_time']:checked").attr('data-daydate'); //$('#appointmentDate').val();
            var appointment_time = $("input[name='appointment_time']:checked").val();
            var problem = $('#problem').val();
            $.ajax({
                type: 'POST',
                url: '<?php echo e(route('admin.patientAppointmnetSubmit')); ?>',
                datatype: 'json',
                data: {
                    user_id: user_id,
                    name: name,
                    user_email: email,
                    phone_number: phone_number,
                    social_security_number: social_security_number,
                    provider_id: provider_id,
                    provider_name: provider_name,
                    appointment_date: appointment_date,
                    appointment_time: appointment_time,
                    problem: problem,
                    _token: '<?php echo e(csrf_token()); ?>'
                },
                success: function(data) {
                    console.log(data);
                    setTimeout(function() {
                        location.reload();
                    }, 1000);
                    toastr.success(data.message);
                }
            });
        });

        $(document).on('change', '.providerSelect', function() {
            $('#schedules').css("display", "block");
            appointmentData();
        });

        $(document).on('change', '.appointmentDate', function() {
            var selectedDay = getSelectedDay();
            appointmentData(selectedDay);
        });

        document.addEventListener('DOMContentLoaded', function () {
            var today = new Date().toISOString().split('T')[0]; // Get today's date in YYYY-MM-DD format
            document.getElementById("appointmentDate").setAttribute('min', today);
        });

        function getSelectedDay() {
            var selectedDate = $('#appointmentDate').val();
            var date = new Date(selectedDate);
            console.log(date);
            var dayOfWeek = date.toLocaleDateString('en-US', { weekday: 'long' });
            return dayOfWeek;
        }

        function appointmentData(selectedDay) {
            var provider_id = $('.providerSelect').val();
            var user_id = $('#user_id').val();
            var appointment_date = $('#appointmentDate').val();
            if (provider_id == null || provider_id == '' || appointment_date == null || appointment_date == '' ) {
                return;
            }

            $.ajax({
                type: 'GEt',
                url: '<?php echo e(route('admin.getRooms')); ?>',
                datatype: 'json',
                data: {
                    provider_id: provider_id,
                    user_id: user_id,
                    appointment_date: appointment_date,
                    selected_day: selectedDay,
                },
                success: function(data) {
                    console.log(data);
                    // schedulesApp(data);
                    if (data.rooms.length != undefined && data.rooms.length != null && data.rooms.length > 0) {
                        schedulesApp2(data,appointment_date);
                    } else {
                        $('.day-select').html('<h2>Not available</h2>');
                    }
                }
            });
        }

        function selectedDays(appointment_date) {
            var selectedDate = new Date(appointment_date);
            var selectedDayIndex = selectedDate.getDay();
            var daysOfWeek = ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];

            var adjustedDaysOfWeek = daysOfWeek.slice(selectedDayIndex).concat(daysOfWeek.slice(0, selectedDayIndex));
            var daysHtml = '';
            adjustedDaysOfWeek.forEach(function(day) {
                daysHtml += `<th scope="col">${day}</th>`;
            });
            console.log(daysHtml);
            return daysHtml;
        }

        function schedulesApp(data,appointment_date) {
            var roomsHtml = ``;
            for (let index = 0; index < data.rooms.length; index++) {
                const element = data.rooms[index];
                roomsHtml = roomsHtml+`<th scope="col">${element.day}</th>`;
            }

            roomsHtml = selectedDays(appointment_date);

            var durationHtml = ``;
            for (let index = 0; index < data.rooms.length; index++) {
                const room = data.rooms[index];
                durationHtml = durationHtml+'<td>';
                for (let j = 0; j < room.available_time.length; j++) {
                    const singleTime = room.available_time[j];
                    var disabled = '';
                    if (room.booked_times.includes(singleTime)) {
                        disabled = 'disabled';
                    }
                    durationHtml = durationHtml+`<div class="form-check">
                                        <input class="form-check-input" type="radio"
                                            name="appointment_time" ${disabled}
                                            id="availableTime-${index}-${j}" value="${singleTime}">
                                        <label class="form-check-label"
                                            for="availableTime-${index}-${j}">
                                            ${singleTime}
                                        </label>
                                    </div>`;
                }
                durationHtml = durationHtml+'</td>';

            }

            var html = `
            <table class="table">
                <thead>
                    <tr>
                        ${roomsHtml}
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        ${durationHtml}
                    </tr>
                </tbody>
            </table>
            `
            $('.day-select').html(html);
        }

        function schedulesApp2(data,appointment_date) {
            var selectedDate = new Date(appointment_date);
            var selectedDayIndex = selectedDate.getDay();
            var daysOfWeek = ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];

            var adjustedDaysOfWeek = daysOfWeek.slice(selectedDayIndex).concat(daysOfWeek.slice(0, selectedDayIndex));
            var daysHtml = '';
            var durationHtml = ``;
            adjustedDaysOfWeek.forEach(function(day) {
                daysHtml += `<th scope="col">${day}</th>`;

                const roomIndex = data.rooms.findIndex((sRoom)=> sRoom.day.toLowerCase() == day.toLowerCase());
                if(roomIndex == -1){
                    durationHtml = durationHtml+'<td></td>';
                    return;
                }
                const room = data.rooms[roomIndex];

                durationHtml = durationHtml+'<td>';
                var dayDate = room.day_date;
                for (let j = 0; j < room.available_time.length; j++) {
                    const singleTime = room.available_time[j];
                    var disabled = '';
                    console.log('booked_times', room.booked_times.includes(singleTime))
                    if (room.booked_times.includes(singleTime)) {
                        disabled = 'disabled';
                    }
                    durationHtml = durationHtml+`<div class="form-check">
                                        <input class="form-check-input" type="radio"
                                            name="appointment_time" ${disabled} data-daydate="${dayDate}"
                                            id="availableTime-${roomIndex}-${j}" value="${singleTime}">
                                        <label class="form-check-label"
                                            for="availableTime-${roomIndex}-${j}">
                                            ${singleTime}
                                        </label>
                                    </div>`;
                }
                durationHtml = durationHtml+'</td>';
            });
            console.log(daysHtml);


            roomsHtml = daysHtml

            var html = `
            <table class="table">
                <thead>
                    <tr>
                        ${roomsHtml}
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        ${durationHtml}
                    </tr>
                </tbody>
            </table>
            `
            $('.day-select').html(html);
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\Ahmed-Shoaib\laravel-projects\holistic-Laravel\resources\views/admin/pages/patient/appointment.blade.php ENDPATH**/ ?>